/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax.spi;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.DefaultElementContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensibleSAXParser {
    private final DefaultElementContext _context;
    private SAXParser _parser;
    private Handler _handler;
    private Locator _locator;

    private void $init$() {
        this._context = this.createInitialContext();
        this._parser = null;
        this._handler = null;
    }

    protected DefaultElementContext createInitialContext() {
        return new DefaultElementContext();
    }

    public ElementContext getContext() {
        return this._context;
    }

    public void parse(XMLLocator locator) throws ParserConfigurationException, SAXException, IOException {
        if (this._parser == null) {
            this._handler = new Handler(null);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this._parser = factory.newSAXParser();
            XMLReader reader = this._parser.getXMLReader();
            reader.setContentHandler(this._handler);
            reader.setErrorHandler(this._handler);
        }
        this._context.setLocator(locator);
        this._parser.getXMLReader().parse(locator.createInputSource());
    }

    private ElementHandler lookupHandler() {
        ElementHandler scopedHandler = this._context.getScopedHandler();
        return scopedHandler;
    }

    public ExtensibleSAXParser() {
        this.$init$();
    }

    static DefaultElementContext ra$_context(ExtensibleSAXParser extensibleSAXParser) {
        return extensibleSAXParser._context;
    }

    static Locator ra$_locator(ExtensibleSAXParser extensibleSAXParser) {
        return extensibleSAXParser._locator;
    }

    static void wa$_locator(ExtensibleSAXParser extensibleSAXParser, Locator locator) {
        extensibleSAXParser._locator = locator;
    }

    static ElementHandler mav$lookupHandler(ExtensibleSAXParser extensibleSAXParser) {
        return extensibleSAXParser.lookupHandler();
    }

    private class Handler
    extends DefaultHandler {
        public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).beginElement(uri, name, attributes);
            ElementHandler handler = ExtensibleSAXParser.mav$lookupHandler(ExtensibleSAXParser.this);
            if (handler != null) {
                try {
                    this.recordPosition();
                    handler.handleStart(ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this));
                }
                catch (HandlerException he) {
                    throw new SAXException(he);
                }
            }
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).postBeginElement();
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).endElement(uri, name);
            ElementHandler handler = ExtensibleSAXParser.mav$lookupHandler(ExtensibleSAXParser.this);
            if (handler != null) {
                try {
                    this.recordPosition();
                    handler.handleEnd(ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this));
                }
                catch (HandlerException he) {
                    throw new SAXException(he);
                }
            }
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).postEndElement();
        }

        public void characters(char[] ch, int start, int length) {
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).appendCharacters(ch, start, length);
        }

        public void setDocumentLocator(Locator locator) {
            ExtensibleSAXParser.wa$_locator(ExtensibleSAXParser.this, locator);
        }

        private void recordPosition() {
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).getLocator().setLineNumber(ExtensibleSAXParser.ra$_locator(ExtensibleSAXParser.this).getLineNumber());
            ExtensibleSAXParser.ra$_context(ExtensibleSAXParser.this).getLocator().setColumnNumber(ExtensibleSAXParser.ra$_locator(ExtensibleSAXParser.this).getColumnNumber());
        }

        private Handler() {
        }

        Handler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

