/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.text.AttributedCharacterIterator;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.graphics.GraphicUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingUtils {
    public static final String STARTUP_WINDOW_KEY = "javatools.startup.window";
    public static final String MAIN_WINDOW_KEY = "javatools.main.window";
    public static final String PROGRAM_NAME_KEY = "javatools.program.name";
    public static final String PROGRAM_SHORT_NAME_KEY = "javatools.program.short.name";

    private SwingUtils() {
    }

    public static Frame findFrame(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
    }

    public static Window findAncestorFrameOrDialog(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        if (component instanceof Dialog) {
            return (Dialog)component;
        }
        Class[] classes = new Class[]{Frame.class, Dialog.class};
        return (Window)SwingUtils.getAncestorOfClasses(classes, component);
    }

    public static Container getAncestorOfClasses(Class<?>[] classes, Component comp) {
        if (comp == null || classes == null) {
            return null;
        }
        Container parent = comp.getParent();
        while (parent != null) {
            Class<?>[] classArray = classes;
            int n = 0;
            while (n < classArray.length) {
                Class<?> clazz = classArray[n];
                if (clazz.isInstance(parent)) {
                    return parent;
                }
                ++n;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Frame getMainWindow() {
        return SwingUtils.getFrame(MAIN_WINDOW_KEY, true);
    }

    public static Frame getStartupWindow() {
        return SwingUtils.getFrame(STARTUP_WINDOW_KEY, false);
    }

    public static Frame getToplevelWindow() {
        Frame result = null;
        Frame candidate = SwingUtils.getFrame(MAIN_WINDOW_KEY, false);
        if (candidate != null) {
            result = candidate;
            if (!candidate.isVisible() && (candidate = SwingUtils.getFrame(STARTUP_WINDOW_KEY, false)) != null) {
                candidate.setVisible(true);
                if ((candidate.getState() & 1) != 0) {
                    candidate.setState(0);
                }
                candidate.toFront();
                result = candidate;
            }
        } else {
            candidate = SwingUtils.getFrame(STARTUP_WINDOW_KEY, true);
            if (candidate != null) {
                candidate.setVisible(true);
                if ((candidate.getState() & 1) != 0) {
                    candidate.setState(0);
                }
                candidate.toFront();
                result = candidate;
            }
        }
        return result;
    }

    private static Frame getFrame(String key, boolean useAny) {
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            int n = frames.length;
            Frame firstNonNullFrame = null;
            int i = 0;
            while (i < n) {
                JFrame jFrame;
                Frame frame = frames[i];
                if (firstNonNullFrame == null && frame != null) {
                    firstNonNullFrame = frame;
                }
                if (frame instanceof JFrame && Boolean.TRUE.equals((jFrame = (JFrame)frame).getRootPane().getClientProperty(key))) {
                    return jFrame;
                }
                ++i;
            }
            if (firstNonNullFrame != null && useAny) {
                return firstNonNullFrame;
            }
        }
        return null;
    }

    public static void setMainWindow(JFrame frame) {
        Frame oldFrame = SwingUtils.getFrame(MAIN_WINDOW_KEY, false);
        if (oldFrame != frame) {
            if (oldFrame instanceof JFrame) {
                ((JFrame)oldFrame).getRootPane().putClientProperty(MAIN_WINDOW_KEY, null);
            }
            if (frame != null) {
                frame.getRootPane().putClientProperty(MAIN_WINDOW_KEY, Boolean.TRUE);
            }
        }
    }

    public static void setStartupWindow(JFrame frame) {
        Frame oldFrame = SwingUtils.getStartupWindow();
        if (oldFrame != frame) {
            if (oldFrame instanceof JFrame) {
                ((JFrame)oldFrame).getRootPane().putClientProperty(STARTUP_WINDOW_KEY, null);
            }
            if (frame != null) {
                frame.getRootPane().putClientProperty(STARTUP_WINDOW_KEY, Boolean.TRUE);
            }
        }
    }

    private static String getStringClientProperty(String propertyName) {
        String name = null;
        Frame frame = SwingUtils.getMainWindow();
        if (frame instanceof JFrame) {
            name = (String)((JFrame)frame).getRootPane().getClientProperty(propertyName);
        }
        return name != null ? name : "";
    }

    public static String getProgramName() {
        return SwingUtils.getStringClientProperty(PROGRAM_NAME_KEY);
    }

    public static void setProgramName(String name) {
        SwingUtils.setStringClientProperty(PROGRAM_NAME_KEY, name);
    }

    private static void setStringClientProperty(String propertyName, String value) {
        Frame frame = SwingUtils.getMainWindow();
        if (frame instanceof JFrame) {
            ((JFrame)frame).getRootPane().putClientProperty(propertyName, value);
        }
    }

    public static String getProgramShortName() {
        return SwingUtils.getStringClientProperty(PROGRAM_SHORT_NAME_KEY);
    }

    public static void setProgramShortName(String name) {
        SwingUtils.setStringClientProperty(PROGRAM_SHORT_NAME_KEY, name);
    }

    public static Dialog getAncestorDialog(Component parent) {
        return parent != null ? (parent instanceof Dialog ? (Dialog)parent : (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent)) : null;
    }

    public static Frame getAncestorFrame(Component parent) {
        return parent != null ? (parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent)) : null;
    }

    public static void removeKeyStrokesFromInputMaps(JComponent component, KeyStroke[] keyStrokes) {
        SwingUtils.removeKeyStrokesFromInputMap(component, keyStrokes, 1);
        SwingUtils.removeKeyStrokesFromInputMap(component, keyStrokes, 0);
        SwingUtils.removeKeyStrokesFromInputMap(component, keyStrokes, 2);
    }

    public static void removeKeyStrokesFromInputMap(JComponent component, KeyStroke[] keyStrokes, int mapType) {
        InputMap map = SwingUtilities.getUIInputMap(component, mapType);
        if (map == null) {
            return;
        }
        int i = 0;
        while (i < keyStrokes.length) {
            KeyStroke keyStroke = keyStrokes[i];
            if (keyStroke != null) {
                map.remove(keyStroke);
            }
            ++i;
        }
        SwingUtilities.replaceUIInputMap(component, mapType, map);
    }

    public static boolean useTextAntialiasing() {
        return GraphicUtils.useTextAntialiasing();
    }

    public static void drawChars(Graphics graphics, char[] data, int offset, int length, int x, int y) {
        GraphicUtils.drawChars((Graphics)graphics, (char[])data, (int)offset, (int)length, (int)x, (int)y);
    }

    public static void drawString(Graphics graphics, String text, int x, int y) {
        GraphicUtils.drawString((Graphics)graphics, (String)text, (int)x, (int)y);
    }

    public static void drawString(Graphics2D graphics2d, String text, float x, float y) {
        GraphicUtils.drawString((Graphics2D)graphics2d, (String)text, (float)x, (float)y);
    }

    public static void drawString(Graphics graphics, AttributedCharacterIterator iterator, int x, int y) {
        GraphicUtils.drawString((Graphics)graphics, (AttributedCharacterIterator)iterator, (int)x, (int)y);
    }

    public static void invokeAfterRepaint(Runnable runnable) {
        if (SwingUtils.hasPaintEventsPending()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            1 awtEventListener = new 1(toolkit, runnable);
            toolkit.addAWTEventListener(awtEventListener, 8192L);
        } else {
            try {
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean hasPaintEventsPending() {
        boolean ret = false;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        if (eventQueue.peekEvent(800) != null || eventQueue.peekEvent(801) != null) {
            ret = true;
        }
        return ret;
    }

    public static void dispatch(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    static boolean maS$hasPaintEventsPending() {
        return SwingUtils.hasPaintEventsPending();
    }

    static final class 1
    implements AWTEventListener {
        private final /* synthetic */ Toolkit v$toolkit;
        private final /* synthetic */ Runnable v$runnable;

        public void eventDispatched(AWTEvent event) {
            int eventId = event.getID();
            if (!(eventId != 800 && eventId != 801 || SwingUtils.maS$hasPaintEventsPending())) {
                this.v$toolkit.removeAWTEventListener(this);
                EventQueue.invokeLater(this.v$runnable);
            }
        }

        public 1(Toolkit toolkit, Runnable runnable) {
            this.v$runnable = runnable;
            this.v$toolkit = toolkit;
        }
    }
}

