/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.File;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final int FILEPATH_MAX_DISPLAY_LENGTH = 80;

    private StringUtil() {
    }

    public static String truncateFileNameForMessage(String path) {
        int len = path.length();
        if (len <= 80) {
            return path;
        }
        int sepIdx = path.indexOf(File.separatorChar);
        if (sepIdx != -1) {
            String[] pathBits = StringUtil.getTokenArray(path, File.separator);
            int nameWidth = pathBits[pathBits.length - 1].length() + 1;
            int remainingSpace = 80 - (nameWidth + 3);
            if (remainingSpace <= 0) {
                return pathBits[pathBits.length - 1].substring(0, 77) + "...";
            }
            StringBuffer fullString = new StringBuffer(80);
            int widthSoFar = 0;
            int i = 0;
            while (i < pathBits.length - 1) {
                String thisToken = pathBits[i] + File.separator;
                int thisTokenLength = thisToken.length();
                if (widthSoFar + thisTokenLength >= remainingSpace) break;
                fullString.append(thisToken);
                widthSoFar += thisTokenLength;
                ++i;
            }
            fullString.append("...");
            fullString.append(File.separatorChar);
            fullString.append(pathBits[pathBits.length - 1]);
            return fullString.toString();
        }
        return path.substring(0, 80) + "...";
    }

    public static String[] getTokenArray(String string, String delimiters) {
        StringTokenizer tok = new StringTokenizer(string, delimiters);
        String[] tokens = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            tokens[i++] = tok.nextToken();
        }
        return tokens;
    }
}

