/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal.xml;

import java.lang.reflect.Method;
import oracle.javatools.marshal.ToStringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyInfo
implements Comparable {
    private final String _xmlName;
    private final Method _readMethod;
    private final Method _writeMethod;
    private final boolean _isAttribute;
    private final boolean _isOmittedWhenNull;

    PropertyInfo(String xmlName, Class beanClass, String getter, String setter, boolean isAttribute) {
        this(xmlName, beanClass, getter, setter, isAttribute, false);
    }

    PropertyInfo(String xmlName, Class beanClass, String getter, String setter, boolean isAttribute, boolean isOmittedWhenNull) {
        this._xmlName = xmlName;
        try {
            this._readMethod = beanClass.getMethod(getter, null);
            Class<?> propertyClass = this._readMethod.getReturnType();
            Class[] argType = new Class[]{propertyClass};
            this._writeMethod = beanClass.getMethod(setter, argType);
        }
        catch (Exception e) {
            String internalMesg = "\n#######  Error in " + (beanClass != null ? beanClass.getName() : "null") + " PropertyInfo with XML name = '" + xmlName + "', getter = '" + getter + "', setter = '" + setter + "'  #######\n";
            System.err.println(internalMesg);
            throw new IllegalArgumentException(internalMesg);
        }
        this._isAttribute = this.initIsAttribute(isAttribute);
        this._isOmittedWhenNull = isOmittedWhenNull;
    }

    PropertyInfo(String xmlName, Method readMethod, Method writeMethod, boolean isAttribute, boolean isOmittedWhenNull) {
        this._xmlName = xmlName;
        this._readMethod = readMethod;
        this._writeMethod = writeMethod;
        this._isAttribute = this.initIsAttribute(isAttribute);
        this._isOmittedWhenNull = isOmittedWhenNull;
    }

    private boolean initIsAttribute(boolean isAttribute) {
        if (isAttribute) {
            Class<?> propertyClass = this._readMethod.getReturnType();
            if (ToStringManager.converterAvailable(propertyClass)) {
                return true;
            }
            System.err.println("***  Warning: There is no String converter for " + propertyClass.toString() + ", so this property will be saved as an element instead of an attribute.");
        }
        return false;
    }

    public String getXMLName() {
        return this._xmlName;
    }

    public Class getPropertyClass() {
        return this._readMethod.getReturnType();
    }

    public Object getPropertyValue(Object owningObject) {
        try {
            Object object = this._readMethod.invoke(owningObject, null);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var4_4 = null;
            return var4_4;
        }
    }

    public void setPropertyValue(Object owningObject, Object value) throws Exception {
        Object[] args = new Object[]{value};
        this._writeMethod.invoke(owningObject, args);
    }

    Method getReadMethod() {
        return this._readMethod;
    }

    Method getWriteMethod() {
        return this._writeMethod;
    }

    public boolean isAttribute() {
        return this._isAttribute;
    }

    public boolean isOmittedWhenNull() {
        return this._isOmittedWhenNull;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        PropertyInfo info = (PropertyInfo)o;
        if (this.equalsImpl(info)) {
            return 0;
        }
        return this._xmlName.compareTo(info._xmlName);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PropertyInfo)o);
    }

    private boolean equalsImpl(PropertyInfo info) {
        return PropertyInfo.areEqual(this._xmlName, info._xmlName) && PropertyInfo.areEqual(this._readMethod, info._readMethod) && PropertyInfo.areEqual(this._writeMethod, info._writeMethod) && this._isAttribute == info._isAttribute && this._isOmittedWhenNull == info._isOmittedWhenNull;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

