/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.marshal.Character2String;
import oracle.javatools.marshal.Class2String;
import oracle.javatools.marshal.StringConversion;

public final class ToStringManager {
    private static final Class _stringClass = String.class;
    private static final Class _stringConversionClass = StringConversion.class;
    private static Map __fromStringMethodMap = new HashMap(23);
    private static Map __toStringMethodMap = new HashMap(23);
    private static Map __primitiveToWrapped = new HashMap(15);
    private static Set __stringConvertibles = new HashSet(23);

    static {
        __primitiveToWrapped.put(Integer.TYPE, Integer.class);
        __primitiveToWrapped.put(Long.TYPE, Long.class);
        __primitiveToWrapped.put(Short.TYPE, Short.class);
        __primitiveToWrapped.put(Float.TYPE, Float.class);
        __primitiveToWrapped.put(Double.TYPE, Double.class);
        __primitiveToWrapped.put(Character.TYPE, Character.class);
        __primitiveToWrapped.put(Byte.TYPE, Byte.class);
        __primitiveToWrapped.put(Boolean.TYPE, Boolean.class);
        ToStringManager.registerStringConvertible(_stringClass);
        ToStringManager.registerStringConvertible(Integer.class);
        ToStringManager.registerStringConvertible(Long.class);
        ToStringManager.registerStringConvertible(Short.class);
        ToStringManager.registerStringConvertible(Float.class);
        ToStringManager.registerStringConvertible(Double.class);
        ToStringManager.registerStringConvertible(Byte.class);
        ToStringManager.registerStringConvertible(Boolean.class);
        ToStringManager.registerStringConvertible(BigInteger.class);
        ToStringManager.registerStringConvertible(BigDecimal.class);
        ToStringManager.registerCustomConverter(Character2String.class);
        ToStringManager.registerCustomConverter(Class2String.class);
    }

    private ToStringManager() {
    }

    public static boolean registerStringConvertible(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return __stringConvertibles.add(clazz);
    }

    public static boolean registerCustomConverter(Class converterClass) {
        if (converterClass == null) {
            return false;
        }
        Class supportedClass = null;
        try {
            if (!Modifier.isPublic(converterClass.getModifiers())) {
                boolean bl = false;
                return bl;
            }
            Method supportedClassMethod = converterClass.getMethod("supportedClass", null);
            if (!Modifier.isPublic(supportedClassMethod.getModifiers())) {
                boolean bl = false;
                return bl;
            }
            supportedClass = (Class)supportedClassMethod.invoke(null, null);
            Class[] toStringArgs = new Class[]{supportedClass};
            Method toStringMethod = converterClass.getMethod("toString", toStringArgs);
            int toStringMethodModifiers = toStringMethod.getModifiers();
            if (!Modifier.isStatic(toStringMethodModifiers) || !Modifier.isPublic(toStringMethodModifiers)) {
                boolean bl = false;
                return bl;
            }
            if (toStringMethod.getReturnType() != _stringClass) {
                boolean bl = false;
                return bl;
            }
            Class[] fromStringArgs = new Class[]{_stringClass};
            Method fromStringMethod = converterClass.getMethod("fromString", fromStringArgs);
            int fromStringMethodModifiers = fromStringMethod.getModifiers();
            if (!Modifier.isStatic(fromStringMethodModifiers) || !Modifier.isPublic(fromStringMethodModifiers)) {
                boolean bl = false;
                return bl;
            }
            if (fromStringMethod.getReturnType() != supportedClass) {
                boolean bl = false;
                return bl;
            }
            __toStringMethodMap.put(supportedClass, toStringMethod);
            __fromStringMethodMap.put(supportedClass, fromStringMethod);
        }
        catch (NoSuchMethodException e) {
            boolean bl = false;
            return bl;
        }
        catch (InvocationTargetException e) {
            boolean bl = false;
            return bl;
        }
        catch (IllegalAccessException e) {
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException e) {
            boolean bl = false;
            return bl;
        }
        catch (ClassCastException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public static Class wrapPrimitive(Class primitive) {
        if (primitive == null) {
            return null;
        }
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        return (Class)__primitiveToWrapped.get(primitive);
    }

    public static boolean converterAvailable(Object object) {
        if (object == null) {
            return false;
        }
        return ToStringManager.converterAvailable(object.getClass());
    }

    public static boolean converterAvailable(String typeStr) {
        if (typeStr == null) {
            return false;
        }
        try {
            boolean bl = ToStringManager.converterAvailable(Class.forName(typeStr));
            return bl;
        }
        catch (ClassNotFoundException e) {
            boolean bl = false;
            return bl;
        }
    }

    public static boolean converterAvailable(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (__stringConvertibles.contains(type) || _stringConversionClass.isAssignableFrom(type)) {
            return true;
        }
        if (__toStringMethodMap.containsKey(type) && __fromStringMethodMap.containsKey(type)) {
            return true;
        }
        return Enum.class.isAssignableFrom(type);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return ToStringManager.toString(obj, obj.getClass());
    }

    public static String toString(Object obj, Class objClass) {
        if (obj == null || objClass == null) {
            return null;
        }
        if (objClass.isPrimitive()) {
            objClass = (Class)__primitiveToWrapped.get(objClass);
        }
        if (!objClass.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("obj cannot be printed as objClass");
        }
        if (__stringConvertibles.contains(objClass) || _stringConversionClass.isAssignableFrom(objClass)) {
            return obj.toString();
        }
        if (__toStringMethodMap.containsKey(objClass)) {
            Method toStringMethod = (Method)__toStringMethodMap.get(objClass);
            Object[] toStringArgs = new Object[]{obj};
            try {
                String string = (String)toStringMethod.invoke(null, toStringArgs);
                return string;
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            return null;
        }
        if (Enum.class.isAssignableFrom(objClass)) {
            return ((Enum)obj).name();
        }
        throw new UnsupportedOperationException("Unable to convert the given object to a String: " + obj != null ? obj.getClass().getName() : "null");
    }

    public static Object fromString(String s, Class targetClass) {
        if (targetClass == null) {
            return null;
        }
        if (targetClass == _stringClass) {
            return s;
        }
        if (targetClass.isPrimitive()) {
            targetClass = (Class)__primitiveToWrapped.get(targetClass);
        }
        if (__stringConvertibles.contains(targetClass) || _stringConversionClass.isAssignableFrom(targetClass)) {
            try {
                Class[] constructorArgTypes = new Class[]{_stringClass};
                Constructor constructor = targetClass.getConstructor(constructorArgTypes);
                Object[] constructorArgs = new Object[]{s};
                Object t = constructor.newInstance(constructorArgs);
                return t;
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (__fromStringMethodMap.containsKey(targetClass)) {
            Method fromStringMethod = (Method)__fromStringMethodMap.get(targetClass);
            Object[] fromStringArgs = new Object[]{s};
            try {
                Object object = fromStringMethod.invoke(null, fromStringArgs);
                return object;
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            return null;
        }
        if (Enum.class.isAssignableFrom(targetClass)) {
            return Enum.valueOf(targetClass, s);
        }
        throw new UnsupportedOperationException("Unable to convert the String \"" + s + "\" to an Object of type " + targetClass.getName());
    }
}

