/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import oracle.javatools.logging.Diagnostics;

public final class EventThreadHangMonitor
extends EventQueue {
    private static final EventQueue INSTANCE = new EventThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS;
    private static final boolean LOG_ALL_THREADS;
    private static final boolean KEEP_DUMPING;
    private static final boolean LOG_TO_DIAGNOSTIC_DIR;
    private static AWTEvent currentEvent;
    private static int count;
    private static PrintStream logStream;
    private static final long NO_CURRENT_EVENT = 0L;
    private long startedLastEventDispatchAt;
    private boolean reportedHang;
    private Thread eventDispatchThread;
    private static final String THREAD_NAME = "EventDispatchThreadHangMonitor";

    static {
        count = 0;
        logStream = null;
        long duration = 500L;
        try {
            duration = Integer.parseInt(System.getProperty("ide.awthangmonitor.threshold", "500"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        UNREASONABLE_DISPATCH_DURATION_MS = duration;
        LOG_ALL_THREADS = Boolean.getBoolean("ide.awthangmonitor.allthreads");
        KEEP_DUMPING = Boolean.getBoolean("ide.awthangmonitor.keepdumping");
        LOG_TO_DIAGNOSTIC_DIR = Boolean.getBoolean("ide.awthangmonitor.autologfiles");
    }

    private static PrintStream openLogFile() {
        File file = Diagnostics.newLockedFile((String)"AWTHANGCHECK");
        try {
            logStream = new PrintStream(new FileOutputStream(file, true));
            OutputStreamWriter writer = new OutputStreamWriter(logStream);
            Diagnostics.writeBanner((Writer)writer, (String)("AWT EDT Hang Monitor logging started at " + new Date()));
            logStream.println();
            Diagnostics.writeBanner((Writer)writer, (String)"Configuration");
            logStream.println("Monitor threshold: " + UNREASONABLE_DISPATCH_DURATION_MS + "ms");
            logStream.println("Log all threads: " + LOG_ALL_THREADS);
            logStream.println("Keep dumping: " + KEEP_DUMPING);
            Diagnostics.writeSystemConfiguration((Writer)writer);
            logStream.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return logStream;
    }

    private void $init$() {
        this.startedLastEventDispatchAt = 0L;
        this.reportedHang = false;
        this.eventDispatchThread = null;
    }

    private EventThreadHangMonitor() {
        this.$init$();
        this.initTimer();
    }

    private void initTimer() {
        long initialDelayMs = 0L;
        boolean isDaemon = true;
        Timer timer = new Timer(THREAD_NAME, true);
        timer.schedule((TimerTask)new HangChecker(null), 0L, (long)100);
    }

    private long timeSoFar() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.startedLastEventDispatchAt;
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    protected void dispatchEvent(AWTEvent event) {
        this.preDispatchEvent(event);
        super.dispatchEvent(event);
        this.postDispatchEvent();
    }

    private synchronized void preDispatchEvent(AWTEvent event) {
        if (!EventQueue.isDispatchThread()) {
            this.stream().println("WARNING! Event posted on non-event thread " + Thread.currentThread() + ": " + event);
        }
        if (this.eventDispatchThread == null) {
            this.eventDispatchThread = Thread.currentThread();
        }
        currentEvent = event;
        this.reportedHang = false;
        this.startedLastEventDispatchAt = System.currentTimeMillis();
    }

    private synchronized void postDispatchEvent() {
        if (this.reportedHang) {
            this.stream().println(">>> [" + this.timeSoFar() + "ms] Event dispatch thread unstuck processing " + currentEvent);
            this.stream().println();
            if (LOG_TO_DIAGNOSTIC_DIR) {
                this.stream().close();
                logStream = null;
            }
        }
        this.startedLastEventDispatchAt = 0L;
    }

    private PrintStream stream() {
        if (!LOG_TO_DIAGNOSTIC_DIR) {
            return System.out;
        }
        if (logStream != null) {
            return logStream;
        }
        EventThreadHangMonitor.openLogFile();
        if (logStream == null) {
            return System.out;
        }
        return logStream;
    }

    static boolean ra$KEEP_DUMPING() {
        return KEEP_DUMPING;
    }

    static boolean ra$reportedHang(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.reportedHang;
    }

    static Thread ra$eventDispatchThread(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.eventDispatchThread;
    }

    static PrintStream mav$stream(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.stream();
    }

    static long mav$timeSoFar(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.timeSoFar();
    }

    static int ra$count() {
        return count;
    }

    static void wa$count(int n) {
        count = n;
    }

    static long ra$UNREASONABLE_DISPATCH_DURATION_MS() {
        return UNREASONABLE_DISPATCH_DURATION_MS;
    }

    static AWTEvent ra$currentEvent() {
        return currentEvent;
    }

    static void wa$reportedHang(EventThreadHangMonitor eventThreadHangMonitor, boolean bl) {
        eventThreadHangMonitor.reportedHang = bl;
    }

    static boolean ra$LOG_ALL_THREADS() {
        return LOG_ALL_THREADS;
    }

    static long ra$startedLastEventDispatchAt(EventThreadHangMonitor eventThreadHangMonitor) {
        return eventThreadHangMonitor.startedLastEventDispatchAt;
    }

    static EventQueue ra$INSTANCE() {
        return INSTANCE;
    }

    private class HangChecker
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EventQueue eventQueue = EventThreadHangMonitor.ra$INSTANCE();
            synchronized (eventQueue) {
                this.checkForHang();
            }
        }

        private void checkForHang() {
            if (EventThreadHangMonitor.ra$startedLastEventDispatchAt(EventThreadHangMonitor.this) == 0L) {
                return;
            }
            if (EventThreadHangMonitor.mav$timeSoFar(EventThreadHangMonitor.this) > EventThreadHangMonitor.ra$UNREASONABLE_DISPATCH_DURATION_MS()) {
                this.reportHang();
            }
        }

        private void reportHang() {
            if (!EventThreadHangMonitor.ra$KEEP_DUMPING() && EventThreadHangMonitor.ra$reportedHang(EventThreadHangMonitor.this)) {
                return;
            }
            StackTraceElement[] edtStackTrace = EventThreadHangMonitor.ra$eventDispatchThread(EventThreadHangMonitor.this).getStackTrace();
            if (EventThreadHangMonitor.ra$reportedHang(EventThreadHangMonitor.this)) {
                EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this).println("--- [" + EventThreadHangMonitor.mav$timeSoFar(EventThreadHangMonitor.this) + "ms] still processing event");
            } else {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this));
                StringBuilder stringBuilder = new StringBuilder().append("[");
                int n = EventThreadHangMonitor.ra$count() + 1;
                EventThreadHangMonitor.wa$count(n);
                Diagnostics.writeBanner((Writer)outputStreamWriter, (String)stringBuilder.append(n).append("] AWT hang exceeding ").append(EventThreadHangMonitor.ra$UNREASONABLE_DISPATCH_DURATION_MS()).append("ms detected").toString());
                EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this).println("<<< [" + EventThreadHangMonitor.mav$timeSoFar(EventThreadHangMonitor.this) + "ms] event dispatch thread stuck processing event " + EventThreadHangMonitor.ra$currentEvent());
            }
            EventThreadHangMonitor.wa$reportedHang(EventThreadHangMonitor.this, true);
            if (EventThreadHangMonitor.ra$LOG_ALL_THREADS()) {
                Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
                EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this).println("Full thread dump at " + new Date() + ":");
                for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                    Thread thread = entry.getKey();
                    if (EventThreadHangMonitor.THREAD_NAME.equals(thread.getName())) continue;
                    StackTraceElement[] stackTrace = entry.getValue();
                    EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this).printf("\"%s\" %s prio=%s %s%n", thread.getName(), thread.isDaemon() ? "daemon" : "", String.valueOf(thread.getPriority()), String.valueOf((Object)thread.getState()).toLowerCase());
                    this.printStackTrace(EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this), stackTrace);
                    EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this).println();
                }
            } else {
                this.printStackTrace(EventThreadHangMonitor.mav$stream(EventThreadHangMonitor.this), edtStackTrace);
            }
        }

        private void printStackTrace(PrintStream out, StackTraceElement[] stackTrace) {
            if (stackTrace.length == 0) {
                out.println("    (no stack)");
            }
            String ourEventQueueClassName = EventThreadHangMonitor.class.getName();
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = 0;
            while (n < stackTraceElementArray.length) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n];
                if (stackTraceElement.getClassName().equals(ourEventQueueClassName)) {
                    return;
                }
                out.println("    " + stackTraceElement);
                ++n;
            }
        }

        private HangChecker() {
        }

        HangChecker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

