/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.history;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryModelEvent;
import oracle.javatools.history.HistoryModelListener;

public abstract class AbstractHistoryModel
implements HistoryModel {
    private List _listenerList;
    private boolean _isComplete;

    private void $init$() {
        this._isComplete = true;
    }

    protected void fireEntriesInserted(int start, int end) {
        if (EventQueue.isDispatchThread()) {
            this.fireEntriesInsertedImpl(start, end);
        } else {
            EventQueue.invokeLater(new 1(this, start, end));
        }
    }

    private void fireEntriesInsertedImpl(int start, int end) {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this, start, end);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).entriesInserted(vhe);
            }
        }
    }

    protected void fireEntriesRemoved(int start, int end) {
        if (EventQueue.isDispatchThread()) {
            this.fireEntriesRemovedImpl(start, end);
        } else {
            EventQueue.invokeLater(new 2(this, start, end));
        }
    }

    private void fireEntriesRemovedImpl(int start, int end) {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this, start, end);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).entriesRemoved(vhe);
            }
        }
    }

    protected void fireEntriesChanged(int start, int end) {
        if (EventQueue.isDispatchThread()) {
            this.fireEntriesChangedImpl(start, end);
        } else {
            EventQueue.invokeLater(new 3(this, start, end));
        }
    }

    private void fireEntriesChangedImpl(int start, int end) {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this, start, end);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).entriesChanged(vhe);
            }
        }
    }

    protected void fireCompletenessChanged() {
        if (EventQueue.isDispatchThread()) {
            this.fireCompletenessChangedImpl();
        } else {
            EventQueue.invokeLater(new 4());
        }
    }

    private void fireCompletenessChangedImpl() {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).completenessChanged(vhe);
            }
        }
    }

    public void addHistoryModelListener(HistoryModelListener vhl) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList(1);
        }
        this._listenerList.add(vhl);
    }

    public void removeHistoryModelListener(HistoryModelListener vhl) {
        if (this._listenerList != null) {
            this._listenerList.remove(vhl);
            if (this._listenerList.isEmpty()) {
                this._listenerList = null;
            }
        }
    }

    public final synchronized void setComplete(boolean complete) {
        this._isComplete = complete;
        this.fireCompletenessChanged();
    }

    public final synchronized boolean isComplete() {
        return this._isComplete;
    }

    public AbstractHistoryModel() {
        this.$init$();
    }

    static void mav$fireCompletenessChangedImpl(AbstractHistoryModel abstractHistoryModel) {
        abstractHistoryModel.fireCompletenessChangedImpl();
    }

    static void mav$fireEntriesChangedImpl(AbstractHistoryModel abstractHistoryModel, int n, int n2) {
        abstractHistoryModel.fireEntriesChangedImpl(n, n2);
    }

    static void mav$fireEntriesRemovedImpl(AbstractHistoryModel abstractHistoryModel, int n, int n2) {
        abstractHistoryModel.fireEntriesRemovedImpl(n, n2);
    }

    static void mav$fireEntriesInsertedImpl(AbstractHistoryModel abstractHistoryModel, int n, int n2) {
        abstractHistoryModel.fireEntriesInsertedImpl(n, n2);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ int v$start;
        private final /* synthetic */ int v$end;
        final /* synthetic */ AbstractHistoryModel this$0;

        public void run() {
            AbstractHistoryModel.mav$fireEntriesInsertedImpl(this.this$0, this.v$start, this.v$end);
        }

        public 1(AbstractHistoryModel abstractHistoryModel, int n, int n2) {
            this.v$end = n2;
            this.v$start = n;
            this.this$0 = abstractHistoryModel;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ int v$start;
        private final /* synthetic */ int v$end;
        final /* synthetic */ AbstractHistoryModel this$0;

        public void run() {
            AbstractHistoryModel.mav$fireEntriesRemovedImpl(this.this$0, this.v$start, this.v$end);
        }

        public 2(AbstractHistoryModel abstractHistoryModel, int n, int n2) {
            this.v$end = n2;
            this.v$start = n;
            this.this$0 = abstractHistoryModel;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ int v$start;
        private final /* synthetic */ int v$end;
        final /* synthetic */ AbstractHistoryModel this$0;

        public void run() {
            AbstractHistoryModel.mav$fireEntriesChangedImpl(this.this$0, this.v$start, this.v$end);
        }

        public 3(AbstractHistoryModel abstractHistoryModel, int n, int n2) {
            this.v$end = n2;
            this.v$start = n;
            this.this$0 = abstractHistoryModel;
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            AbstractHistoryModel.mav$fireCompletenessChangedImpl(AbstractHistoryModel.this);
        }
    }
}

