/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;
import oracle.javatools.util.Log;

public final class StatusBarPlugin
implements ActionListener,
ChangeListener,
EditorPlugin,
FeedbackManager {
    private BasicEditorPane editor = null;
    private JPanel mainPanel;
    private StatusBarCell feedbackCell;
    private StatusBarCell insertOverwriteCell;
    private StatusBarCell lineNumberCell;
    private StatusBarCell eolTypeCell;
    private StatusBarCell modifiedCell;
    private Timer feedbackTimer;
    private Timer caretTimer;
    private static final int CARET_TIMER_DELAY = 100;
    private int lastOffset;
    private int lastId;
    private static final Log LOG = new Log("expiration");
    private static char[] digitArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final Border EMPTY_PIXEL_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 3, 0, 3);
    public static final Border ETCHED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), EMPTY_BORDER);
    public static final Border BEVEL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), EMPTY_BORDER);
    public static final String BLANK_MESSAGE = " ";
    public static final String INSERT_MODE;
    public static final String OVERWRITE_MODE;
    public static final String LINE_COLUMN;
    public static final String EOL_MACINTOSH;
    public static final String EOL_UNIX;
    public static final String EOL_WINDOWS;
    public static final String MODIFIED;
    public static final String READ_ONLY;
    public static final String PROTECTED;
    public static final String[] INSERT_OVERWRITE_CELL_STRINGS;
    public static final String[] EOL_CELL_STRINGS;
    public static final String[] MODIFIED_CELL_STRINGS;
    public static final String[] LINE_NUMBER_CELL_STRINGS;
    private static final StringBuffer scratchBuffer;

    public StatusBarPlugin() {
        this(ETCHED_BORDER, null);
    }

    public StatusBarPlugin(Font font) {
        this(ETCHED_BORDER, font);
    }

    public StatusBarPlugin(Border border) {
        this(border, null);
    }

    public StatusBarPlugin(Border border, Font font) {
        this.createPanel(border, font);
    }

    public void install(BasicEditorPane editor) {
        this.lastOffset = -1;
        this.lastId = -1;
        this.editor = editor;
        editor.addFeedbackManager(this);
        Caret caret = editor.getCaret();
        caret.addChangeListener(this);
        this.feedbackTimer = new Timer(5000, this);
        this.feedbackTimer.setRepeats(false);
        this.caretTimer = new Timer(100, this);
        this.caretTimer.setRepeats(false);
        this.updateAllCells();
        StatusBarUpdater.mav$registerStatusBar(StatusBarUpdater.maS$getUpdater(), this);
    }

    public void deinstall(BasicEditorPane editor) {
        StatusBarUpdater.mav$unregisterStatusBar(StatusBarUpdater.maS$getUpdater(), this);
        this.feedbackTimer.stop();
        this.feedbackTimer = null;
        this.caretTimer.stop();
        this.caretTimer = null;
        Caret caret = editor.getCaret();
        if (caret != null) {
            caret.removeChangeListener(this);
        }
        editor.removeFeedbackManager(this);
        editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        boolean updateCells = false;
        if (propertyName.equals("caret")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Caret) {
                Caret caret = (Caret)oldValue;
                caret.removeChangeListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Caret) {
                Caret caret = (Caret)newValue;
                caret.addChangeListener(this);
            }
            updateCells = true;
        } else if (propertyName.equals("tab-size")) {
            updateCells = true;
        }
        if (updateCells) {
            this.lastOffset = -1;
            this.lastId = -1;
            this.updateAllCells();
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (!this.caretTimer.isRunning()) {
            this.caretTimer.restart();
        }
    }

    public void showFeedback(BasicEditorPane editorPane, String feedbackMessage) {
        this.feedbackTimer.stop();
        this.feedbackCell.setText(feedbackMessage);
    }

    public void showFeedback(BasicEditorPane editorPane, String feedbackMessage, int milliSeconds) {
        this.feedbackTimer.stop();
        this.feedbackTimer.setInitialDelay(milliSeconds);
        this.feedbackTimer.setDelay(milliSeconds);
        this.feedbackTimer.start();
        this.feedbackCell.setText(feedbackMessage);
    }

    public void hideFeedback(BasicEditorPane editorPane) {
        this.feedbackTimer.stop();
        this.feedbackCell.setText(BLANK_MESSAGE);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.feedbackTimer) {
            this.feedbackCell.setText(BLANK_MESSAGE);
        } else if (source == this.caretTimer) {
            this.updateAllCells();
        }
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void createPanel(Border border, Font font) {
        this.feedbackCell = new StatusBarCell("Feedback", border, null);
        this.feedbackCell.setText(BLANK_MESSAGE);
        this.insertOverwriteCell = new StatusBarCell("Insert", border, INSERT_OVERWRITE_CELL_STRINGS);
        this.insertOverwriteCell.setHorizontalAlignment(2);
        this.eolTypeCell = new StatusBarCell("EOL", border, EOL_CELL_STRINGS);
        this.eolTypeCell.setHorizontalAlignment(2);
        this.modifiedCell = new StatusBarCell("Modified", border, MODIFIED_CELL_STRINGS);
        this.modifiedCell.setHorizontalAlignment(2);
        this.lineNumberCell = new StatusBarCell("LineCol", border, LINE_NUMBER_CELL_STRINGS);
        this.lineNumberCell.setHorizontalAlignment(2);
        if (font != null) {
            this.feedbackCell.setFont(font);
            this.insertOverwriteCell.setFont(font);
            this.lineNumberCell.setFont(font);
            this.eolTypeCell.setFont(font);
            this.modifiedCell.setFont(font);
        }
        Insets defaultInsets = new Insets(1, 1, 1, 1);
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(EMPTY_PIXEL_BORDER);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.mainPanel.add((Component)this.lineNumberCell, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.mainPanel.add((Component)this.insertOverwriteCell, constraints);
        constraints = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.mainPanel.add((Component)this.feedbackCell, constraints);
        constraints = new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.mainPanel.add((Component)this.modifiedCell, constraints);
        constraints = new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.mainPanel.add((Component)this.eolTypeCell, constraints);
    }

    private int getTabSize() {
        Integer tabInteger = (Integer)this.editor.getProperty("tab-size");
        int tabSize = tabInteger != null ? tabInteger : 8;
        return tabSize;
    }

    private void updateAllCells() {
        try {
            this.updateCaretCell();
            this.updateOtherCells();
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in StatusBarPlugin.updateAllCells: {0}", (Object)e);
        }
    }

    private void updateCaretCell() {
        if (this.editor != null) {
            String lineText = BLANK_MESSAGE;
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            int line = 0;
            int column = 0;
            document.readLock();
            try {
                int offset = this.editor.getCaretPosition();
                if (offset == this.lastOffset && textBuffer.getChangeId() == this.lastId) {
                    return;
                }
                this.lastOffset = offset;
                this.lastId = textBuffer.getChangeId();
                LineMap lineMap = document.getLineMap();
                line = lineMap.getLineFromOffset(offset);
                int tabSize = this.getTabSize();
                column = Utilities.getColumnFromOffset(textBuffer, line, offset, tabSize);
            }
            finally {
                document.readUnlock();
            }
            lineText = StatusBarPlugin.getLineColumnText(LINE_COLUMN, ++line, ++column);
            this.lineNumberCell.setText(lineText);
        }
    }

    private void appendNumber(StringBuffer buffer, int num) {
        if (num < 10) {
            buffer.append(digitArray[num]);
            return;
        }
        int numDigits = StatusBarPlugin.numDigits(num);
        int i = 0;
        while (i < numDigits) {
            buffer.append(' ');
            ++i;
        }
        int currentNum = num;
        int currentOffset = buffer.length() + numDigits - 1;
        while (numDigits-- > 0) {
            int remainder = currentNum % 10;
            currentNum /= 10;
            buffer.setCharAt(currentOffset--, digitArray[remainder]);
        }
    }

    private static int numDigits(int number) {
        if (number < 100) {
            return number < 10 ? 1 : 2;
        }
        if (number < 10000) {
            return number < 1000 ? 3 : 4;
        }
        int digits = 0;
        do {
            ++digits;
        } while ((number /= 10) != 0);
        return digits;
    }

    private void updateOtherCells() {
        if (this.editor != null) {
            String oldModifiedText;
            String oldEOLText;
            String oldInsertText;
            BasicCaret basicCaret;
            boolean inInsertMode;
            Caret caret;
            String insertText = BLANK_MESSAGE;
            String modifiedText = BLANK_MESSAGE;
            String eolTypeText = BLANK_MESSAGE;
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            boolean readOnly = textBuffer.isReadOnly();
            boolean isProtected = this.editor.isProtected();
            insertText = readOnly ? READ_ONLY : (isProtected ? PROTECTED : ((caret = this.editor.getCaret()) != null && caret instanceof BasicCaret ? ((inInsertMode = (basicCaret = (BasicCaret)caret).getInsertMode()) ? INSERT_MODE : OVERWRITE_MODE) : INSERT_MODE));
            String eolType = textBuffer.getEOLType();
            eolTypeText = eolType == "\r\n" ? EOL_WINDOWS : (eolType == "\n" ? EOL_UNIX : EOL_MACINTOSH);
            if (textBuffer.isModified()) {
                modifiedText = MODIFIED;
            }
            if ((oldInsertText = this.insertOverwriteCell.getText()) != insertText) {
                this.insertOverwriteCell.setText(insertText);
            }
            if ((oldEOLText = this.eolTypeCell.getText()) != eolTypeText) {
                this.eolTypeCell.setText(eolTypeText);
            }
            if ((oldModifiedText = this.modifiedCell.getText()) != modifiedText) {
                this.modifiedCell.setText(modifiedText);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getLineColumnText(String template, int line, int column) {
        String resultText;
        StringBuffer stringBuffer = scratchBuffer;
        synchronized (stringBuffer) {
            scratchBuffer.delete(0, scratchBuffer.length());
            scratchBuffer.append(LINE_COLUMN);
            int linePos = LINE_COLUMN.indexOf("{0}");
            int columnPos = LINE_COLUMN.indexOf("{1}");
            if (linePos < columnPos) {
                if (columnPos != -1) {
                    scratchBuffer.replace(columnPos, columnPos + 3, Integer.toString(column));
                }
                if (linePos != -1) {
                    scratchBuffer.replace(linePos, linePos + 3, Integer.toString(line));
                }
            } else {
                if (linePos != -1) {
                    scratchBuffer.replace(linePos, linePos + 3, Integer.toString(line));
                }
                if (columnPos != -1) {
                    scratchBuffer.replace(columnPos, columnPos + 3, Integer.toString(column));
                }
            }
            resultText = scratchBuffer.toString();
        }
        return resultText;
    }

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        INSERT_MODE = resources.getString("STATUS_INSERT");
        OVERWRITE_MODE = resources.getString("STATUS_OVERWRITE");
        LINE_COLUMN = resources.getString("STATUS_LINE_COLUMN");
        EOL_MACINTOSH = resources.getString("STATUS_EOL_MAC");
        EOL_UNIX = resources.getString("STATUS_EOL_UNIX");
        EOL_WINDOWS = resources.getString("STATUS_EOL_WINDOWS");
        MODIFIED = resources.getString("STATUS_MODIFIED");
        READ_ONLY = resources.getString("STATUS_READONLY");
        PROTECTED = resources.getString("STATUS_PROTECTED");
        scratchBuffer = new StringBuffer();
        INSERT_OVERWRITE_CELL_STRINGS = new String[]{INSERT_MODE, OVERWRITE_MODE, READ_ONLY, PROTECTED};
        EOL_CELL_STRINGS = new String[]{EOL_MACINTOSH, EOL_UNIX, EOL_WINDOWS};
        MODIFIED_CELL_STRINGS = new String[]{MODIFIED};
        LINE_NUMBER_CELL_STRINGS = new String[]{StatusBarPlugin.getLineColumnText(LINE_COLUMN, 1234, 123)};
    }

    static void mav$updateAllCells(StatusBarPlugin statusBarPlugin) {
        statusBarPlugin.updateAllCells();
    }

    protected static class StatusBarCell
    extends JLabel {
        private String[] cellStrings;
        private int minimumHeight = 0;
        private int minimumWidth = 0;
        private int preferredWidth = 0;

        protected StatusBarCell(String cellName, Border border, String[] cellStrings) {
            this.cellStrings = cellStrings;
            this.setName(cellName);
            this.setBorder(border);
        }

        protected void updateSize() {
            Font font = this.getFont();
            if (font != null) {
                FontMetrics metrics = this.getFontMetrics(font);
                int width = metrics.stringWidth(this.getText());
                if (this.cellStrings != null) {
                    int listSize = this.cellStrings.length;
                    int i = 0;
                    while (i < listSize) {
                        width = Math.max(width, metrics.stringWidth(this.cellStrings[i]));
                        ++i;
                    }
                }
                int height = metrics.getHeight();
                int insetHeight = 0;
                int insetWidth = 0;
                Border border = this.getBorder();
                if (border != null) {
                    Insets insets = border.getBorderInsets(this);
                    insetHeight = insets.top + insets.bottom;
                    insetWidth = insets.left + insets.right;
                }
                this.minimumHeight = height + insetHeight;
                this.minimumWidth = width + insetWidth;
                this.preferredWidth = this.minimumWidth + metrics.charWidth('m');
            }
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.minimumWidth, this.minimumHeight);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.minimumHeight);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.updateSize();
        }

        public void setBorder(Border border) {
            super.setBorder(border);
            this.updateSize();
        }
    }

    private static final class StatusBarUpdater
    implements ActionListener {
        private static final StatusBarUpdater singleton = new StatusBarUpdater();
        private static final int UPDATE_DELAY = 1000;
        private List statusbarList = new ArrayList();
        private Timer updateTimer = new Timer(1000, this);

        private static StatusBarUpdater getUpdater() {
            return singleton;
        }

        private StatusBarUpdater() {
            this.updateTimer.setRepeats(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerStatusBar(StatusBarPlugin statusbar) {
            List list = this.statusbarList;
            synchronized (list) {
                WeakReference<StatusBarPlugin> ref = new WeakReference<StatusBarPlugin>(statusbar);
                this.statusbarList.add(ref);
            }
            this.updateTimer.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterStatusBar(StatusBarPlugin statusbar) {
            List list = this.statusbarList;
            synchronized (list) {
                int size = this.statusbarList.size();
                int i = 0;
                while (i < size) {
                    WeakReference ref;
                    Object obj = this.statusbarList.get(i);
                    if (obj != null && (ref = (WeakReference)obj).get() == statusbar) {
                        ref.clear();
                        this.statusbarList.set(i, null);
                        break;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            List list = this.statusbarList;
            synchronized (list) {
                int size = this.statusbarList.size();
                int i = size - 1;
                while (i >= 0) {
                    WeakReference ref;
                    Object obj = this.statusbarList.get(i);
                    if (obj != null && (ref = (WeakReference)obj).get() != null) {
                        StatusBarPlugin statusbar = (StatusBarPlugin)ref.get();
                        StatusBarPlugin.mav$updateAllCells(statusbar);
                    } else {
                        this.statusbarList.remove(i);
                    }
                    --i;
                }
                if (this.statusbarList.size() == 0) {
                    this.updateTimer.stop();
                }
            }
        }

        static StatusBarUpdater maS$getUpdater() {
            return StatusBarUpdater.getUpdater();
        }

        static void mav$unregisterStatusBar(StatusBarUpdater statusBarUpdater, StatusBarPlugin statusBarPlugin) {
            statusBarUpdater.unregisterStatusBar(statusBarPlugin);
        }

        static void mav$registerStatusBar(StatusBarUpdater statusBarUpdater, StatusBarPlugin statusBarPlugin) {
            statusBarUpdater.registerStatusBar(statusBarPlugin);
        }
    }
}

