/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.ExtendedBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;

public final class BraceMatchingPlugin
implements ActionHookInvoker,
ActionListener,
CaretListener,
DocumentListener,
EditorPlugin {
    private static HighlightStyle braceMatchStyle1;
    private static HighlightStyle braceMatchStyle2;
    private static HighlightStyle nonMatchingStyle;
    private static HighlightStyle enclosingBlockStyle;
    private static HighlightStyle enclosingParenStyle;
    private HighlightLayer highlightLayer;
    private BasicEditorPane editor;
    private boolean doHighlighting = false;
    private boolean doBlocks;
    private boolean doParens;
    private NumberRange braceLocation;
    private NumberRange matchingLocation;
    private Timer delayedTimer = null;
    private static final int MATCHING_TIMER_DELAY = 300;
    public static final int DEFAULT_BRACE_PRIORITY = 80;
    public static final String HIGHLIGHT_BRACE_MATCH1 = "brace-match1-highlight";
    public static final String HIGHLIGHT_BRACE_MATCH2 = "brace-match2-highlight";
    public static final String HIGHLIGHT_BRACE_MISMATCH = "brace-mismatch-highlight";
    public static final String HIGHLIGHT_ENCLOSING_BLOCK = "enclosing-block-highlight";
    public static final String HIGHLIGHT_ENCLOSING_PARENS = "enclosing-parens-highlight";

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addActionHookInvoker(this);
        editor.addCaretListener(this);
        Document document = editor.getDocument();
        document.addDocumentListener(this);
        this.doHighlighting = false;
        this.updateEnabled();
        this.braceLocation = new NumberRange(0, 0);
        this.matchingLocation = new NumberRange(0, 0);
        this.delayedTimer = new Timer(300, this);
        this.delayedTimer.setRepeats(false);
        this.updateTimerDelay();
        this.scheduleMatch();
    }

    public void deinstall(BasicEditorPane editor) {
        this.delayedTimer.stop();
        this.delayedTimer = null;
        editor.removeCaretListener(this);
        editor.removeActionHookInvoker(this);
        Document document = editor.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.highlightLayer != null) {
            editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        editor = null;
        this.doHighlighting = false;
        this.braceLocation = null;
        this.matchingLocation = null;
    }

    protected void updateEnabled() {
        this.doHighlighting = this.editor.getBooleanProperty("brace-matching-auto");
        this.doBlocks = this.editor.getBooleanProperty("brace-matching-enclosing-blocks");
        this.doParens = this.editor.getBooleanProperty("brace-matching-enclosing-parens");
    }

    protected void updateTimerDelay() {
        int delay = this.editor.getIntegerProperty("brace-matching-delay");
        this.delayedTimer.setInitialDelay(delay);
        this.delayedTimer.setDelay(delay);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        EditorProperties globalProperties = EditorProperties.getProperties();
        boolean updateEnabled = false;
        if (propertyName.equals("language-support")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-auto")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-enclosing-blocks")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-enclosing-parens")) {
            updateEnabled = true;
        } else if (propertyName.equals("brace-matching-delay")) {
            this.updateTimerDelay();
        } else if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                Document document = (Document)oldValue;
                document.removeDocumentListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                Document document = (Document)newValue;
                document.addDocumentListener(this);
            }
            updateEnabled = true;
        }
        if (updateEnabled) {
            this.updateEnabled();
            if (this.doHighlighting) {
                this.scheduleMatch();
            }
        }
    }

    public void caretUpdate(CaretEvent event) {
        this.scheduleMatch();
    }

    public void insertUpdate(DocumentEvent event) {
        this.scheduleMatch();
    }

    public void removeUpdate(DocumentEvent event) {
        this.scheduleMatch();
    }

    public void changedUpdate(DocumentEvent event) {
        this.scheduleMatch();
    }

    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("show-matching-brace")) {
            this.performBraceHighlighting(true);
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.editor == null) {
            return;
        }
        this.performBraceHighlighting(false);
    }

    private void scheduleMatch() {
        if (this.doHighlighting) {
            this.delayedTimer.restart();
        }
    }

    private void clearHighlighting() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private void highlightLocation(HighlightStyle style, NumberRange location) {
        if (style != null) {
            HighlightLayer layer = this.getHighlightLayer();
            layer.addHighlight(style, location.start, location.end);
        }
    }

    private void highlightBraces(HighlightStyle style, NumberRange openLocation, NumberRange closeLocation) {
        if (openLocation != null) {
            this.highlightLocation(style, openLocation);
        }
        if (closeLocation != null) {
            this.highlightLocation(style, closeLocation);
        }
    }

    private boolean highlightBracesOnOffset(int offset, BraceProvider provider) {
        int braceToken;
        int braceToken2;
        BasicDocument document = (BasicDocument)this.editor.getDocument();
        HighlightStyle style = braceMatchStyle1;
        int lastBraceStart = -1;
        int lastMatchingStart = -1;
        boolean onBrace = false;
        if (offset > 0 && (braceToken2 = provider.isPartOfBrace(offset - 1, this.braceLocation)) != -1) {
            lastBraceStart = this.braceLocation.start;
            onBrace = true;
            int matchResult = provider.findMatchingBrace(braceToken2, this.braceLocation, this.matchingLocation);
            if (matchResult == 1 || matchResult == 2) {
                this.highlightBraces(style, this.braceLocation, this.matchingLocation);
                style = braceMatchStyle2;
                lastMatchingStart = this.matchingLocation.start;
            } else {
                this.highlightBraces(nonMatchingStyle, this.braceLocation, null);
            }
        }
        if (offset < document.getLength() && (braceToken = provider.isPartOfBrace(offset, this.braceLocation)) != -1 && this.braceLocation.start != lastBraceStart && this.braceLocation.start != lastMatchingStart) {
            onBrace = true;
            int matchResult = provider.findMatchingBrace(braceToken, this.braceLocation, this.matchingLocation);
            if (matchResult == 1 || matchResult == 2) {
                this.highlightBraces(style, this.braceLocation, this.matchingLocation);
            } else {
                this.highlightBraces(nonMatchingStyle, this.braceLocation, null);
            }
        }
        return onBrace;
    }

    private boolean highlightEnclosingBraces(int caretOffset, int braceType, ExtendedBraceProvider provider, HighlightStyle styleToUse) {
        int checkOffset = caretOffset;
        while (checkOffset > 0) {
            int braceToken = provider.findClosestBrace(checkOffset, this.braceLocation);
            if (braceToken == -1) {
                return false;
            }
            int matchResult = provider.findMatchingBrace(braceToken, this.braceLocation, this.matchingLocation);
            if (provider.isOpenBraceType(braceToken)) {
                int checkType;
                if (braceType != -1 && braceType != (checkType = provider.getBraceType(braceToken, this.braceLocation))) {
                    checkOffset = this.braceLocation.start;
                    continue;
                }
                if (matchResult == 1 || matchResult == 2) {
                    if (this.matchingLocation.start > caretOffset) {
                        this.highlightBraces(styleToUse, this.braceLocation, this.matchingLocation);
                    }
                } else {
                    this.highlightBraces(nonMatchingStyle, this.braceLocation, null);
                }
                return true;
            }
            if (provider.isCloseBraceType(braceToken)) {
                if (matchResult == 1 || matchResult == 2) {
                    checkOffset = this.matchingLocation.start;
                    continue;
                }
                return false;
            }
            System.out.println("Warning: unrecognized brace type: " + braceToken);
            return false;
        }
        return false;
    }

    private void performBraceHighlighting(boolean manual) {
        this.clearHighlighting();
        if (this.doHighlighting || manual) {
            if (this.editor == null || this.editor.getDocument() == null) {
                this.doHighlighting = false;
                return;
            }
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            LanguageSupport languageSupport = document.getLanguageSupport();
            BraceProvider braceProvider = languageSupport.getBraceProvider();
            if (braceProvider == null) {
                this.doHighlighting = false;
                return;
            }
            document.readLock();
            try {
                int offset = this.editor.getCaretPosition();
                this.highlightBracesOnOffset(offset, braceProvider);
                if (braceProvider instanceof ExtendedBraceProvider) {
                    ExtendedBraceProvider extendedProvider = (ExtendedBraceProvider)braceProvider;
                    if (this.doBlocks) {
                        this.highlightEnclosingBraces(offset, 3, extendedProvider, enclosingBlockStyle);
                    }
                    if (this.doParens) {
                        this.highlightEnclosingBraces(offset, 1, extendedProvider, enclosingParenStyle);
                    }
                }
            }
            finally {
                document.readUnlock();
            }
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        String name = resources.getString("BRACE_MATCH1_HIGHLIGHT");
        braceMatchStyle1 = registry.createStyle(HIGHLIGHT_BRACE_MATCH1, name, 80, Color.black, Color.yellow);
        name = resources.getString("BRACE_MATCH2_HIGHLIGHT");
        braceMatchStyle2 = registry.createStyle(HIGHLIGHT_BRACE_MATCH2, name, 80, Color.black, Color.orange);
        name = resources.getString("BRACE_MISMATCH_HIGHLIGHT");
        nonMatchingStyle = registry.createStyle(HIGHLIGHT_BRACE_MISMATCH, name, 80, Color.black, Color.red);
        name = resources.getString("BRACE_ENCLOSING_PARENS");
        enclosingParenStyle = registry.createStyle(HIGHLIGHT_ENCLOSING_PARENS, name, 79, Color.black, new Color(214, 214, 255));
        name = resources.getString("BRACE_ENCLOSING_BLOCK");
        enclosingBlockStyle = registry.createStyle(HIGHLIGHT_ENCLOSING_BLOCK, name, 79, Color.black, new Color(239, 214, 255));
    }
}

