/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.php.PHPBlockRenderer;
import oracle.javatools.editor.language.php.PHPLanguageSupport;
import oracle.javatools.editor.language.php.PHPStyles;
import oracle.javatools.resource.BundleHelper;

public final class PHPLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"php", "php3", "php4"};

    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("PHP_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return PHPStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append(" <head>\n");
        buffer.append("  <title>PHP Hello World</title>\n");
        buffer.append(" </head>\n");
        buffer.append(" <body>\n");
        buffer.append(" <?php echo \"<p>Hello World</p>\"; ?>\n");
        buffer.append(" </body>\n");
        buffer.append("</html>\n");
        return buffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry registry) {
        new PHPStyles(registry);
    }

    public LanguageSupport createLanguageSupport() {
        return new PHPLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new PHPBlockRenderer(buffer);
    }
}

