/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.html.HTMLStyles;
import oracle.javatools.editor.language.java.JavaStyles;
import oracle.javatools.editor.language.jsp.JSPBlockRenderer;
import oracle.javatools.editor.language.jsp.JSPLanguageSupport;
import oracle.javatools.resource.BundleHelper;

public final class JSPLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"jsp"};

    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("JSP_MODULE_NAME");
    }

    public String[] getStyleNames() {
        String[] javaStyles = JavaStyles.STYLE_NAMES;
        int numJavaStyles = javaStyles.length;
        String[] htmlStyles = HTMLStyles.STYLE_NAMES;
        int numHTMLStyles = htmlStyles.length;
        String[] jspStyles = new String[numJavaStyles + numHTMLStyles];
        System.arraycopy(javaStyles, 0, jspStyles, 0, numJavaStyles);
        System.arraycopy(htmlStyles, 0, jspStyles, numJavaStyles, numHTMLStyles);
        return jspStyles;
    }

    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("<%@ page contentType=\"text/html;");
        buffer.append("charset=WINDOWS-1252\"%>\n");
        buffer.append("<html>\n");
        buffer.append("<head>\n");
        buffer.append("<meta http-equiv=\"Content-Type\" ");
        buffer.append("content=\"text/html; charset=WINDOWS-1252\">\n");
        buffer.append("<title>Today's Date</title>\n");
        buffer.append("</head>\n");
        buffer.append("<body>\n");
        buffer.append("<%\n");
        buffer.append("  // Just print out today's date\n");
        buffer.append("  java.util.Date today = new java.util.Date();\n");
        buffer.append("  out.println( \"Today's date: \" +");
        buffer.append("today.toString() ); %> <P>\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
        return buffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry registry) {
    }

    public LanguageSupport createLanguageSupport() {
        return new JSPLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new JSPBlockRenderer(buffer);
    }
}

