/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import java.lang.ref.SoftReference;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.ExtendedBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class JavaBraceProvider
implements ExtendedBraceProvider {
    protected LanguageSupport support;
    protected TextBuffer textBuffer;
    private static final int AVERAGE_TOKEN_SIZE = 8;
    private static final float BRACE_OCCURRENCE = 0.25f;
    private static final int MINIMUM_BRACE_ENTRIES = 20;
    private static final float EXPANSION_FACTOR = 1.25f;
    protected int[] braceArray;
    protected int braceCount;
    private SoftReference braceArrayRef;
    private int bufferChangeId;
    private static JavaLexer sharedJavaLexer = null;
    private static LexerToken sharedJavaToken = null;

    private void $init$() {
        this.support = null;
    }

    public JavaBraceProvider(LanguageSupport support) {
        this.$init$();
        this.support = support;
        BasicDocument document = support.getDocument();
        this.textBuffer = document.getTextBuffer();
        this.bufferChangeId = -1;
    }

    public JavaBraceProvider(TextBuffer textBuffer) {
        this.$init$();
        this.textBuffer = textBuffer;
        this.bufferChangeId = -1;
    }

    public int getBraceType(int tokenType, NumberRange braceLocation) {
        switch (tokenType) {
            case 40: 
            case 41: {
                return 1;
            }
            case 123: 
            case 125: {
                return 3;
            }
            case 91: 
            case 93: {
                return 2;
            }
        }
        return -1;
    }

    public boolean isOpenBraceType(int tokenType) {
        switch (tokenType) {
            case 40: 
            case 91: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    public boolean isCloseBraceType(int tokenType) {
        switch (tokenType) {
            case 41: 
            case 93: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public synchronized int findClosestBrace(int offset, NumberRange braceLocation) {
        int checkOffset = Math.max(0, offset);
        checkOffset = Math.min(checkOffset, this.textBuffer.getLength());
        try {
            int braceOffset;
            this.buildBraceArray();
            int checkEntry = JavaBraceProvider.binarySearch(this.braceArray, this.braceCount, offset);
            if (checkEntry >= 0 && this.braceArray[checkEntry] == offset) {
                --checkEntry;
            }
            if (checkEntry < 0) {
                int n = -1;
                return n;
            }
            braceLocation.start = braceOffset = this.braceArray[checkEntry];
            braceLocation.end = braceOffset + 1;
            char c = this.textBuffer.getChar(braceOffset);
            return c;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseBraceArray();
        }
    }

    public synchronized int isPartOfBrace(int offset, NumberRange braceLocation) {
        if (offset >= this.textBuffer.getLength()) {
            return -1;
        }
        char c = this.textBuffer.getChar(offset);
        switch (c) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isValidBrace(offset)) break;
                char braceType = c;
                braceLocation.start = offset;
                braceLocation.end = offset + 1;
                return braceType;
            }
        }
        int braceType = -1;
        return braceType;
    }

    public synchronized int findMatchingBrace(int braceType, NumberRange braceLocation, NumberRange matchingLocation) {
        boolean searchForward;
        boolean checkBracket = false;
        boolean checkBrace = false;
        boolean checkParen = false;
        switch (braceType) {
            case 91: {
                checkBracket = true;
                searchForward = true;
                break;
            }
            case 40: {
                checkParen = true;
                searchForward = true;
                break;
            }
            case 123: {
                checkBrace = true;
                searchForward = true;
                break;
            }
            case 93: {
                checkBracket = true;
                searchForward = false;
                break;
            }
            case 41: {
                checkParen = true;
                searchForward = false;
                break;
            }
            case 125: {
                checkBrace = true;
                searchForward = false;
                break;
            }
            default: {
                return 3;
            }
        }
        if (!(checkBracket || checkParen || checkBrace)) {
            throw new IllegalStateException("bad check logic");
        }
        int braceOffset = braceLocation.start;
        if (braceOffset < 0 || braceOffset >= this.textBuffer.getLength() || braceType != this.textBuffer.getChar(braceOffset)) {
            throw new IllegalStateException("brace not in buffer");
        }
        try {
            int increment;
            this.buildBraceArray();
            int startEntry = this.findEntryForOffset(braceOffset);
            if (startEntry == -1) {
                int n = 3;
                return n;
            }
            int parenMatch = 0;
            int braceMatch = 0;
            int bracketMatch = 0;
            int n = increment = searchForward ? 1 : -1;
            for (int currentEntry = startEntry; currentEntry >= 0; currentEntry += increment) {
                if (currentEntry >= this.braceCount) {
                    break;
                }
                int offsetToCheck = this.braceArray[currentEntry];
                char braceToCheck = this.textBuffer.getChar(offsetToCheck);
                switch (braceToCheck) {
                    case '[': {
                        ++bracketMatch;
                        break;
                    }
                    case ']': {
                        --bracketMatch;
                        break;
                    }
                    case '{': {
                        ++braceMatch;
                        break;
                    }
                    case '}': {
                        --braceMatch;
                        break;
                    }
                    case '(': {
                        ++parenMatch;
                        break;
                    }
                    case ')': {
                        --parenMatch;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("not a brace: " + braceToCheck);
                    }
                }
                if (!(checkBrace && braceMatch == 0 || checkParen && parenMatch == 0) && (!checkBracket || bracketMatch != 0)) continue;
                matchingLocation.start = offsetToCheck;
                matchingLocation.end = offsetToCheck + 1;
                if (braceMatch == 0 && parenMatch == 0 && bracketMatch == 0) {
                    int n2 = 1;
                    return n2;
                }
                int n3 = 2;
                return n3;
            }
        }
        finally {
            this.releaseBraceArray();
        }
        return 3;
    }

    protected int guessBraceCount(int length) {
        return (int)((float)(length / 8) * 0.25f);
    }

    protected int[] expandBraceArray(int[] braceArray) {
        int currentSize = braceArray.length;
        int newSize = (int)((float)currentSize * 1.25f);
        int[] newArray = new int[newSize];
        System.arraycopy(braceArray, 0, newArray, 0, currentSize);
        return newArray;
    }

    protected void fillBraceArray() {
        JavaLexer lexer = JavaBraceProvider.acquireJavaLexer();
        lexer.setTextBuffer((ReadTextBuffer)this.textBuffer);
        LexerToken lexerToken = JavaBraceProvider.acquireJavaLexerToken(lexer);
        this.scanJavaBlock(lexer, lexerToken, 0, this.textBuffer.getLength());
        JavaBraceProvider.releaseJavaLexer(lexer);
        JavaBraceProvider.releaseJavaLexerToken(lexerToken);
    }

    protected void scanJavaBlock(JavaLexer lexer, LexerToken lexerToken, int startOffset, int endOffset) {
        lexer.setPosition(startOffset);
        block4: while (true) {
            int token = lexer.lex(lexerToken);
            int tokenStartOffset = lexerToken.getStartOffset();
            if (tokenStartOffset >= endOffset) break;
            switch (token) {
                case 0: {
                    break block4;
                }
                case 49: 
                case 50: 
                case 55: 
                case 70: 
                case 71: 
                case 72: {
                    if (this.braceCount == this.braceArray.length) {
                        this.braceArray = this.expandBraceArray(this.braceArray);
                    }
                    this.braceArray[this.braceCount++] = tokenStartOffset;
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    private void buildBraceArray() {
        if (this.braceArrayRef != null) {
            this.braceArray = (int[])this.braceArrayRef.get();
        }
        if (this.braceArray == null || this.bufferChangeId != this.textBuffer.getChangeId()) {
            int length = this.textBuffer.getLength();
            int guessSize = Math.max(this.guessBraceCount(length), 20);
            if (this.braceArray == null) {
                this.braceArray = new int[guessSize];
            }
            this.bufferChangeId = this.textBuffer.getChangeId();
            this.braceCount = 0;
            this.fillBraceArray();
            this.braceArrayRef = new SoftReference<int[]>(this.braceArray);
        }
    }

    private void releaseBraceArray() {
        this.braceArray = null;
    }

    private boolean isValidBrace(int offset) {
        try {
            this.buildBraceArray();
            int entry = this.findEntryForOffset(offset);
            boolean bl = entry != -1;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseBraceArray();
        }
    }

    private int findEntryForOffset(int offset) {
        int index = JavaBraceProvider.binarySearch(this.braceArray, this.braceCount, offset);
        if (index != -1 && this.braceArray[index] != offset) {
            index = -1;
        }
        return index;
    }

    private static int binarySearch(int[] array, int count, int value) {
        if (array == null || array.length == 0 || count == 0) {
            return -1;
        }
        if (array.length > 0 && count > 0 && value < array[0]) {
            return -1;
        }
        int top_entry = 0;
        int bottom_entry = count;
        int spread;
        while ((spread = bottom_entry - top_entry) != 1) {
            int middle_entry = bottom_entry + top_entry >> 1;
            int middle_value = array[middle_entry];
            if (middle_value > value) {
                bottom_entry = middle_entry;
                continue;
            }
            top_entry = middle_entry;
        }
        return top_entry;
    }

    protected static synchronized JavaLexer acquireJavaLexer() {
        JavaLexer lexer = sharedJavaLexer;
        sharedJavaLexer = null;
        if (lexer == null) {
            lexer = new JavaLexer();
            lexer.setSkipComments(true);
            lexer.setRecognizeSQLJ(true);
        }
        return lexer;
    }

    protected static synchronized void releaseJavaLexer(JavaLexer lexer) {
        if (lexer != null) {
            lexer.setTextBuffer(null);
        }
        sharedJavaLexer = lexer;
    }

    protected static synchronized LexerToken acquireJavaLexerToken(JavaLexer lexer) {
        LexerToken token = sharedJavaToken;
        sharedJavaToken = null;
        if (token == null) {
            token = lexer.createLexerToken();
        }
        return token;
    }

    protected static synchronized void releaseJavaLexerToken(LexerToken token) {
        sharedJavaToken = token;
    }
}

