/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.html;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class HTMLStyles {
    public static final String HTML_COMMENT_STYLE = "html-comment-style";
    public static final String HTML_SYMBOL_STYLE = "html-symbol-style";
    public static final String HTML_ELEMENT_NAME_STYLE = "html-element-style";
    public static final String HTML_ATTRIBUTE_NAME_STYLE = "html-attribute-name-style";
    public static final String HTML_ATTRIBUTE_VALUE_STYLE = "html-attribute-value-style";
    public static final String[] STYLE_NAMES = new String[]{"html-comment-style", "html-symbol-style", "html-element-style", "html-attribute-name-style", "html-attribute-value-style"};
    public BaseStyle htmlPlainStyle;
    public BaseStyle htmlCommentStyle;
    public BaseStyle htmlSymbolStyle;
    public BaseStyle htmlElementNameStyle;
    public BaseStyle htmlAttributeNameStyle;
    public BaseStyle htmlAttributeValueStyle;

    public HTMLStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        this.htmlPlainStyle = builtInStyles.plainStyle;
        this.htmlCommentStyle = styleRegistry.lookupStyle(HTML_COMMENT_STYLE);
        if (this.htmlCommentStyle == null) {
            String name = resources.getString("HTML_COMMENT_STYLE");
            this.htmlCommentStyle = styleRegistry.createStyle(HTML_COMMENT_STYLE, name, "base-comment-style");
        }
        this.htmlSymbolStyle = styleRegistry.lookupStyle(HTML_SYMBOL_STYLE);
        if (this.htmlSymbolStyle == null) {
            String name = resources.getString("HTML_SYMBOL_STYLE");
            this.htmlSymbolStyle = styleRegistry.createStyle(HTML_SYMBOL_STYLE, name, "base-markup-style");
        }
        this.htmlElementNameStyle = styleRegistry.lookupStyle(HTML_ELEMENT_NAME_STYLE);
        if (this.htmlElementNameStyle == null) {
            String name = resources.getString("HTML_ELEMENT_NAME_STYLE");
            this.htmlElementNameStyle = styleRegistry.createStyle(HTML_ELEMENT_NAME_STYLE, name, "base-element-style");
        }
        this.htmlAttributeNameStyle = styleRegistry.lookupStyle(HTML_ATTRIBUTE_NAME_STYLE);
        if (this.htmlAttributeNameStyle == null) {
            String name = resources.getString("HTML_ATTRIBUTE_NAME_STYLE");
            this.htmlAttributeNameStyle = styleRegistry.createStyle(HTML_ATTRIBUTE_NAME_STYLE, name, "base-attribute-name-style");
        }
        this.htmlAttributeValueStyle = styleRegistry.lookupStyle(HTML_ATTRIBUTE_VALUE_STYLE);
        if (this.htmlAttributeValueStyle == null) {
            String name = resources.getString("HTML_ATTRIBUTE_VALUE_STYLE");
            this.htmlAttributeValueStyle = styleRegistry.createStyle(HTML_ATTRIBUTE_VALUE_STYLE, name, "base-attribute-value-style");
        }
    }
}

