/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.css.CSSBlockRenderer;
import oracle.javatools.editor.language.css.CSSRuleRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.css.CSSMediaRuleLexer;
import oracle.javatools.parser.css.CSSRuleTokens;

public class CSSMediaRuleRenderer
extends CSSRuleRenderer
implements CSSRuleTokens {
    private CSSBlockRenderer _mBlockRenderer;

    public CSSMediaRuleRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this._mBlockRenderer = new CSSBlockRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        return new CSSMediaRuleLexer();
    }

    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 101: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderCSSBlock(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
                break;
            }
        }
    }

    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 18: {
                return "css-comment-style";
            }
            case 32: {
                return "css-at-rule-style";
            }
            case 201: {
                return "css-medium-style";
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderCSSBlock(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        this._mBlockRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }
}

