/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.css.CSSBlockRenderer;
import oracle.javatools.editor.language.css.CSSLanguageSupport;
import oracle.javatools.editor.language.css.CSSStyles;
import oracle.javatools.resource.BundleHelper;

public class CSSLanguageModule
extends LanguageModule {
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("@charset \"ISO-8859-1\";\n");
        buffer.append("@import \"ext/extension.css\" print, screen;\n");
        buffer.append("@namespace xyx \"www.xyz.com\";\n");
        buffer.append("@media print {\n");
        buffer.append("  /* style sheet for print goes here */\n");
        buffer.append("  xyz|abcElement {\n");
        buffer.append("    unknown_property: inherit;\n");
        buffer.append("  }\n");
        buffer.append("}\n");
        buffer.append("@page rotated :left {\n");
        buffer.append("  size: 8.5in 11in;\n");
        buffer.append("  margin: 2cm;\n");
        buffer.append("}\n");
        buffer.append("@font-face {\n");
        buffer.append("  font-family: \"Swiss 721\";\n");
        buffer.append("  src: url(swiss721.pfr); /* The condensed Swiss 721 */\n");
        buffer.append("  font-stretch: condensed;\n");
        buffer.append("}\n");
        buffer.append("/* style rules beginhere */\n");
        buffer.append("A:link {\n");
        buffer.append("  font-family: \"Swiss 721\";\n");
        buffer.append("  color: purple !important;\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public String[] getStyleNames() {
        return CSSStyles.getStyleNames();
    }

    public void registerStyles(StyleRegistry registry) {
        new CSSStyles(registry);
    }

    public LanguageSupport createLanguageSupport() {
        return new CSSLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new CSSBlockRenderer(buffer);
    }

    public String[] getSupportedFileTypes() {
        String[] files = new String[]{"css"};
        return files;
    }

    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("CSS_MODULE_NAME");
    }
}

