/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.language.BaseStyle;

public final class StyleRegistry {
    private transient WeakPropertyChangeSupport changeSupport;
    public static final String PROPERTY_STYLE_CHANGED = "style-changed";
    private HashMap registryMap = new HashMap(30);
    private ArrayList registryList = new ArrayList(30);
    private ArrayList pendingList = new ArrayList();

    public StyleRegistry() {
        this.changeSupport = new WeakPropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    private void fireStyleChangedEvent() {
        this.changeSupport.firePropertyChange(PROPERTY_STYLE_CHANGED, Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized Iterator getStyleIterator() {
        ArrayList listCopy = new ArrayList();
        listCopy.addAll(this.registryList);
        listCopy.addAll(this.pendingList);
        return listCopy.iterator();
    }

    public synchronized Object clone() {
        StyleRegistry registryCopy = new StyleRegistry();
        for (BaseStyle style : this.registryList) {
            if (style.getHasParent()) {
                registryCopy.createStyle(style.getName(), style.getPresentationName(), style.getParentName(), style.getUsesParentForegroundColor(), style.getForegroundColor(), style.getUsesParentBackgroundColor(), style.getBackgroundColor(), style.getUsesParentFontStyle(), style.getFontStyle());
                continue;
            }
            registryCopy.createStyle(style.getName(), style.getPresentationName(), style.getForegroundColor(), style.getBackgroundColor());
        }
        for (BaseStyle style : this.pendingList) {
            registryCopy.modifyStyle(style.getName(), style.getUsesParentForegroundColor(), style.getForegroundColor(), style.getUsesParentBackgroundColor(), style.getBackgroundColor(), style.getUsesParentFontStyle(), style.getFontStyle());
        }
        return registryCopy;
    }

    private void addStyle(BaseStyle style) {
        this.registryMap.put(style.getName(), style);
        this.registryList.add(style);
        BaseStyle pendingStyle = this.lookupPendingStyle(style.getName());
        if (pendingStyle != null) {
            int index = this.pendingList.indexOf(pendingStyle);
            this.pendingList.remove(index);
            this.modifyStyle(style, pendingStyle.getUsesParentForegroundColor(), pendingStyle.getForegroundColor(), pendingStyle.getUsesParentBackgroundColor(), pendingStyle.getBackgroundColor(), pendingStyle.getUsesParentFontStyle(), pendingStyle.getFontStyle());
        }
    }

    synchronized BaseStyle createStyle(String styleName, String presentationName, Color fgColor, Color bgColor) {
        BaseStyle style = this.lookupStyle(styleName);
        if (style == null) {
            style = new BaseStyle(styleName, presentationName, fgColor, bgColor);
            this.addStyle(style);
        }
        return style;
    }

    public synchronized BaseStyle createStyle(String styleName, String presentationName, String parentStyleName) {
        return this.createStyle(styleName, presentationName, parentStyleName, true, null, true, null, true, 0);
    }

    public synchronized BaseStyle createStyle(String styleName, String presentationName, String parentStyleName, Color fgColor) {
        return this.createStyle(styleName, presentationName, parentStyleName, false, fgColor, true, null, true, 0);
    }

    public synchronized BaseStyle createStyle(String styleName, String presentationName, String parentStyleName, int fontStyle) {
        return this.createStyle(styleName, presentationName, parentStyleName, true, null, true, null, false, fontStyle);
    }

    public synchronized BaseStyle createStyle(String styleName, String presentationName, String parentStyleName, Color fgColor, int fontStyle) {
        return this.createStyle(styleName, presentationName, parentStyleName, false, fgColor, true, null, false, fontStyle);
    }

    public synchronized BaseStyle createStyle(String styleName, String presentationName, String parentStyleName, Color fgColor, Color bgColor, int fontStyle) {
        return this.createStyle(styleName, presentationName, parentStyleName, false, fgColor, false, bgColor, false, fontStyle);
    }

    private BaseStyle createStyle(String styleName, String presentationName, String parentStyleName, boolean useParentFG, Color fgColor, boolean useParentBG, Color bgColor, boolean useParentFontStyle, int fontStyle) {
        BaseStyle style = this.lookupStyle(styleName);
        if (style == null) {
            BaseStyle parentStyle = this.lookupStyle(parentStyleName);
            if (parentStyle == null) {
                throw new IllegalStateException("parent does not exist: " + parentStyleName);
            }
            if (useParentFG) {
                fgColor = parentStyle.getForegroundColor();
            }
            if (useParentBG) {
                bgColor = parentStyle.getBackgroundColor();
            }
            if (useParentFontStyle) {
                fontStyle = parentStyle.getFontStyle();
            }
            style = new BaseStyle(styleName, presentationName, parentStyle, useParentFG, fgColor, useParentBG, bgColor, useParentFontStyle, fontStyle);
            this.addStyle(style);
        }
        return style;
    }

    public synchronized BaseStyle lookupStyle(String styleName) {
        BaseStyle style = (BaseStyle)this.registryMap.get(styleName);
        return style;
    }

    private BaseStyle lookupPendingStyle(String styleName) {
        int numPending = this.pendingList.size();
        int i = 0;
        while (i < numPending) {
            BaseStyle pendingStyle = (BaseStyle)this.pendingList.get(i);
            if (pendingStyle.getName().equals(styleName)) {
                return pendingStyle;
            }
            ++i;
        }
        return null;
    }

    public synchronized void modifyStyleForeground(String styleName, boolean useParentFG, Color fgColor) {
        BaseStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setForegroundColor(fgColor);
            style.setUsesParentForegroundColor(useParentFG);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleBackground(String styleName, boolean useParentBG, Color bgColor) {
        BaseStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setBackgroundColor(bgColor);
            style.setUsesParentBackgroundColor(useParentBG);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleFontStyle(String styleName, boolean useParentFontStyle, int fontStyle) {
        BaseStyle style = this.lookupStyle(styleName);
        if (style != null) {
            style.setFontStyle(fontStyle);
            style.setUsesParentFontStyle(useParentFontStyle);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyle(String styleName, boolean useParentFG, Color fgColor, boolean useParentBG, Color bgColor, boolean useParentFontStyle, int fontStyle) {
        BaseStyle style = this.lookupStyle(styleName);
        if (style != null) {
            this.modifyStyle(style, useParentFG, fgColor, useParentBG, bgColor, useParentFontStyle, fontStyle);
            this.fireStyleChangedEvent();
        } else {
            BaseStyle pendingStyle = this.lookupPendingStyle(styleName);
            if (pendingStyle != null) {
                this.modifyStyle(pendingStyle, useParentFG, fgColor, useParentBG, bgColor, useParentFontStyle, fontStyle);
            } else {
                BaseStyle parentStyle = this.lookupStyle("base-plain-style");
                pendingStyle = new BaseStyle(styleName, "<" + styleName + ">", parentStyle, useParentFG, fgColor, useParentBG, bgColor, useParentFontStyle, fontStyle);
                this.pendingList.add(pendingStyle);
            }
        }
    }

    private void modifyStyle(BaseStyle style, boolean useParentFG, Color fgColor, boolean useParentBG, Color bgColor, boolean useParentFontStyle, int fontStyle) {
        if (style != null) {
            style.setForegroundColor(fgColor);
            style.setUsesParentForegroundColor(useParentFG);
            style.setBackgroundColor(bgColor);
            style.setUsesParentBackgroundColor(useParentBG);
            style.setFontStyle(fontStyle);
            style.setUsesParentFontStyle(useParentFontStyle);
        }
    }
}

