/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;

public final class NaturalWordLocator
implements WordLocator {
    private LanguageSupport support;

    private ReadTextBuffer getTextBuffer() {
        BasicDocument document = this.support.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer;
    }

    public NaturalWordLocator(LanguageSupport support) {
        this.support = support;
    }

    private BreakIterator getWordIterator(ReadTextBuffer textBuffer) {
        CharacterIterator charIterator = TextBufferFactory.createCharacterIterator((ReadTextBuffer)textBuffer);
        BreakIterator words = BreakIterator.getWordInstance();
        words.setText(charIterator);
        return words;
    }

    public int getWordStart(int offset) {
        int wordStart;
        ReadTextBuffer textBuffer = this.getTextBuffer();
        int bufferLength = textBuffer.getLength();
        if (bufferLength == 0 || offset == 0) {
            return 0;
        }
        BreakIterator words = this.getWordIterator(textBuffer);
        try {
            if (offset == bufferLength) {
                words.last();
            } else {
                words.following(offset);
            }
            wordStart = words.previous();
            if (wordStart == -1) {
                wordStart = 0;
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got IllegalArgumentException");
            wordStart = 0;
        }
        return wordStart;
    }

    public int getWordEnd(int offset) {
        int wordEnd;
        ReadTextBuffer textBuffer = this.getTextBuffer();
        int bufferLength = textBuffer.getLength();
        if (bufferLength == 0 || offset == bufferLength) {
            return bufferLength;
        }
        BreakIterator words = this.getWordIterator(textBuffer);
        try {
            wordEnd = words.following(offset);
            if (wordEnd == -1) {
                wordEnd = textBuffer.getLength();
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got IllegalArgumentException");
            wordEnd = textBuffer.getLength();
        }
        return wordEnd;
    }

    public int getNextWordStart(int offset) {
        int nextWord;
        block4: {
            ReadTextBuffer textBuffer = this.getTextBuffer();
            int bufferLength = textBuffer.getLength();
            if (bufferLength == 0 || offset == bufferLength) {
                return bufferLength;
            }
            BreakIterator words = this.getWordIterator(textBuffer);
            try {
                char c;
                int wordOffset = offset;
                do {
                    if ((wordOffset = words.following(wordOffset)) != bufferLength) continue;
                    nextWord = wordOffset;
                    break block4;
                } while (Character.isWhitespace(c = textBuffer.getChar(wordOffset)));
                nextWord = wordOffset;
            }
            catch (IllegalArgumentException e) {
                System.out.println("Got IllegalArgumentException");
                nextWord = words.last();
            }
        }
        return nextWord;
    }

    public int getNextWordEnd(int offset) {
        int wordEnd;
        char c;
        ReadTextBuffer textBuffer = this.getTextBuffer();
        int bufferLength = textBuffer.getLength();
        if (bufferLength == 0 || offset == bufferLength) {
            return bufferLength;
        }
        int previousStart = this.getPreviousWordStart(offset);
        boolean hitCase4 = false;
        if (previousStart == 0 && Character.isWhitespace(c = textBuffer.getChar(0))) {
            hitCase4 = true;
        }
        if (!hitCase4 && (wordEnd = this.getWordEnd(previousStart)) > offset) {
            return wordEnd;
        }
        int nextStart = this.getNextWordStart(previousStart);
        int wordEnd2 = this.getWordEnd(nextStart);
        return wordEnd2;
    }

    public int getPreviousWordStart(int offset) {
        int previousWord;
        block9: {
            ReadTextBuffer textBuffer = this.getTextBuffer();
            int bufferLength = textBuffer.getLength();
            if (bufferLength == 0 || offset == 0) {
                return 0;
            }
            BreakIterator words = this.getWordIterator(textBuffer);
            try {
                char c;
                int wordOffset = offset;
                if (offset == bufferLength) {
                    words.last();
                } else {
                    words.following(offset);
                }
                do {
                    if ((wordOffset = words.previous()) == 0) {
                        previousWord = wordOffset;
                    } else {
                        if (wordOffset == offset) {
                            wordOffset = words.previous();
                        }
                        if (wordOffset != -1) continue;
                        previousWord = 0;
                    }
                    break block9;
                } while (Character.isWhitespace(c = textBuffer.getChar(wordOffset)));
                previousWord = wordOffset;
            }
            catch (IllegalArgumentException e) {
                System.out.println("Got IllegalArgumentException");
                previousWord = 0;
            }
        }
        return previousWord;
    }

    public int getPreviousWordEnd(int offset) {
        char c;
        char c2;
        ReadTextBuffer textBuffer = this.getTextBuffer();
        int bufferLength = textBuffer.getLength();
        if (bufferLength == 0 || offset == 0) {
            return 0;
        }
        int previousStart = this.getPreviousWordStart(offset);
        if (previousStart == 0 && Character.isWhitespace(c2 = textBuffer.getChar(0))) {
            return 0;
        }
        int wordEnd = this.getWordEnd(previousStart);
        if (wordEnd < offset) {
            return wordEnd;
        }
        int secondPreviousStart = this.getPreviousWordStart(previousStart);
        if (secondPreviousStart == 0 && Character.isWhitespace(c = textBuffer.getChar(0))) {
            return 0;
        }
        wordEnd = this.getWordEnd(secondPreviousStart);
        return wordEnd;
    }
}

