/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.language.AbstractDocumentRenderer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.BooleanBitmap;
import oracle.javatools.editor.language.HistoryReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class LexerDocumentRenderer
extends AbstractDocumentRenderer {
    protected LexerOffsetsCache offsetsCache = null;
    protected BlockRenderer blockRenderer;
    protected Lexer lexer = null;
    protected LexerToken lexerToken = null;

    public LexerDocumentRenderer(LanguageSupport support) {
        super(support);
    }

    protected abstract BlockRenderer createBlockRenderer();

    protected final BlockRenderer getBlockRenderer() {
        if (this.blockRenderer == null) {
            this.blockRenderer = this.createBlockRenderer();
        }
        return this.blockRenderer;
    }

    protected abstract Lexer createLexer();

    protected final Lexer getLexer() {
        if (this.lexer == null) {
            this.lexer = this.createLexer();
        }
        return this.lexer;
    }

    protected final LexerToken getLexerToken() {
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.createLexerToken();
        }
        return this.lexerToken;
    }

    public LexerOffsetsCache getOffsetsCache() {
        if (this.offsetsCache == null) {
            this.offsetsCache = new LexerOffsetsCache(this);
        }
        return this.offsetsCache;
    }

    public abstract boolean isMultiLineToken(int var1);

    public void renderRegion(StyledFragmentsList fragmentsList, int startOffset, int endOffset) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        LexerOffsetsCache cache = this.getOffsetsCache();
        int cachedStartOffset = cache.findClosestOffset(lexer, lexerToken, startOffset);
        lexer.setTextBuffer(null);
        BlockRenderer blockRenderer = this.getBlockRenderer();
        blockRenderer.renderBlock(fragmentsList, cachedStartOffset, endOffset, startOffset, endOffset);
    }

    public void calculateDamage(DocumentEvent changes, NumberRange damageRange) {
        int token;
        int token2;
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int lineCount = lineMap.getLineCount();
        boolean isInsert = changes.getType() == DocumentEvent.EventType.INSERT;
        int changedLength = changes.getLength();
        int changedStart = changes.getOffset();
        int afterChangeEnd = isInsert ? changedLength + changedStart : changedStart;
        int beforeChangeEnd = isInsert ? changedStart : changedLength + changedStart;
        int changedLine = lineMap.getLineFromOffset(changedStart);
        if (changedLine >= lineCount - 2) {
            damageRange.start = changedLine;
            damageRange.end = lineCount - 1;
            return;
        }
        int afterLineEnd = lineMap.getLineEndOffset(changedLine);
        int beforeLineEnd = isInsert ? afterLineEnd - changedLength : afterLineEnd + changedLength;
        int beforeTokenStart = -1;
        int beforeTokenLength = -1;
        int beforeToken = 0;
        int afterTokenStart = -1;
        int afterTokenLength = -1;
        int afterToken = 0;
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        int lexerStartOffset = this.getOffsetsCache().findClosestOffset(lexer, lexerToken, changedStart);
        HistoryReadTextBuffer historyBuffer = HistoryReadTextBuffer.acquireReadTextBuffer((ReadTextBuffer)textBuffer, (BasicDocumentEvent)changes);
        lexer.setTextBuffer((ReadTextBuffer)historyBuffer);
        lexer.setPosition(lexerStartOffset);
        while ((token2 = lexer.lex(lexerToken)) != 0) {
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (tokenStart < beforeChangeEnd || tokenEnd <= beforeLineEnd) continue;
            beforeTokenStart = lexerToken.getStartOffset();
            beforeTokenLength = lexerToken.getEndOffset() - beforeTokenStart;
            beforeToken = token2;
            break;
        }
        lexer.setTextBuffer(null);
        HistoryReadTextBuffer.releaseReadTextBuffer(historyBuffer);
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(lexerStartOffset);
        while ((token = lexer.lex(lexerToken)) != 0) {
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (tokenStart < afterChangeEnd || tokenEnd <= afterLineEnd) continue;
            afterTokenStart = lexerToken.getStartOffset();
            afterTokenLength = lexerToken.getEndOffset() - afterTokenStart;
            afterToken = token;
            break;
        }
        lexer.setTextBuffer(null);
        if (afterToken != 0 && beforeToken != 0) {
            int adjustedBeforeTokenStart;
            int n = adjustedBeforeTokenStart = isInsert ? beforeTokenStart + changedLength : beforeTokenStart - changedLength;
            if (adjustedBeforeTokenStart == afterTokenStart && beforeTokenLength == afterTokenLength && beforeToken == afterToken) {
                int afterLine = lineMap.getLineFromOffset(afterTokenStart);
                damageRange.start = changedLine;
                damageRange.end = Math.max(changedLine, afterLine - 1);
                return;
            }
        }
        damageRange.start = changedLine;
        damageRange.end = lineCount - 1;
    }

    public void notifyUpdate(DocumentEvent changes) {
        if (this.offsetsCache != null) {
            int changeStartOffset = changes.getOffset();
            this.offsetsCache.invalidateOffsets(changeStartOffset);
        }
    }

    public static final class LexerOffsetsCache {
        private BooleanBitmap bitmap;
        private LexerDocumentRenderer documentRenderer;
        private int lastValidatedLine;

        public LexerOffsetsCache(LexerDocumentRenderer documentRenderer) {
            this.documentRenderer = documentRenderer;
            LineMap lineMap = documentRenderer.getLineMap();
            int lineCount = lineMap.getLineCount();
            this.bitmap = new BooleanBitmap(lineCount);
            this.lastValidatedLine = 0;
        }

        public synchronized int findClosestOffset(Lexer lexer, LexerToken lexerToken, int offset) {
            int offsetToUse = 0;
            try {
                offsetToUse = this.findClosestOffsetInternal(lexer, lexerToken, offset);
            }
            catch (RuntimeException e) {
                System.err.println("Warning: lexer cache exception: " + e.toString());
                e.printStackTrace();
                try {
                    this.invalidateOffsets(0);
                    offsetToUse = this.findClosestOffsetInternal(lexer, lexerToken, offset);
                }
                catch (RuntimeException e2) {
                    System.err.println("Warning: lexer cache irrecoverable: " + e2.toString());
                    e2.printStackTrace();
                    offsetToUse = 0;
                }
            }
            return offsetToUse;
        }

        private int findClosestOffsetInternal(Lexer lexer, LexerToken lexerToken, int offset) {
            int lineToUse;
            TextBuffer textBuffer = this.documentRenderer.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int line = lineMap.getLineFromOffset(offset);
            if (this.lastValidatedLine < line) {
                int startLine;
                for (startLine = this.lastValidatedLine - 1; startLine > 0; --startLine) {
                    if (this.bitmap.get(startLine)) {
                        continue;
                    }
                    ++startLine;
                    break;
                }
                startLine = Math.max(0, startLine);
                int startOffset = lineMap.getLineStartOffset(startLine);
                int endLine = line - 1;
                int endOffset = lineMap.getLineEndOffset(endLine);
                int lastEndOffset = startOffset;
                int nextLineToMark = startLine;
                lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                lexer.setPosition(startOffset);
                while (lastEndOffset < endOffset) {
                    int commentEndLine;
                    int commentStartLine;
                    int token = lexer.lex(lexerToken);
                    if (token == 0) break;
                    int tokenStart = lexerToken.getStartOffset();
                    int tokenEnd = lexerToken.getEndOffset();
                    if (this.documentRenderer.isMultiLineToken(token) && (commentStartLine = lineMap.getLineFromOffset(tokenStart)) != (commentEndLine = lineMap.getLineFromOffset(tokenEnd))) {
                        this.markBitmap(nextLineToMark, commentStartLine, false);
                        this.markBitmap(commentStartLine, commentEndLine, true);
                        nextLineToMark = commentEndLine + 1;
                    }
                    lastEndOffset = tokenEnd;
                }
                this.markBitmap(nextLineToMark, endLine, false);
                this.lastValidatedLine = line;
            }
            for (lineToUse = line - 1; lineToUse > 0; --lineToUse) {
                if (this.bitmap.get(lineToUse)) {
                    continue;
                }
                ++lineToUse;
                break;
            }
            lineToUse = Math.max(0, lineToUse);
            int offsetToUse = lineMap.getLineStartOffset(lineToUse);
            return offsetToUse;
        }

        public synchronized void invalidateOffsets(int startOffset) {
            LineMap lineMap = this.documentRenderer.getLineMap();
            int line = lineMap.getLineFromOffset(startOffset);
            if (this.lastValidatedLine >= line) {
                this.lastValidatedLine = Math.max(0, line - 1);
            }
            int lineCount = lineMap.getLineCount();
            this.bitmap.setSize(lineCount);
        }

        private void markBitmap(int startIndex, int endIndex, boolean value) {
            int i = startIndex;
            while (i < endIndex) {
                this.bitmap.set(i, value);
                ++i;
            }
        }
    }
}

