/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.awt.Color;
import javax.swing.UIManager;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class BuiltInStyles {
    public static final String BUILTIN_LF_STYLE = "base-lf-style";
    public static final String BUILTIN_PLAIN_STYLE = "base-plain-style";
    public static final String BUILTIN_COMMENT_STYLE = "base-comment-style";
    public static final String BUILTIN_KEYWORD_STYLE = "base-keyword-style";
    public static final String BUILTIN_STRING_STYLE = "base-string-style";
    public static final String BUILTIN_NUMBER_STYLE = "base-number-style";
    public static final String BUILTIN_IDENTIFIER_STYLE = "base-identifier-style";
    public static final String BUILTIN_BRACE_STYLE = "base-brace-style";
    public static final String BUILTIN_OPERATOR_STYLE = "base-operator-style";
    public static final String BUILTIN_MARKUP_STYLE = "base-markup-style";
    public static final String BUILTIN_ELEMENT_STYLE = "base-element-style";
    public static final String BUILTIN_ATTRIBUTE_NAME_STYLE = "base-attribute-name-style";
    public static final String BUILTIN_ATTRIBUTE_VALUE_STYLE = "base-attribute-value-style";
    public static final String BUILTIN_HEADER_STYLE = "base-attribute-header-style";
    public static final String BUILTIN_ADDITION_STYLE = "base-attribute-addition-style";
    public static final String BUILTIN_REMOVAL_STYLE = "base-attribute-removal-style";
    public static final String[] STYLE_NAMES = new String[]{"base-lf-style", "base-plain-style", "base-comment-style", "base-keyword-style", "base-string-style", "base-number-style", "base-identifier-style", "base-brace-style", "base-operator-style", "base-markup-style", "base-element-style", "base-attribute-name-style", "base-attribute-value-style", "base-attribute-header-style", "base-attribute-addition-style", "base-attribute-removal-style"};
    public BaseStyle lfStyle;
    public BaseStyle plainStyle;
    public BaseStyle commentStyle;
    public BaseStyle keywordStyle;
    public BaseStyle stringStyle;
    public BaseStyle numberStyle;
    public BaseStyle identifierStyle;
    public BaseStyle braceStyle;
    public BaseStyle operatorStyle;
    public BaseStyle markupStyle;
    public BaseStyle elementStyle;
    public BaseStyle attributeNameStyle;
    public BaseStyle attributeValueStyle;
    public BaseStyle headerStyle;
    public BaseStyle additionStyle;
    public BaseStyle removalStyle;

    public BuiltInStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        BundleHelper resources = EditorProperties.getEditorBundle();
        this.lfStyle = styleRegistry.lookupStyle(BUILTIN_LF_STYLE);
        if (this.lfStyle == null) {
            Color bgColor = UIManager.getColor("EditorPane.background");
            Color fgColor = UIManager.getColor("EditorPane.foreground");
            if (bgColor == null) {
                bgColor = Color.white;
            }
            if (fgColor == null) {
                fgColor = Color.black;
            }
            String name = resources.getString("BUILTIN_LOOK_AND_FEEL_STYLE");
            this.lfStyle = styleRegistry.createStyle(BUILTIN_LF_STYLE, name, fgColor, bgColor);
        }
        this.plainStyle = styleRegistry.lookupStyle(BUILTIN_PLAIN_STYLE);
        if (this.plainStyle == null) {
            String name = resources.getString("BUILTIN_PLAIN_STYLE");
            this.plainStyle = styleRegistry.createStyle(BUILTIN_PLAIN_STYLE, name, BUILTIN_LF_STYLE);
        }
        this.commentStyle = styleRegistry.lookupStyle(BUILTIN_COMMENT_STYLE);
        if (this.commentStyle == null) {
            String name = resources.getString("BUILTIN_COMMENT_STYLE");
            this.commentStyle = styleRegistry.createStyle(BUILTIN_COMMENT_STYLE, name, BUILTIN_PLAIN_STYLE, new Color(102, 153, 153), 2);
        }
        this.keywordStyle = styleRegistry.lookupStyle(BUILTIN_KEYWORD_STYLE);
        if (this.keywordStyle == null) {
            String name = resources.getString("BUILTIN_KEYWORD_STYLE");
            this.keywordStyle = styleRegistry.createStyle(BUILTIN_KEYWORD_STYLE, name, BUILTIN_PLAIN_STYLE, Color.darkGray, 1);
        }
        this.stringStyle = styleRegistry.lookupStyle(BUILTIN_STRING_STYLE);
        if (this.stringStyle == null) {
            String name = resources.getString("BUILTIN_STRING_STYLE");
            this.stringStyle = styleRegistry.createStyle(BUILTIN_STRING_STYLE, name, BUILTIN_PLAIN_STYLE, Color.blue);
        }
        this.numberStyle = styleRegistry.lookupStyle(BUILTIN_NUMBER_STYLE);
        if (this.numberStyle == null) {
            String name = resources.getString("BUILTIN_NUMBER_STYLE");
            this.numberStyle = styleRegistry.createStyle(BUILTIN_NUMBER_STYLE, name, BUILTIN_PLAIN_STYLE, Color.magenta);
        }
        this.identifierStyle = styleRegistry.lookupStyle(BUILTIN_IDENTIFIER_STYLE);
        if (this.identifierStyle == null) {
            String name = resources.getString("BUILTIN_IDENTIFIER_STYLE");
            this.identifierStyle = styleRegistry.createStyle(BUILTIN_IDENTIFIER_STYLE, name, BUILTIN_PLAIN_STYLE);
        }
        this.braceStyle = styleRegistry.lookupStyle(BUILTIN_BRACE_STYLE);
        if (this.braceStyle == null) {
            String name = resources.getString("BUILTIN_BRACE_STYLE");
            this.braceStyle = styleRegistry.createStyle(BUILTIN_BRACE_STYLE, name, BUILTIN_PLAIN_STYLE);
        }
        this.operatorStyle = styleRegistry.lookupStyle(BUILTIN_OPERATOR_STYLE);
        if (this.operatorStyle == null) {
            String name = resources.getString("BUILTIN_OPERATOR_STYLE");
            this.operatorStyle = styleRegistry.createStyle(BUILTIN_OPERATOR_STYLE, name, BUILTIN_PLAIN_STYLE);
        }
        this.markupStyle = styleRegistry.lookupStyle(BUILTIN_MARKUP_STYLE);
        if (this.markupStyle == null) {
            String name = resources.getString("BUILTIN_MARKUP_STYLE");
            this.markupStyle = styleRegistry.createStyle(BUILTIN_MARKUP_STYLE, name, BUILTIN_PLAIN_STYLE, Color.blue);
        }
        this.elementStyle = styleRegistry.lookupStyle(BUILTIN_ELEMENT_STYLE);
        if (this.elementStyle == null) {
            String name = resources.getString("BUILTIN_ELEMENT_STYLE");
            this.elementStyle = styleRegistry.createStyle(BUILTIN_ELEMENT_STYLE, name, BUILTIN_PLAIN_STYLE, Color.blue, 1);
        }
        this.attributeNameStyle = styleRegistry.lookupStyle(BUILTIN_ATTRIBUTE_NAME_STYLE);
        if (this.attributeNameStyle == null) {
            String name = resources.getString("BUILTIN_ATTRIBUTE_NAME_STYLE");
            this.attributeNameStyle = styleRegistry.createStyle(BUILTIN_ATTRIBUTE_NAME_STYLE, name, BUILTIN_PLAIN_STYLE, new Color(102, 0, 102));
        }
        this.attributeValueStyle = styleRegistry.lookupStyle(BUILTIN_ATTRIBUTE_VALUE_STYLE);
        if (this.attributeValueStyle == null) {
            String name = resources.getString("BUILTIN_ATTRIBUTE_VALUE_STYLE");
            this.attributeValueStyle = styleRegistry.createStyle(BUILTIN_ATTRIBUTE_VALUE_STYLE, name, BUILTIN_PLAIN_STYLE, new Color(204, 0, 204));
        }
        this.headerStyle = styleRegistry.lookupStyle(BUILTIN_HEADER_STYLE);
        if (this.headerStyle == null) {
            String name = resources.getString("BUILTIN_HEADER_STYLE");
            this.headerStyle = styleRegistry.createStyle(BUILTIN_HEADER_STYLE, name, BUILTIN_PLAIN_STYLE, new Color(57, 57, 107));
        }
        this.additionStyle = styleRegistry.lookupStyle(BUILTIN_ADDITION_STYLE);
        if (this.additionStyle == null) {
            String name = resources.getString("BUILTIN_ADDITION_STYLE");
            this.additionStyle = styleRegistry.createStyle(BUILTIN_ADDITION_STYLE, name, BUILTIN_PLAIN_STYLE, new Color(0, 128, 0));
        }
        this.removalStyle = styleRegistry.lookupStyle(BUILTIN_REMOVAL_STYLE);
        if (this.removalStyle == null) {
            String name = resources.getString("BUILTIN_REMOVAL_STYLE");
            this.removalStyle = styleRegistry.createStyle(BUILTIN_REMOVAL_STYLE, name, BUILTIN_PLAIN_STYLE, new Color(128, 0, 0));
        }
    }
}

