/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

public final class BooleanBitmap {
    private static final int[] EMPTY_BITMAP = new int[0];
    private static final int[] FILL_HELPER = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int[] bitmap = EMPTY_BITMAP;
    private int userSize;
    private boolean userFill;
    private boolean doInitialize;

    public BooleanBitmap(int initialSize) {
        this.userFill = false;
        this.userSize = 0;
        this.doInitialize = false;
        this.setSize(initialSize);
    }

    public BooleanBitmap(int initialSize, boolean defaultFill) {
        this.userFill = defaultFill;
        this.userSize = 0;
        this.doInitialize = true;
        this.setSize(initialSize);
    }

    public int getSize() {
        return this.userSize;
    }

    public void setSize(int requestedSize) {
        if (requestedSize > this.userSize) {
            int oldArraySize = this.bitmap.length;
            int newArraySize = requestedSize / 32 + 1;
            if (oldArraySize != newArraySize) {
                int[] newBitmap = new int[newArraySize];
                System.arraycopy(this.bitmap, 0, newBitmap, 0, oldArraySize);
                if (this.doInitialize && newArraySize > oldArraySize) {
                    int fill = this.userFill ? -1 : 0;
                    int i = oldArraySize;
                    while (i < newArraySize) {
                        newBitmap[i] = fill;
                        ++i;
                    }
                }
                this.bitmap = newBitmap;
            }
            this.userSize = requestedSize;
        } else if (requestedSize < this.userSize) {
            int oldArraySize = this.bitmap.length;
            int newArraySize = requestedSize / 32 + 1;
            if (oldArraySize != newArraySize) {
                int[] newBitmap = new int[newArraySize];
                System.arraycopy(this.bitmap, 0, newBitmap, 0, newArraySize);
                this.bitmap = newBitmap;
            }
            if (this.doInitialize) {
                int validBits = requestedSize % 32;
                int lastEntry = newArraySize - 1;
                this.bitmap[lastEntry] = this.userFill ? this.bitmap[lastEntry] | ~FILL_HELPER[validBits - 1] : this.bitmap[lastEntry] & FILL_HELPER[validBits - 1];
            }
            this.userSize = requestedSize;
        }
    }

    public boolean get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.userSize) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        int arrayIndex = index / 32;
        int bitIndex = index - arrayIndex * 32;
        int bitMask = 1 << bitIndex;
        int bitVal = this.bitmap[arrayIndex] & bitMask;
        return bitVal != 0;
    }

    public void set(int index, boolean newValue) {
        if (index < 0 || index >= this.userSize) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        int arrayIndex = index / 32;
        int bitIndex = index - arrayIndex * 32;
        int bitMask = 1 << bitIndex;
        this.bitmap[arrayIndex] = newValue ? this.bitmap[arrayIndex] | bitMask : this.bitmap[arrayIndex] & ~bitMask;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        char[] val = new char[1];
        int listSize = this.getSize();
        int i = 0;
        while (i < listSize) {
            val[0] = this.get(i) ? 49 : 48;
            buf.append(val);
            ++i;
        }
        return buf.toString();
    }
}

