/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.keys.MultiKeymap;
import oracle.javatools.resource.BundleHelper;

public class MultiKeyHandler
implements KeyListener,
FocusListener {
    private ActionInvoker actionInvoker = null;
    private MultiKeymap multiKeymap;
    private KeyStroke[] partialKeys;
    private int numPartialKeys;
    private Component component = null;
    private char charToEat;
    private int modifierToEat;
    private KeyListener keyFilter;
    private static final String INSTALLED_HANDLER = "*installed-handler*";
    protected static final String ACCELERATOR_PENDING;
    protected static final String ACCELERATOR_UNKNOWN;

    public MultiKeyHandler(MultiKeymap multiKeymap) {
        this.multiKeymap = multiKeymap;
        this.partialKeys = new KeyStroke[10];
        this.numPartialKeys = 0;
        this.charToEat = (char)65535;
    }

    public void install(Component component, ActionInvoker actionInvoker) {
        if (this.component != null) {
            throw new IllegalStateException("cannot install a second time");
        }
        this.component = component;
        this.actionInvoker = actionInvoker;
        component.addKeyListener(this);
        component.addFocusListener(this);
        this.keyFilter = null;
        if (component instanceof BasicEditorPane) {
            BasicEditorPane editor = (BasicEditorPane)component;
            editor.putProperty(INSTALLED_HANDLER, this);
        }
    }

    public void deinstall() {
        if (this.component == null) {
            throw new IllegalStateException("cannot deinstall, not installed");
        }
        if (this.component instanceof BasicEditorPane) {
            BasicEditorPane editor = (BasicEditorPane)this.component;
            editor.putProperty(INSTALLED_HANDLER, null);
        }
        this.keyFilter = null;
        if (this.numPartialKeys > 0) {
            this.hideFeedback();
        }
        this.numPartialKeys = 0;
        this.component.removeKeyListener(this);
        this.component.removeFocusListener(this);
        this.component = null;
        this.actionInvoker = null;
    }

    public static MultiKeyHandler getInstalledHandler(BasicEditorPane editor) {
        return (MultiKeyHandler)editor.getProperty(INSTALLED_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyFilter(KeyListener filterToAdd) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            this.keyFilter = filterToAdd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyFilter(KeyListener filterToRemove) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter == filterToRemove) {
                this.keyFilter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent event) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter != null) {
                this.keyFilter.keyPressed(event);
            }
        }
        switch (event.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return;
            }
        }
        KeyStroke keystroke = KeyStroke.getKeyStrokeForEvent(event);
        this.partialKeys[this.numPartialKeys++] = keystroke;
        String actionKey = this.multiKeymap.get(this.partialKeys, this.numPartialKeys);
        if (actionKey != null) {
            this.consumePressedEvent(event);
            if (actionKey != "partial") {
                if (this.numPartialKeys > 1) {
                    this.hideFeedback();
                }
                try {
                    this.actionInvoker.invokeAction(actionKey);
                }
                catch (RuntimeException e) {
                    System.out.println("Exception invoking action: " + actionKey);
                    e.printStackTrace();
                }
                this.numPartialKeys = 0;
            } else {
                String message = MultiKeyHandler.buildMessage(ACCELERATOR_PENDING, this.partialKeys, this.numPartialKeys);
                this.showFeedback(message);
            }
        } else {
            if (this.numPartialKeys > 1) {
                this.consumePressedEvent(event);
                String message = MultiKeyHandler.buildMessage(ACCELERATOR_UNKNOWN, this.partialKeys, this.numPartialKeys);
                this.showTemporaryFeedback(message);
            }
            this.numPartialKeys = 0;
        }
    }

    private void consumePressedEvent(KeyEvent event) {
        event.consume();
        this.charToEat = event.getKeyChar();
        this.modifierToEat = event.getModifiers();
        if (this.modifierToEat == 1) {
            this.modifierToEat = 0;
        }
        if (this.charToEat == ' ') {
            this.modifierToEat = 0;
        }
        if (this.modifierToEat == 2 && this.charToEat == '[') {
            this.charToEat = (char)27;
        }
    }

    private void eatTypedEvent(KeyEvent event) {
        if (this.charToEat != '\uffff' && this.charToEat == event.getKeyChar()) {
            event.consume();
        }
        this.charToEat = (char)65535;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent event) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter != null) {
                this.keyFilter.keyTyped(event);
            }
        }
        this.eatTypedEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent event) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter != null) {
                this.keyFilter.keyReleased(event);
            }
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.numPartialKeys != 0) {
            this.hideFeedback();
        }
        this.numPartialKeys = 0;
    }

    protected static String buildMessage(String template, KeyStroke[] keys, int numKeys) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < numKeys) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(" ");
            MultiKeyHandler.appendKeyText(buffer, keys[i]);
            ++i;
        }
        String keyText = buffer.toString();
        buffer.delete(0, buffer.length());
        buffer.append(template);
        int replacePos = template.indexOf("{0}");
        if (replacePos != -1) {
            buffer.replace(replacePos, replacePos + 3, keyText);
        }
        return buffer.toString();
    }

    protected static void appendKeyText(StringBuffer buffer, KeyStroke key) {
        int modifiers;
        String DELIMITER;
        int keycode = key.getKeyCode();
        if (keycode == 0) {
            buffer.append("<unknown>");
        }
        if ((DELIMITER = UIManager.getString("MenuItem.acceleratorDelimiter")) == null || DELIMITER.length() == 0) {
            DELIMITER = "+";
        }
        if (((modifiers = key.getModifiers()) & 4) != 0) {
            buffer.append(Toolkit.getProperty("AWT.meta", "Meta"));
            buffer.append(DELIMITER);
        }
        if ((modifiers & 2) != 0) {
            buffer.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            buffer.append(DELIMITER);
        }
        if ((modifiers & 8) != 0) {
            buffer.append(Toolkit.getProperty("AWT.alt", "Alt"));
            buffer.append(DELIMITER);
        }
        if ((modifiers & 1) != 0) {
            buffer.append(Toolkit.getProperty("AWT.shift", "Shift"));
            buffer.append(DELIMITER);
        }
        if ((modifiers & 0x20) != 0) {
            buffer.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            buffer.append(DELIMITER);
        }
        buffer.append(KeyEvent.getKeyText(keycode));
    }

    protected void showFeedback(String text) {
        BasicEditorPane editor;
        FeedbackManager feedbackManager;
        if (this.component instanceof BasicEditorPane && (feedbackManager = (editor = (BasicEditorPane)this.component).getFeedbackManager()) != null) {
            feedbackManager.showFeedback(editor, text);
        }
    }

    protected void showTemporaryFeedback(String text) {
        BasicEditorPane editor;
        FeedbackManager feedbackManager;
        if (this.component instanceof BasicEditorPane && (feedbackManager = (editor = (BasicEditorPane)this.component).getFeedbackManager()) != null) {
            feedbackManager.showFeedback(editor, text, 4000);
        }
    }

    protected void hideFeedback() {
        BasicEditorPane editor;
        FeedbackManager feedbackManager;
        if (this.component instanceof BasicEditorPane && (feedbackManager = (editor = (BasicEditorPane)this.component).getFeedbackManager()) != null) {
            feedbackManager.hideFeedback(editor);
        }
    }

    static {
        BundleHelper resources = EditorProperties.getEditorBundle();
        ACCELERATOR_PENDING = resources.getString("ACCELERATOR_PENDING");
        ACCELERATOR_UNKNOWN = resources.getString("ACCELERATOR_UNKNOWN");
    }
}

