/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ListUI;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.TooltipDataItemCellRenderer;
import oracle.javatools.editor.popup.PopupWindow;

public class TooltipInsightView
extends JList
implements InsightView {
    private ListInsightData insightData;
    private PopupWindow popupWindow;

    public TooltipInsightView() {
        this(new TooltipDataItemCellRenderer());
    }

    public TooltipInsightView(ListCellRenderer renderer) {
        if (renderer != null) {
            this.setCellRenderer(renderer);
        }
        this.insightData = null;
        this.setSelectionMode(0);
    }

    public TooltipInsightView(ListInsightData insightData) {
        this(insightData, null);
    }

    public TooltipInsightView(ListInsightData insightData, ListCellRenderer renderer) {
        super(insightData.getListModel());
        this.insightData = insightData;
        if (renderer != null) {
            this.setCellRenderer(renderer);
        }
        this.setSelectionMode(0);
    }

    public void setUI(ListUI ui) {
        super.setUI(ui);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(this, "ToolTip.border");
        EditorProperties properties = EditorProperties.getProperties();
        String fontName = (String)properties.getProperty("insight-font-family");
        int fontSize = properties.getIntegerProperty("insight-font-size");
        Font insightFont = new Font(fontName, 0, fontSize);
        this.setFont(insightFont);
    }

    public void setPopupWindow(PopupWindow popup) {
        this.popupWindow = popup;
    }

    public void setData(InsightData newData) {
        if (newData instanceof ListInsightData) {
            PrototypeCellProvider prototypeProvider;
            Object prototypeCell;
            this.insightData = (ListInsightData)newData;
            ListModel listModel = this.insightData.getListModel();
            this.setModel(listModel);
            ListCellRenderer cellRenderer = this.getCellRenderer();
            if (cellRenderer instanceof PrototypeCellProvider && (prototypeCell = (prototypeProvider = (PrototypeCellProvider)((Object)cellRenderer)).getPrototypeCell(this, listModel)) != null) {
                this.setPrototypeCellValue(prototypeCell);
            }
        } else {
            throw new IllegalArgumentException("newData not ListInsightData.");
        }
    }

    public void selectDefault() {
    }

    public InsightData getData() {
        return this.insightData;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean up() {
        return false;
    }

    public boolean down() {
        return false;
    }

    public boolean right() {
        return false;
    }

    public boolean left() {
        return false;
    }

    public boolean pageUp() {
        return false;
    }

    public boolean pageDown() {
        return false;
    }

    public boolean begin() {
        return false;
    }

    public boolean end() {
        return false;
    }

    public boolean complete(Insight insight) {
        return false;
    }

    public boolean partialComplete() {
        return false;
    }
}

