/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.TooltipDataItem;

public class TooltipDataItemCellRenderer
extends DefaultListCellRenderer
implements PrototypeCellProvider {
    public Dimension getPreferredSize() {
        EditorProperties properties = EditorProperties.getProperties();
        int maxWidth = properties.getIntegerProperty("insight-max-popup-width");
        Dimension screenSize = this.getToolkit().getScreenSize();
        maxWidth = Math.min(screenSize.width / 2 - 5, maxWidth);
        Dimension size = super.getPreferredSize();
        Dimension newSize = new Dimension(Math.min(maxWidth, size.width), size.height);
        return newSize;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
        JLabel label = (JLabel)component;
        if (value instanceof TooltipDataItem) {
            TooltipDataItem dataItem = (TooltipDataItem)value;
            String displayText = dataItem.getDisplayText();
            label.setText(displayText);
        }
        return label;
    }

    public Object getPrototypeCell(JList list, ListModel listModel) {
        String displayText = "";
        int displayWidth = 0;
        Font font = list.getFont();
        FontMetrics metrics = list.getFontMetrics(font);
        int numElements = listModel.getSize();
        int i = 0;
        while (i < numElements) {
            String elementText;
            Object element = listModel.getElementAt(i);
            if (element instanceof TooltipDataItem) {
                TooltipDataItem listItem = (TooltipDataItem)element;
                elementText = listItem.getDisplayText();
            } else {
                elementText = element.toString();
            }
            int elementWidth = metrics.stringWidth(elementText);
            if (elementWidth > displayWidth) {
                displayWidth = elementWidth;
                displayText = elementText;
            }
            ++i;
        }
        DummyItem prototypeItem = new DummyItem(displayText);
        return prototypeItem;
    }

    private static final class DummyItem
    extends TooltipDataItem {
        private String name;

        DummyItem(String name) {
            this.name = name;
        }

        public String getDisplayText() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

