/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ListUI;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.popup.PopupWindow;

public class ListInsightView
extends JList
implements InsightView {
    private ListInsightData insightData;
    private PopupWindow popupWindow;

    public ListInsightView() {
        this(new ListDataItemCellRenderer());
    }

    public ListInsightView(ListCellRenderer renderer) {
        if (renderer != null) {
            this.setCellRenderer(renderer);
        }
        this.insightData = null;
        this.setSelectionMode(0);
    }

    public void setUI(ListUI ui) {
        super.setUI(ui);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        Color backgroundColor = this.getBackground();
        Color selectionBGColor = this.getSelectionBackground();
        if (backgroundColor.equals(selectionBGColor)) {
            this.setSelectionBackground(this.getForeground());
            this.setSelectionForeground(this.getBackground());
        }
        EditorProperties properties = EditorProperties.getProperties();
        String fontName = (String)properties.getProperty("insight-font-family");
        int fontSize = properties.getIntegerProperty("insight-font-size");
        Font insightFont = new Font(fontName, 0, fontSize);
        this.setFont(insightFont);
    }

    public int getVisibleRowCount() {
        int defaultRowCount = super.getVisibleRowCount();
        ListModel listModel = this.getModel();
        int actualRowCount = listModel.getSize();
        return Math.min(actualRowCount, defaultRowCount);
    }

    public void setSelectionInterval(int anchor, int lead) {
        Object obj;
        super.setSelectionInterval(anchor, lead);
        if (this.popupWindow != null && (obj = this.getModel().getElementAt(anchor)) instanceof ListDataItem) {
            ListDataItem listDataItem = (ListDataItem)obj;
            this.popupWindow.setAccessibleName(listDataItem.getAccessibleText());
        }
    }

    public void setPopupWindow(PopupWindow popup) {
        this.popupWindow = popup;
    }

    public void setData(InsightData newData) {
        if (newData instanceof ListInsightData) {
            PrototypeCellProvider prototypeProvider;
            Object prototypeCell;
            this.insightData = (ListInsightData)newData;
            ListModel listModel = this.getListModel(this.insightData);
            this.setModel(listModel);
            ListCellRenderer cellRenderer = this.getCellRenderer();
            if (cellRenderer instanceof PrototypeCellProvider && (prototypeCell = (prototypeProvider = (PrototypeCellProvider)((Object)cellRenderer)).getPrototypeCell(this, listModel)) != null) {
                this.setPrototypeCellValue(prototypeCell);
            }
        } else {
            throw new IllegalArgumentException("newData not ListInsightData.");
        }
    }

    protected ListModel getListModel(ListInsightData insightData) {
        Object[] matchingData;
        EditorProperties properties = EditorProperties.getProperties();
        boolean useFilter = properties.getBooleanProperty("insight-filter-matching");
        if (useFilter && (matchingData = insightData.getMatchingData()) != null && matchingData.length > 0) {
            int numItems = matchingData.length;
            ListDataItem[] dataList = new ListDataItem[numItems];
            System.arraycopy(matchingData, 0, dataList, 0, numItems);
            ReadOnlyListModel<ListDataItem> listModel = new ReadOnlyListModel<ListDataItem>(dataList);
            return listModel;
        }
        ListModel listModel = insightData.getListModel();
        return listModel;
    }

    public void selectDefault() {
        Object defaultData = this.insightData.getDefault();
        int index = 0;
        if (defaultData != null) {
            ListModel listModel = this.getModel();
            int listSize = listModel.getSize();
            int i = 0;
            while (i < listSize) {
                if (listModel.getElementAt(i) == defaultData) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        this.centerIndexIfNotVisible(index);
        this.setSelectionInterval(index, index);
    }

    private void centerIndexIfNotVisible(int index) {
        Rectangle cellBounds = this.getCellBounds(index, index);
        if (cellBounds != null) {
            Rectangle visibleRect = new Rectangle();
            this.computeVisibleRect(visibleRect);
            if (visibleRect.y <= cellBounds.y && cellBounds.y + cellBounds.height <= visibleRect.y + visibleRect.height) {
                return;
            }
            visibleRect.y = cellBounds.y - (visibleRect.height - cellBounds.height >> 1);
            int listHeight = this.getHeight();
            if (visibleRect.y < 0) {
                visibleRect.y = 0;
            }
            if (visibleRect.y + visibleRect.height > listHeight) {
                visibleRect.y = listHeight - visibleRect.height;
            }
            this.scrollRectToVisible(visibleRect);
        }
    }

    public InsightData getData() {
        return this.insightData;
    }

    public JComponent getComponent() {
        return this;
    }

    protected boolean supportWrapping() {
        return true;
    }

    protected boolean isAtBeginList() {
        int firstIndex = 0;
        return this.getSelectedIndex() == firstIndex;
    }

    protected boolean isAtEndList() {
        int lastIndex = this.getModel().getSize() - 1;
        return this.getSelectedIndex() == lastIndex;
    }

    public boolean up() {
        if (this.supportWrapping() && this.isAtBeginList()) {
            this.end();
        } else {
            int index = Math.max(this.getSelectedIndex() - 1, 0);
            this.ensureIndexIsVisible(index);
            this.setSelectionInterval(index, index);
        }
        return true;
    }

    public boolean down() {
        if (this.supportWrapping() && this.isAtEndList()) {
            this.begin();
        } else {
            int listSize = this.getModel().getSize() - 1;
            int index = Math.min(this.getSelectedIndex() + 1, listSize);
            this.ensureIndexIsVisible(index);
            this.setSelectionInterval(index, index);
        }
        return true;
    }

    public boolean right() {
        return false;
    }

    public boolean left() {
        return false;
    }

    public boolean pageUp() {
        if (this.supportWrapping() && this.isAtBeginList()) {
            this.end();
        } else {
            int selectedIndex = this.getSelectedIndex();
            int firstIndex = this.getFirstVisibleIndex();
            if (firstIndex == -1) {
                return false;
            }
            Point selectedLocation = this.indexToLocation(selectedIndex);
            Point firstLocation = this.indexToLocation(firstIndex);
            Rectangle visibleRect = this.getVisibleRect();
            selectedLocation.y -= visibleRect.height;
            firstLocation.y -= visibleRect.height;
            int newSelectedIndex = Math.max(this.locationToIndex(selectedLocation), 0);
            int newFirstIndex = Math.max(this.locationToIndex(firstLocation), 0);
            this.ensureIndexIsVisible(newFirstIndex);
            this.ensureIndexIsVisible(newSelectedIndex);
            this.setSelectionInterval(newSelectedIndex, newSelectedIndex);
        }
        return true;
    }

    public boolean pageDown() {
        if (this.supportWrapping() && this.isAtEndList()) {
            this.begin();
        } else {
            int selectedIndex = this.getSelectedIndex();
            int lastIndex = this.getLastVisibleIndex();
            if (lastIndex == -1) {
                return false;
            }
            Point selectedLocation = this.indexToLocation(selectedIndex);
            Point lastLocation = this.indexToLocation(lastIndex);
            Rectangle visibleRect = this.getVisibleRect();
            selectedLocation.y += visibleRect.height;
            lastLocation.y += visibleRect.height;
            int lastItem = this.getModel().getSize() - 1;
            int newSelectedIndex = this.locationToIndex(selectedLocation);
            int newLastIndex = this.locationToIndex(lastLocation);
            if (newSelectedIndex == -1) {
                newSelectedIndex = lastItem;
            }
            if (newLastIndex == -1) {
                newLastIndex = lastItem;
            }
            this.ensureIndexIsVisible(newLastIndex);
            this.ensureIndexIsVisible(newSelectedIndex);
            this.setSelectionInterval(newSelectedIndex, newSelectedIndex);
        }
        return true;
    }

    public boolean begin() {
        this.ensureIndexIsVisible(0);
        this.setSelectionInterval(0, 0);
        return true;
    }

    public boolean end() {
        int listSize = this.getModel().getSize() - 1;
        this.ensureIndexIsVisible(listSize);
        this.setSelectionInterval(listSize, listSize);
        return true;
    }

    public boolean complete(Insight insight) {
        int index = this.getSelectedIndex();
        ListModel model = this.getModel();
        if (index < 0 || index >= model.getSize()) {
            System.err.println("selected index out of bounds: " + index);
        } else {
            Object selectedData = model.getElementAt(index);
            boolean retrigger = this.insightData.complete(selectedData);
            insight.hideInsight();
            if (retrigger) {
                insight.restartPopupTimer();
            }
        }
        return true;
    }

    public boolean partialComplete() {
        this.insightData.partialComplete();
        return true;
    }
}

