/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.gutter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Document;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineGutterPlugin
extends JComponent
implements ComponentListener,
DocumentListener,
EditorPlugin,
Gutter,
MouseListener,
MouseMotionListener,
TextBufferListener {
    private static final Log LOG;
    public static final int SHOW_LINE_NUMBERS_ALWAYS = 1;
    public static final int SHOW_LINE_NUMBERS_NEVER = 2;
    public static final int SHOW_LINE_NUMBERS_DEFAULT = 3;
    protected int _showLineNumberFlag;
    protected static List<Column.Mark> _scratchList;
    private static final boolean JUSTIFY_MARKS_RIGHT = true;
    private static final int LEFT_PADDING = 1;
    private static final int RIGHT_PADDING = 3;
    private static final int ICON_SPACING = 2;
    private static final int MINIMUM_DIGITS = 3;
    private int _minimumDigits;
    private List<Column> _columnsList;
    private int[] _columnGroupWidths;
    private boolean[] _columnGroupIsTiled;
    private int _preferredWidth;
    private int _reservedColumnWidth;
    private static final int MAX_ICON_WIDTH = 24;
    private CopyOnWriteArrayList<GutterClickListener> _clickListeners;
    private BasicEditorPane _editor;
    private HighlightLayer _highlightLayer;
    private BasicDocument _document;
    private Font _font;
    private int _fontHeight;
    private int _fontAscent;
    private int _fontWidth;
    private int _lineCount;
    private int _rowCount;
    private volatile boolean _gutterResizeNeeded;
    private Dimension _gutterSize;
    private Rectangle _gutterBounds;
    private Rectangle _rolloverBounds;
    private boolean _showLineNumbers;
    private Color _borderColor;
    private int _pressedY;
    private boolean _selectStarted;
    private boolean _inReload;
    private int _location;
    private List<Column.Mark> temporaryMarksOnLine;
    private List<String> temporaryOverlaidColumns;
    private static final int DRAG_SENSITIVITY = 4;
    protected boolean _mouseInGutter;
    protected GutterMark _mouseInMark;
    static final /* synthetic */ boolean $assertionsDisabled;
    protected static final Comparator<GutterMark> MARK_COMPARATOR;

    public LineGutterPlugin() {
        this.$init$();
        this.setFocusable(false);
        this.setOpaque(true);
    }

    @Override
    public void install(BasicEditorPane editor) {
        LOG.trace("installing {0}", (Object)this);
        this._columnsList = new ArrayList<Column>(5);
        this._clickListeners = new CopyOnWriteArrayList();
        this._editor = editor;
        this.installDocument((BasicDocument)editor.getDocument());
        this._inReload = false;
        this._highlightLayer = editor.createHighlightLayer();
        this._gutterResizeNeeded = true;
        this._gutterSize = new Dimension();
        this._gutterBounds = new Rectangle();
        this._rolloverBounds = new Rectangle();
        this.updateShowLineNumbers();
        this.updateMetrics();
        this.updateColors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        editor.addComponentListener(this);
        this.setAutoscrolls(this.allowDragging());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    protected void installDocument(BasicDocument document) {
        this._document = document;
        this._document.addDocumentListener(this);
        LineMap lineMap = document.getLineMap();
        this._lineCount = lineMap.getLineCount();
        TextBuffer textBuffer = document.getTextBuffer();
        textBuffer.addTextBufferListener((TextBufferListener)this);
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        LOG.trace("deinstalling {0}", (Object)this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.unregisterComponent(this);
        this.setAutoscrolls(false);
        editor.removeComponentListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.deinstallDocument(this._document);
        this._font = null;
        this._highlightLayer.removeAllHighlights();
        this._editor.destroyHighlightLayer(this._highlightLayer);
        this._highlightLayer = null;
        this._editor = null;
        this._columnsList = null;
        this._reservedColumnWidth = -1;
        this._clickListeners = null;
    }

    protected void deinstallDocument(BasicDocument document) {
        if (document != null && document == this._document) {
            this._document.removeDocumentListener(this);
            TextBuffer textBuffer = this._document.getTextBuffer();
            textBuffer.removeTextBufferListener((TextBufferListener)this);
            this._document = null;
        }
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this._mouseInMark != null) {
            Column column = (Column)this._mouseInMark.getGutterColumn();
            return column.getMarkToolTip(this._mouseInMark, event);
        }
        return null;
    }

    private void $init$() {
        this._showLineNumberFlag = 3;
        this._minimumDigits = 3;
        this._preferredWidth = -1;
        this._reservedColumnWidth = -1;
        this._location = 2;
        this.temporaryMarksOnLine = new ArrayList<Column.Mark>();
        this.temporaryOverlaidColumns = new ArrayList<String>();
        this._mouseInGutter = false;
        this._mouseInMark = null;
    }

    protected void updateShowLineNumbers() {
        boolean oldValue = this._showLineNumbers;
        switch (this._showLineNumberFlag) {
            case 1: {
                this._showLineNumbers = true;
                break;
            }
            case 2: {
                this._showLineNumbers = false;
                break;
            }
            default: {
                this._showLineNumbers = this._editor.getBooleanProperty("show-line-numbers");
                break;
            }
        }
        if (this._showLineNumbers != oldValue) {
            this.linesChanged();
        }
    }

    public void setShowLineNumbers(int showFlag) {
        switch (showFlag) {
            case 1: 
            case 2: {
                this._showLineNumberFlag = showFlag;
                break;
            }
            default: {
                this._showLineNumberFlag = 3;
                break;
            }
        }
        if (this._editor != null) {
            this.updateShowLineNumbers();
        }
    }

    public void setLocation(int location) {
        this._location = location;
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("show-line-numbers")) {
            this.updateShowLineNumbers();
        } else if (propertyName.equals("gutter-enable-selection")) {
            this.setAutoscrolls(this.allowDragging());
        } else if (propertyName.equals("editor-font")) {
            this.updateMetrics();
        } else if (propertyName.equals("gutter-color-source") || propertyName.equals("gutter-custom-bgcolor") || propertyName.equals("gutter-custom-fgcolor") || propertyName.equals("gutter-default-bordercolor") || propertyName.equals("style-registry")) {
            this.updateColors();
            this.repaint();
        } else if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                this.deinstallDocument(this._document);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                this.installDocument((BasicDocument)newValue);
            }
            this.discardAllMarks();
        }
    }

    protected void discardAllMarks() {
        int numColumns = this._columnsList.size();
        int i = numColumns - 1;
        while (i >= 0) {
            Column column = this._columnsList.get(i);
            column.discardAllGutterMarks();
            --i;
        }
    }

    protected static synchronized List<Column.Mark> allocateScratchList() {
        List<Column.Mark> listToUse = _scratchList;
        _scratchList = null;
        if (listToUse == null) {
            listToUse = new ArrayList<Column.Mark>(100);
        }
        return listToUse;
    }

    protected static synchronized void freeScratchList(List<Column.Mark> listToFree) {
        if (listToFree != null && _scratchList == null) {
            _scratchList = listToFree;
            listToFree.clear();
        }
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.updateColors();
    }

    public void getMarksOnLine(Collection<Column.Mark> collection, int line) {
        int numColumns = this._columnsList.size();
        int i = numColumns - 1;
        while (i >= 0) {
            Column column = this._columnsList.get(i);
            column.getMarks(collection, line);
            --i;
        }
    }

    private void columnsChanged() {
        this._preferredWidth = -1;
        this._reservedColumnWidth = -1;
        this.revalidate();
        this.updateMouseInMark(null);
        this.repaint();
    }

    private void markChanged(GutterMark mark, int oldWidth, int newWidth) {
        if (this._preferredWidth >= 0) {
            int line = mark.getLine();
            if (oldWidth == newWidth) {
                this.repaintLine(line);
            } else {
                Column changedColumn = (Column)mark.getGutterColumn();
                int reservedWidth = this._columnGroupWidths[changedColumn.groupIndex];
                if (oldWidth <= reservedWidth && newWidth <= reservedWidth) {
                    if (!this._columnGroupIsTiled[changedColumn.groupIndex]) {
                        this.repaintLine(line);
                    } else {
                        List<Column> group = changedColumn.group;
                        List<Column.Mark> marks = LineGutterPlugin.allocateScratchList();
                        int i = 0;
                        while (i < group.size()) {
                            Column column = this._columnsList.get(i);
                            column.getMarks(marks, line);
                            if (marks.size() > 1) break;
                            ++i;
                        }
                        if (marks.size() == 1 && mark == marks.get(0)) {
                            LOG.trace("repainting after scanning marks on line {0}", line);
                            this.repaintLine(line);
                        } else {
                            LOG.trace("revalidating after scanning marks on line {0}", line);
                            this.marksChanged();
                        }
                        LineGutterPlugin.freeScratchList(marks);
                    }
                } else {
                    LOG.trace("revalidating after width change {0} to {1} on line {2}, reserved {3}", oldWidth, newWidth, line, reservedWidth);
                    this.marksChanged();
                }
            }
        }
    }

    private void marksChanged() {
        this._preferredWidth = -1;
        this.revalidate();
        this.updateMouseInMark(null);
        this.repaint();
    }

    private void columnMarksRemoved(Column column) {
        if (this._preferredWidth < 0) {
            return;
        }
        int index = column.groupIndex;
        if (this._columnGroupIsTiled[index]) {
            this.marksChanged();
        } else {
            List<Column.Mark> marks = column._marksList;
            int reservedWidth = column.getReservedWidth();
            int i = 0;
            while (i < marks.size()) {
                GutterMark mark = marks.get(i);
                if (this.markWidth(mark) > reservedWidth) {
                    this.marksChanged();
                    return;
                }
                ++i;
            }
            this.updateMouseInMark(null);
        }
        this.repaint();
    }

    private void linesChanged() {
        this.revalidate();
        this.updateMouseInMark(null);
        this.repaint();
    }

    protected void updateColors() {
        Color fgColor;
        Color bgColor;
        if (this._editor == null) {
            return;
        }
        int source = this._editor.getIntegerProperty("gutter-color-source");
        switch (source) {
            case 3: {
                bgColor = (Color)this._editor.getProperty("gutter-custom-bgcolor");
                this._borderColor = fgColor = (Color)this._editor.getProperty("gutter-custom-fgcolor");
                break;
            }
            case 2: {
                StyleRegistry registry = this._editor.getStyleRegistry();
                BaseStyle baseStyle = registry.lookupStyle("base-plain-style");
                bgColor = baseStyle.getBackgroundColor();
                this._borderColor = fgColor = baseStyle.getForegroundColor();
                break;
            }
            default: {
                bgColor = UIManager.getColor("control");
                fgColor = Color.darkGray;
                if (bgColor.equals(fgColor)) {
                    fgColor = Color.lightGray;
                }
                this._borderColor = Color.gray;
                break;
            }
        }
        Color defaultBorder = (Color)this._editor.getProperty("gutter-default-bordercolor");
        if (defaultBorder != null) {
            this._borderColor = defaultBorder;
        }
        if (bgColor != null) {
            this.setBackground(bgColor);
        }
        if (fgColor != null) {
            this.setForeground(fgColor);
        }
    }

    protected void updateMetrics() {
        Font currentFont = this._editor.getFont();
        if (this._font == null || currentFont != this._font) {
            this._font = currentFont;
            FontMetrics metrics = this.getFontMetrics(currentFont);
            this._fontHeight = metrics.getHeight();
            this._fontAscent = metrics.getAscent();
            this._fontWidth = metrics.charWidth('0');
            this.linesChanged();
        }
    }

    @Override
    public void revalidate() {
        this._gutterResizeNeeded = true;
        super.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this._gutterResizeNeeded) {
            return this._gutterSize;
        }
        if (this._editor == null) {
            return new Dimension(0, 0);
        }
        int lineWidth = this.recalculateLineWidths();
        int columnWidth = this.recalculateColumnWidths();
        int editorHeight = this._editor.getHeight();
        this._rowCount = this.getRowCount();
        this._gutterSize.width = Math.max(lineWidth, columnWidth);
        this._gutterSize.height = editorHeight;
        this._gutterResizeNeeded = false;
        return this._gutterSize;
    }

    protected void repaintLine(int line, int extraPixels) {
        if (line <= 0 || line > this._lineCount) {
            return;
        }
        this.updateMouseInMark(null);
        int row = this.getRowFromLine(line);
        int offsetY = (row - 1) * this._fontHeight + this.getTopPadding();
        this.repaint(0, offsetY - extraPixels, this.getWidth(), this._fontHeight + extraPixels * 2);
    }

    protected void repaintLine(int line) {
        this.repaintLine(line, 0);
    }

    @Override
    public void paint(Graphics graphics) {
        int topPadding = this.getTopPadding();
        Rectangle clipRect = graphics.getClipBounds();
        this._gutterBounds.x = 0;
        this._gutterBounds.y = 0;
        this._gutterBounds.width = this.getWidth();
        this._gutterBounds.height = this.getHeight();
        clipRect = clipRect.intersection(this._gutterBounds);
        graphics.setFont(this._font);
        graphics.setColor(this.getBackground());
        if (this.isOpaque()) {
            graphics.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        }
        Color fgColor = this.getForeground();
        if (this._borderColor != null) {
            graphics.setColor(this._borderColor);
        } else {
            graphics.setColor(fgColor);
        }
        if (this._location == 4) {
            graphics.drawLine(this._gutterBounds.x, clipRect.y, this._gutterBounds.x, clipRect.y + clipRect.height - 1);
        } else {
            graphics.drawLine(this._gutterBounds.width - 1, clipRect.y, this._gutterBounds.width - 1, clipRect.y + clipRect.height - 1);
        }
        graphics.setColor(fgColor);
        int startRow = this.getClosestRowFromCoordinate(clipRect.y);
        int endRow = this.getClosestRowFromCoordinate(clipRect.y + clipRect.height);
        int gutterDigits = Math.max(LineGutterPlugin.numDigits(this._lineCount), 3);
        int gutterWidth = this._gutterSize.width - 4;
        int gutterDigitsWidth = gutterDigits * this._fontWidth;
        int digitsStart = this._location == 4 ? 1 : gutterWidth - gutterDigitsWidth + 1;
        List<Column.Mark> marksToPaintList = LineGutterPlugin.allocateScratchList();
        char[] numberChars = new char[gutterDigits];
        int lastLine = 1;
        LineGutterPlugin.setNumber(numberChars, lastLine);
        if (this._editor == null) {
            return;
        }
        boolean useAAText = this._editor.getBooleanProperty("editor-antialiasing");
        Graphics2D graphics2d = useAAText && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object oldAATextValue = null;
        if (graphics2d != null) {
            oldAATextValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        try {
            int i = startRow;
            while (i <= endRow) {
                int line = this.getLineFromRow(i);
                this.getVisibleMarks(marksToPaintList, line);
                int rowStart = (i - 1) * this._fontHeight + topPadding;
                boolean iconPainted = false;
                int lastColumnStart = this.getWidth() - 3;
                int numMarks = marksToPaintList.size();
                int m = numMarks - 1;
                while (m >= 0) {
                    Column.Mark mark = marksToPaintList.get(m);
                    Icon icon = mark.getIcon();
                    int columnWidth = this.markWidth(mark);
                    int columnStart = lastColumnStart - columnWidth;
                    int iconWidth = icon.getIconWidth();
                    int iconHeight = icon.getIconHeight();
                    int iconX = columnStart + (columnWidth - iconWidth >> 1);
                    int iconY = rowStart + (this._fontHeight - iconHeight >> 1);
                    icon.paintIcon(this, graphics, iconX, iconY);
                    iconPainted = true;
                    if (mark == this._mouseInMark) {
                        this.paintRollover(graphics, mark, columnStart, columnWidth, rowStart);
                    }
                    lastColumnStart = columnStart - 2;
                    --m;
                }
                if (!iconPainted && this._showLineNumbers) {
                    if (line == lastLine + 1) {
                        LineGutterPlugin.incrementNumber(numberChars);
                    } else {
                        LineGutterPlugin.setNumber(numberChars, line);
                    }
                    int digits = LineGutterPlugin.numDigits(numberChars);
                    int numSpaces = numberChars.length - digits;
                    int lineY = rowStart + this._fontAscent;
                    int lineX = digitsStart;
                    if (this._location == 2) {
                        lineX += numSpaces * this._fontWidth;
                    }
                    graphics.drawChars(numberChars, numSpaces, digits, lineX, lineY);
                }
                ++i;
            }
        }
        catch (ExpiredTextBufferException etb) {
            // empty catch block
        }
        if (graphics2d != null && oldAATextValue != null) {
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAATextValue);
        }
        LineGutterPlugin.freeScratchList(marksToPaintList);
    }

    public Rectangle getRolloverRectFor(GutterMark markToFind) {
        int line = markToFind.getLine();
        int row = this.getRowFromLine(line);
        int startY = (row - 1) * this._fontHeight + this.getTopPadding();
        List<Column.Mark> marksOnLineList = LineGutterPlugin.allocateScratchList();
        try {
            this.getVisibleMarks(marksOnLineList, line);
            Collections.sort(marksOnLineList, MARK_COMPARATOR);
            int lastColumnStart = this.getWidth() - 3;
            int numMarks = marksOnLineList.size();
            int i = numMarks - 1;
            while (i >= 0) {
                Column.Mark mark = marksOnLineList.get(i);
                int columnWidth = this.markWidth(mark);
                int columnStart = lastColumnStart - columnWidth;
                if (mark == markToFind) {
                    Rectangle rectangle = this.calculateRolloverBounds(new Rectangle(), columnStart, columnWidth, startY);
                    return rectangle;
                }
                lastColumnStart = columnStart - 2;
                --i;
            }
            Rectangle rectangle = null;
            return rectangle;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            LineGutterPlugin.freeScratchList(marksOnLineList);
        }
    }

    private List getVisibleMarks(List<Column.Mark> visibleMarksOnLine, int line) {
        this.temporaryMarksOnLine.clear();
        this.getMarksOnLine(this.temporaryMarksOnLine, line);
        Collections.sort(this.temporaryMarksOnLine, MARK_COMPARATOR);
        List<Column.Mark> marks = this.temporaryMarksOnLine;
        int first = 0;
        int last = this.temporaryMarksOnLine.size();
        return this.filterVisibleMarks(marks, first, last, visibleMarksOnLine);
    }

    private List filterVisibleMarks(List<Column.Mark> marks, int first, int last, List<Column.Mark> visibleMarksOnLine) {
        List<String> overlaidColumns = this.temporaryOverlaidColumns;
        overlaidColumns.clear();
        visibleMarksOnLine.clear();
        int i = first;
        while (i < last) {
            Column column = (Column)marks.get(i).getGutterColumn();
            int constraint = column.getLayoutConstraint();
            String name = column.getLayoutColumn();
            if (constraint == 2 && name != null) {
                overlaidColumns.add(name);
            }
            ++i;
        }
        int i2 = first;
        while (i2 < last) {
            GutterColumn column;
            Column.Mark mark = marks.get(i2);
            if (mark.isVisible() && mark.getIcon() != null && overlaidColumns.indexOf((column = mark.getGutterColumn()).getColumnName()) < 0) {
                visibleMarksOnLine.add(mark);
            }
            ++i2;
        }
        return visibleMarksOnLine;
    }

    protected Rectangle calculateRolloverBounds(Rectangle bounds, int columnX, int columnWidth, int rowY) {
        bounds.x = columnX - 2;
        bounds.y = rowY;
        bounds.width = columnWidth + 3;
        bounds.height = this._fontHeight - 1;
        return bounds;
    }

    protected int markWidth(GutterMark mark) {
        if (!mark.isVisible()) {
            return 0;
        }
        Icon icon = mark.getIcon();
        if (icon == null) {
            return 0;
        }
        return Math.min(icon.getIconWidth(), 24);
    }

    protected int reservedColumnWidth(GutterColumn column) {
        int width;
        if (column instanceof Column && (width = ((Column)column).getReservedWidth()) > 0) {
            return Math.min(width, 24);
        }
        return 0;
    }

    protected Rectangle paintRollover(Graphics graphics, GutterMark mark, int columnX, int columnWidth, int rowY) {
        Column column = (Column)mark.getGutterColumn();
        if (column.getMarkSupportsClicks(mark)) {
            this.calculateRolloverBounds(this._rolloverBounds, columnX, columnWidth, rowY);
            Color oldColor = graphics.getColor();
            graphics.setColor(this._borderColor);
            graphics.drawRect(this._rolloverBounds.x, this._rolloverBounds.y, this._rolloverBounds.width, this._rolloverBounds.height);
            graphics.setColor(oldColor);
            return this._rolloverBounds;
        }
        return null;
    }

    protected static void setNumber(char[] numberChars, int number) {
        int numberWidth = numberChars.length;
        int i = 0;
        while (i < numberWidth) {
            numberChars[i] = 32;
            ++i;
        }
        String numberStr = Integer.toString(number);
        char[] numberStrChars = numberStr.toCharArray();
        int numberStrLen = numberStrChars.length;
        int startOffset = numberWidth - numberStrLen;
        System.arraycopy(numberStrChars, 0, numberChars, startOffset, numberStrLen);
    }

    protected static void incrementNumber(char[] number) {
        int numberWidth = number.length;
        int carry = 1;
        int i = numberWidth - 1;
        while (i >= 0) {
            char c = number[i];
            int digit = c == ' ' ? 0 : c - 48;
            carry = 0;
            if ((digit += carry) > 9) {
                carry = 1;
                digit -= 10;
            }
            number[i] = (char)(digit + 48);
            if (carry == 0) break;
            --i;
        }
    }

    protected static int numDigits(char[] number) {
        int numberWidth;
        int numDigits = numberWidth = number.length;
        int i = 0;
        while (i < numberWidth) {
            if (number[i] != ' ') break;
            --numDigits;
            ++i;
        }
        return numDigits;
    }

    protected int recalculateLineWidths() {
        if (this._showLineNumbers) {
            this._minimumDigits = Math.max(this._minimumDigits, LineGutterPlugin.numDigits(this._lineCount));
            int width = 4 + this._fontWidth * this._minimumDigits;
            return width;
        }
        return 3 + this._fontWidth + 1;
    }

    protected int getRowCount() {
        Insets insets = this._editor.getInsets();
        int insetHeight = insets.top + insets.bottom;
        int editorHeight = this._editor.getPreferredSize().height;
        int numberRows = (editorHeight - insetHeight) / this._fontHeight;
        int blankLines = this._editor.getIntegerProperty("trailing-blank-rows");
        return numberRows - blankLines;
    }

    protected int getLineFromRow(int row) {
        return this._editor.getLineFromRow(row - 1) + 1;
    }

    protected int getRowFromLine(int line) {
        return this._editor.getRowForLine(line - 1) + 1;
    }

    protected int getRowFromCoordinate(int y) {
        int topPadding = this.getTopPadding();
        int adjustedY = y - topPadding;
        if (adjustedY < 0) {
            return -1;
        }
        int row = adjustedY / this._fontHeight + 1;
        if (row <= this._rowCount) {
            return row;
        }
        return -1;
    }

    protected int getClosestRowFromCoordinate(int y) {
        int topPadding = this.getTopPadding();
        int adjustedY = y - topPadding;
        adjustedY = Math.max(0, adjustedY);
        int row = adjustedY / this._fontHeight + 1;
        row = Math.min(row, this._rowCount);
        return row;
    }

    protected int getTopPadding() {
        Insets myInsets = this.getInsets();
        if (this._editor == null) {
            return myInsets.top;
        }
        Insets editorInsets = this._editor.getInsets();
        return editorInsets.top - myInsets.top;
    }

    protected int getLeftPadding() {
        Insets myInsets = this.getInsets();
        return 1 - myInsets.left;
    }

    public static int numDigits(int number) {
        if (number < 10) {
            return 1;
        }
        if (number < 100) {
            return 2;
        }
        if (number < 1000) {
            return 3;
        }
        int digits = 0;
        do {
            ++digits;
        } while ((number /= 10) != 0);
        return digits;
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.linesChanged();
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        if (this._inReload) {
            return;
        }
        1 runnable = new 1(this, event);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        if (this._inReload) {
            return;
        }
        2 runnable = new 2(this, event);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        switch (attribute) {
            case 3: {
                this._inReload = true;
                break;
            }
            case 4: {
                this._inReload = false;
                3 runnable = new 3(this, attribute);
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                SwingUtilities.invokeLater(runnable);
                break;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int dragRow;
        int pressedRow;
        if (this._pressedY == -1) {
            return;
        }
        int dragY = event.getY();
        if (!this._selectStarted) {
            int diff = Math.abs(dragY - this._pressedY);
            if (diff < 4) {
                return;
            }
            this._selectStarted = true;
        }
        boolean forward = (pressedRow = this.getClosestRowFromCoordinate(this._pressedY) - 1) <= (dragRow = this.getClosestRowFromCoordinate(dragY) - 1);
        int startRow = Math.min(pressedRow, dragRow);
        int endRow = Math.max(pressedRow, dragRow);
        Insets insets = this._editor.getInsets();
        int yStart = startRow * this._fontHeight + insets.top;
        int yEnd = (endRow + 1) * this._fontHeight + insets.top;
        int startOffset = this._editor.viewToModel(new Point(0, yStart));
        int endOffset = this._editor.viewToModel(new Point(0, yEnd));
        if (forward) {
            this._editor.setCaretPosition(startOffset);
            this._editor.moveCaretPosition(endOffset);
        } else {
            this._editor.setCaretPosition(endOffset);
            this._editor.moveCaretPosition(startOffset);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.updateMouseInMark(event);
    }

    protected boolean allowDragging() {
        boolean allowDragging = this._editor.getBooleanProperty("gutter-enable-selection");
        return allowDragging;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!this._editor.hasFocus()) {
            this._editor.requestFocus();
        }
        this._pressedY = -1;
        if (this.allowDragging()) {
            this._selectStarted = false;
            this._pressedY = Math.max(event.getY(), 0);
        } else {
            this.processMousePressed(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this._pressedY != -1 && !this._selectStarted) {
            this.processMousePressed(event);
            this._pressedY = -1;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.updateMouseInMark(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.updateMouseInMark(event);
    }

    protected void updateMouseInMark(MouseEvent event) {
        int id;
        int y;
        int x;
        if (event != null) {
            x = event.getX();
            y = event.getY();
            id = event.getID();
        } else {
            try {
                Point mousePosition = this.getMousePosition(true);
                if (mousePosition == null) {
                    return;
                }
                id = 503;
                x = mousePosition.x;
                y = mousePosition.y;
            }
            catch (NullPointerException npe) {
                return;
            }
        }
        GutterMark oldMouseInMark = this._mouseInMark;
        switch (id) {
            case 505: {
                this._mouseInGutter = false;
                this._mouseInMark = null;
                break;
            }
            case 504: {
                this._mouseInGutter = true;
                this._mouseInMark = null;
                break;
            }
            case 503: {
                break;
            }
        }
        GutterMark newMouseInMark = null;
        if (this._mouseInGutter) {
            newMouseInMark = this.getMarkAtLocation(y, x);
        }
        this._mouseInMark = newMouseInMark;
        if (oldMouseInMark != newMouseInMark) {
            if (oldMouseInMark != null) {
                this.repaintLine(oldMouseInMark.getLine(), 5);
            }
            if (newMouseInMark != null) {
                this.repaintLine(newMouseInMark.getLine(), 5);
            }
        }
    }

    public BasicEditorPane getEditor() {
        return this._editor;
    }

    public GutterMark getMarkAtLocation(int mouseY, int mouseX) {
        Column.Mark newMouseInMark = null;
        int mouseLine = this.getLineFromRow(this.getRowFromCoordinate(mouseY));
        if (mouseLine > 0) {
            List<Column.Mark> marksOnLineList = LineGutterPlugin.allocateScratchList();
            this.getVisibleMarks(marksOnLineList, mouseLine);
            int columnEnd = this.getWidth() - 3;
            int numMarks = marksOnLineList.size();
            int i = numMarks - 1;
            while (i >= 0) {
                Column.Mark mark = marksOnLineList.get(i);
                int columnWidth = this.markWidth(mark);
                int columnStart = columnEnd - columnWidth;
                if (columnStart <= mouseX && mouseX <= columnEnd) {
                    newMouseInMark = mark;
                    break;
                }
                columnEnd = columnStart - 2;
                --i;
            }
            LineGutterPlugin.freeScratchList(marksOnLineList);
        }
        return newMouseInMark;
    }

    protected void processMousePressed(MouseEvent event) {
        this.updateMouseInMark(event);
        int x = event.getX();
        if (x > this.getWidth() - 3 || x <= 1) {
            return;
        }
        int line = this.getLineFromRow(this.getRowFromCoordinate(event.getY()));
        this.processMousePressed(event, line, this._mouseInMark);
        this.updateMouseInMark(event);
    }

    protected void processMousePressed(MouseEvent event, int line, GutterMark mark) {
        if (mark != null) {
            Column column = (Column)mark.getGutterColumn();
            if (column.getMarkSupportsClicks(mark)) {
                column.fireMarkClicked(event, mark, line);
            }
        } else {
            for (GutterClickListener listener : this._clickListeners) {
                try {
                    listener.lineClicked(this, line, event);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
    }

    static {
        $assertionsDisabled = LineGutterPlugin.class.desiredAssertionStatus() ^ true;
        LOG = new Log("gutter");
        _scratchList = null;
        MARK_COMPARATOR = new MarkComparator();
    }

    @Override
    public GutterColumn createGutterColumn(String columnName, GutterColumnListener listener) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        GutterColumn existingColumn = this.lookupGutterColumn(columnName);
        if (existingColumn != null) {
            return null;
        }
        LOG.trace("creating column {0} in {1}", (Object)columnName, (Object)this);
        Column column = this.createGutterColumnImpl(columnName, listener);
        this._columnsList.add(column);
        this.columnsChanged();
        return column;
    }

    protected Column createGutterColumnImpl(String columnName, GutterColumnListener listener) {
        return new Column(columnName, listener);
    }

    @Override
    public GutterColumn lookupGutterColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        int numColumns = this._columnsList.size();
        int i = numColumns - 1;
        while (i >= 0) {
            Column column = this._columnsList.get(i);
            if (column.getColumnName().equals(columnName)) {
                return column;
            }
            --i;
        }
        return null;
    }

    @Override
    public void removeGutterColumn(GutterColumn column) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this._columnsList.contains(column)) {
            LOG.trace("removing column {0} from {1}", (Object)column, (Object)this);
            column.removeAllGutterMarks();
            this._columnsList.remove(column);
            this.columnsChanged();
        }
    }

    @Override
    public void removeAllGutterColumns() {
        try {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            LOG.trace("removing all columns in {0}", (Object)this);
            int numColumns = this._columnsList.size();
            int i = numColumns - 1;
            while (i >= 0) {
                Column column = this._columnsList.get(i);
                column.removeAllGutterMarksImpl();
                --i;
            }
            this._columnsList.clear();
            this.columnsChanged();
        }
        catch (ExpiredTextBufferException e) {
            // empty catch block
        }
    }

    protected void updateAllMarkHighlights() {
        this._document.readLock();
        try {
            int numColumns = this._columnsList.size();
            int i = numColumns - 1;
            while (i >= 0) {
                Column column = this._columnsList.get(i);
                column.updateAllMarkHighlights();
                --i;
            }
        }
        finally {
            this._document.readUnlock();
        }
    }

    protected int recalculateColumnWidths() {
        if (this._preferredWidth < 0) {
            LOG.trace("recalculating preferred width");
            int columnCount = this._columnsList.size();
            if (this._reservedColumnWidth < 0) {
                int i = 0;
                while (i < columnCount) {
                    Column column = this._columnsList.get(i);
                    column.group = null;
                    column.groupIndex = -1;
                    ++i;
                }
                ArrayList<ArrayList<Column>> groups = new ArrayList<ArrayList<Column>>(columnCount);
                int i2 = 0;
                while (i2 < columnCount) {
                    Column column = this._columnsList.get(i2);
                    Column mergedColumn = (Column)this.lookupGutterColumn(column.getLayoutColumn());
                    if (mergedColumn == null) {
                        if (column.group == null) {
                            ArrayList<Column> group = new ArrayList<Column>();
                            group.add(column);
                            column.group = group;
                            groups.add(group);
                        }
                    } else if (column.group == null && mergedColumn.group == null) {
                        ArrayList<Column> group = new ArrayList<Column>();
                        group.add(column);
                        group.add(mergedColumn);
                        column.group = mergedColumn.group = group;
                        groups.add(group);
                    } else if (column.group == null) {
                        List<Column> group = mergedColumn.group;
                        group.add(column);
                        column.group = group;
                    } else if (mergedColumn.group == null) {
                        List<Column> group = column.group;
                        group.add(column);
                        mergedColumn.group = group;
                    } else if (column.group != mergedColumn.group) {
                        List<Column> group = mergedColumn.group;
                        List<Column> absorbedGroup = column.group;
                        int j = 0;
                        while (j < absorbedGroup.size()) {
                            Column c = absorbedGroup.get(j);
                            group.add(c);
                            c.group = group;
                            ++j;
                        }
                        groups.remove(absorbedGroup);
                    }
                    if (!$assertionsDisabled && column.group != null && column.group.size() != new HashSet<Column>(column.group).size()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && mergedColumn != null && mergedColumn.group != null && mergedColumn.group.size() != new HashSet<Column>(mergedColumn.group).size()) {
                        throw new AssertionError();
                    }
                    ++i2;
                }
                int groupCount = groups.size();
                this._columnGroupWidths = new int[groupCount];
                this._columnGroupIsTiled = new boolean[groupCount];
                this._reservedColumnWidth = 0;
                int i3 = 0;
                while (i3 < groupCount) {
                    List group = (List)groups.get(i3);
                    int width = 0;
                    boolean isTiled = false;
                    int j = 0;
                    while (j < group.size()) {
                        Column c = (Column)group.get(j);
                        c.groupIndex = i3;
                        width = Math.max(width, this.reservedColumnWidth(c));
                        isTiled |= c.getLayoutConstraint() == 1;
                        ++j;
                    }
                    this._columnGroupWidths[i3] = width;
                    this._columnGroupIsTiled[i3] = isTiled;
                    if (width > 0) {
                        if (this._reservedColumnWidth > 0) {
                            this._reservedColumnWidth += 2;
                        }
                        this._reservedColumnWidth += width;
                    }
                    ++i3;
                }
                LOG.trace("recalculating column groups {0}, {1}, {2}", groups, (Object)this._columnGroupWidths, (Object)this._columnGroupIsTiled);
            }
            int maxMultiColumnWidth = this._reservedColumnWidth;
            List<Column.Mark> marksList = LineGutterPlugin.allocateScratchList();
            int i = 0;
            while (i < columnCount) {
                Column column = this._columnsList.get(i);
                column.getAllMarks(marksList);
                ++i;
            }
            int marksSize = marksList.size();
            if (marksSize > 0) {
                Collections.sort(marksList, MARK_COMPARATOR);
                int first = 0;
                int lastLine = marksList.get(0).getLine();
                ArrayList<Column.Mark> visibleMarks = new ArrayList<Column.Mark>();
                int[] reservedWidths = new int[this._columnGroupWidths.length];
                int i4 = 1;
                while (i4 <= marksSize) {
                    int line;
                    int n = line = i4 < marksSize ? ((GutterMark)marksList.get(i4)).getLine() : Integer.MAX_VALUE;
                    if (line != lastLine) {
                        this.filterVisibleMarks(marksList, first, i4, visibleMarks);
                        int multiColumnWidth = 0;
                        int singleColumnWidth = 0;
                        System.arraycopy(this._columnGroupWidths, 0, reservedWidths, 0, reservedWidths.length);
                        int j = 0;
                        while (j < visibleMarks.size()) {
                            Column.Mark mark = (Column.Mark)visibleMarks.get(j);
                            int markWidth = this.markWidth(mark);
                            Column column = (Column)mark.getGutterColumn();
                            int index = column.groupIndex;
                            int columnWidth = reservedWidths[index];
                            if (markWidth < columnWidth) {
                                markWidth = columnWidth;
                            }
                            reservedWidths[index] = 0;
                            if (multiColumnWidth > 0) {
                                multiColumnWidth += 2;
                            }
                            multiColumnWidth += markWidth;
                            singleColumnWidth = Math.max(singleColumnWidth, markWidth);
                            ++j;
                        }
                        int j2 = 0;
                        while (j2 < reservedWidths.length) {
                            int width = reservedWidths[j2];
                            if (width > 0) {
                                if (multiColumnWidth > 0) {
                                    multiColumnWidth += 2;
                                }
                                multiColumnWidth += width;
                            }
                            ++j2;
                        }
                        maxMultiColumnWidth = Math.max(maxMultiColumnWidth, multiColumnWidth);
                        lastLine = line;
                        first = i4;
                    }
                    ++i4;
                }
            }
            this._preferredWidth = 1 + maxMultiColumnWidth + 3;
            LineGutterPlugin.freeScratchList(marksList);
        }
        return this._preferredWidth;
    }

    @Override
    public void addGutterClickListener(GutterClickListener listener) {
        this._clickListeners.addIfAbsent(listener);
    }

    @Override
    public void removeGutterClickListener(GutterClickListener listener) {
        this._clickListeners.remove(listener);
    }

    @Override
    public String toString() {
        return "Gutter#" + System.identityHashCode(this);
    }

    static int[] ra$_columnGroupWidths(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._columnGroupWidths;
    }

    static void mav$columnMarksRemoved(LineGutterPlugin lineGutterPlugin, Column column) {
        lineGutterPlugin.columnMarksRemoved(column);
    }

    static Log ra$LOG() {
        return LOG;
    }

    static void mav$markChanged(LineGutterPlugin lineGutterPlugin, GutterMark gutterMark, int n, int n2) {
        lineGutterPlugin.markChanged(gutterMark, n, n2);
    }

    static BasicDocument ra$_document(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._document;
    }

    static void mav$marksChanged(LineGutterPlugin lineGutterPlugin) {
        lineGutterPlugin.marksChanged();
    }

    static int ra$_lineCount(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._lineCount;
    }

    static void mav$columnsChanged(LineGutterPlugin lineGutterPlugin) {
        lineGutterPlugin.columnsChanged();
    }

    static BasicEditorPane ra$_editor(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._editor;
    }

    static HighlightLayer ra$_highlightLayer(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._highlightLayer;
    }

    static void wa$_lineCount(LineGutterPlugin lineGutterPlugin, int n) {
        lineGutterPlugin._lineCount = n;
    }

    static List ra$_columnsList(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._columnsList;
    }

    static void mav$linesChanged(LineGutterPlugin lineGutterPlugin) {
        lineGutterPlugin.linesChanged();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ DocumentEvent v$event;
        final /* synthetic */ LineGutterPlugin this$0;

        public void run() {
            int numColumns = LineGutterPlugin.ra$_columnsList(this.this$0).size();
            int i = numColumns - 1;
            while (i >= 0) {
                Column column = (Column)LineGutterPlugin.ra$_columnsList(this.this$0).get(i);
                column.insertUpdate(this.v$event);
                --i;
            }
            LineMap lineMap = LineGutterPlugin.ra$_document(this.this$0).getLineMap();
            LineGutterPlugin.wa$_lineCount(this.this$0, lineMap.getLineCount());
            LineGutterPlugin.mav$linesChanged(this.this$0);
        }

        public 1(LineGutterPlugin lineGutterPlugin, DocumentEvent documentEvent) {
            this.v$event = documentEvent;
            this.this$0 = lineGutterPlugin;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ DocumentEvent v$event;
        final /* synthetic */ LineGutterPlugin this$0;

        public void run() {
            int numColumns = LineGutterPlugin.ra$_columnsList(this.this$0).size();
            int i = numColumns - 1;
            while (i >= 0) {
                Column column = (Column)LineGutterPlugin.ra$_columnsList(this.this$0).get(i);
                column.removeUpdate(this.v$event);
                --i;
            }
            LineMap lineMap = LineGutterPlugin.ra$_document(this.this$0).getLineMap();
            LineGutterPlugin.wa$_lineCount(this.this$0, lineMap.getLineCount());
            LineGutterPlugin.mav$linesChanged(this.this$0);
        }

        public 2(LineGutterPlugin lineGutterPlugin, DocumentEvent documentEvent) {
            this.v$event = documentEvent;
            this.this$0 = lineGutterPlugin;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ int v$attribute;
        final /* synthetic */ LineGutterPlugin this$0;

        public void run() {
            LineMap lineMap = LineGutterPlugin.ra$_document(this.this$0).getLineMap();
            LineGutterPlugin.wa$_lineCount(this.this$0, lineMap.getLineCount());
            int numColumns = LineGutterPlugin.ra$_columnsList(this.this$0).size();
            int i = numColumns - 1;
            while (i >= 0) {
                Column column = (Column)LineGutterPlugin.ra$_columnsList(this.this$0).get(i);
                column.attributeUpdate(this.v$attribute);
                --i;
            }
            LineGutterPlugin.mav$linesChanged(this.this$0);
        }

        public 3(LineGutterPlugin lineGutterPlugin, int n) {
            this.v$attribute = n;
            this.this$0 = lineGutterPlugin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Column
    implements GutterColumn {
        protected String _columnName;
        protected GutterColumnListener _columnListener;
        protected int _reservedWidth;
        protected String _layoutColumn;
        protected int _layoutConstraint;
        protected List<Mark> _marksList;
        private volatile boolean _inBlockUpdate;
        protected List<Column> group;
        protected int groupIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Column(String columnName, GutterColumnListener columnListener) {
            this.$init$();
            this._columnName = columnName;
            this._columnListener = columnListener;
            this._marksList = new ArrayList<Mark>(10);
        }

        private void $init$() {
            this._layoutConstraint = 0;
        }

        @Override
        public void setReservedWidth(int width) {
            if (width != this._reservedWidth) {
                this._reservedWidth = width;
                LineGutterPlugin.mav$columnsChanged(LineGutterPlugin.this);
            }
        }

        protected int getReservedWidth() {
            return this._reservedWidth;
        }

        @Override
        public void setLayoutConstraint(String columnName, int constraint) {
            if (constraint == 0) {
                columnName = null;
            } else {
                if (columnName == null) {
                    throw new IllegalArgumentException("columnName null");
                }
                if (columnName.equals(this._columnName)) {
                    throw new IllegalArgumentException("columnName circular");
                }
            }
            if (columnName == null ? this._layoutColumn != null : !columnName.equals(this._layoutColumn) || constraint != this._layoutConstraint) {
                this._layoutColumn = columnName;
                this._layoutConstraint = constraint;
                LineGutterPlugin.mav$columnsChanged(LineGutterPlugin.this);
            }
        }

        protected String getLayoutColumn() {
            return this._layoutColumn;
        }

        protected int getLayoutConstraint() {
            return this._layoutConstraint;
        }

        protected void updateAllMarkHighlights() {
            LineGutterPlugin.ra$_document(LineGutterPlugin.this).readLock();
            try {
                LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
                int numMarks = this._marksList.size();
                int i = 0;
                while (i < numMarks) {
                    Mark mark = this._marksList.get(i);
                    mark.updateHighlight(lineMap);
                    ++i;
                }
            }
            finally {
                LineGutterPlugin.ra$_document(LineGutterPlugin.this).readUnlock();
            }
        }

        static {
            $assertionsDisabled = Column.class.desiredAssertionStatus() ^ true;
        }

        protected void discardAllGutterMarks() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            int numMarks = this._marksList.size();
            int i = numMarks - 1;
            while (i >= 0) {
                Mark mark = this._marksList.get(i);
                mark.removeHighlight();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                try {
                    int oldLine = mark.getLine();
                    if (!mark.isOptionSet(2)) {
                        this._columnListener.markRemoved(mark, oldLine);
                    }
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                --i;
            }
            this._marksList.clear();
            LineGutterPlugin.ra$LOG().trace("revalidating after discarding all marks in column {0}", (Object)this);
            LineGutterPlugin.mav$columnMarksRemoved(LineGutterPlugin.this, this);
        }

        protected int getMarkCount() {
            return this._marksList.size();
        }

        protected void getAllMarks(Collection<Mark> collection) {
            collection.addAll(this._marksList);
        }

        protected void getMarks(Collection<Mark> collection, int line) {
            int numMarks = this._marksList.size();
            int i = 0;
            while (i < numMarks) {
                Mark mark = this._marksList.get(i);
                if (mark.getLine() == line) {
                    collection.add(mark);
                }
                ++i;
            }
        }

        protected int removeAllGutterMarksImpl() {
            int numMarks = this._marksList.size();
            int i = numMarks - 1;
            while (i >= 0) {
                Mark mark = this._marksList.get(i);
                mark.removeHighlight();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                --i;
            }
            this._marksList.clear();
            return numMarks;
        }

        protected boolean getMarkSupportsClicks(GutterMark gutterMark) {
            Mark mark = (Mark)gutterMark;
            return mark.isOptionSet(1);
        }

        public String getMarkToolTip(GutterMark mark, MouseEvent event) {
            return this._columnListener.getMarkToolTip(mark, event);
        }

        protected void fireMarkClicked(MouseEvent event, GutterMark mark, int line) {
            try {
                this._columnListener.markClicked(mark, mark.getLine(), event);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }

        protected void insertUpdate(DocumentEvent event) {
            LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
            int insertOffset = event.getOffset();
            int linesAdded = lineMap.getLineCount() - LineGutterPlugin.ra$_lineCount(LineGutterPlugin.this);
            ArrayList<Mark> movedList = new ArrayList<Mark>();
            for (Mark mark : this._marksList) {
                int markOffset = mark.getOffset();
                if (insertOffset > markOffset || mark.isOptionSet(2)) continue;
                int oldMarkLine = mark.getLine();
                if (linesAdded == 0) {
                    markOffset = lineMap.getLineStartOffset(oldMarkLine - 1);
                    mark.setOffset(markOffset);
                    continue;
                }
                int newMarkLine = oldMarkLine + linesAdded;
                markOffset = lineMap.getLineStartOffset(newMarkLine - 1);
                mark.setOffset(markOffset);
                mark.setLine(newMarkLine);
                movedList.add(mark);
            }
            for (Mark mark : movedList) {
                int newMarkLine = mark.getLine();
                int oldMarkLine = newMarkLine - linesAdded;
                Mark.mav$moveMarkInFileOverviewMargin(mark, oldMarkLine);
                try {
                    this._columnListener.markMoved(mark, oldMarkLine, newMarkLine);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            this.updateAllMarkHighlights();
        }

        public void removeUpdate(DocumentEvent event) {
            LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
            int removeOffset = event.getOffset();
            int removeLength = event.getLength();
            int removeLine = lineMap.getLineFromOffset(removeOffset);
            int removeLineStart = lineMap.getLineStartOffset(removeLine);
            int linesRemoved = LineGutterPlugin.ra$_lineCount(LineGutterPlugin.this) - lineMap.getLineCount();
            ArrayList<Mark> movedList = new ArrayList<Mark>();
            ArrayList<Mark> removedList = new ArrayList<Mark>();
            Iterator<Mark> i = this._marksList.iterator();
            while (i.hasNext()) {
                Mark mark = i.next();
                int markOffset = mark.getOffset();
                if (removeOffset > markOffset || mark.isOptionSet(2)) continue;
                int oldMarkLine = mark.getLine();
                if (linesRemoved == 0) {
                    markOffset = lineMap.getLineStartOffset(oldMarkLine - 1);
                    mark.setOffset(markOffset);
                    continue;
                }
                boolean removeMark = false;
                if (removeOffset <= markOffset && removeOffset + removeLength > markOffset) {
                    removeMark = true;
                } else if (removeOffset + removeLength == markOffset && removeOffset != removeLineStart) {
                    removeMark = true;
                }
                if (removeMark) {
                    i.remove();
                    removedList.add(mark);
                    mark.removeHighlight();
                    continue;
                }
                int newMarkLine = oldMarkLine - linesRemoved;
                int newMarkOffset = lineMap.getLineStartOffset(newMarkLine - 1);
                mark.setOffset(newMarkOffset);
                mark.setLine(newMarkLine);
                movedList.add(mark);
            }
            for (Mark mark : movedList) {
                int newMarkLine = mark.getLine();
                int oldMarkLine = newMarkLine + linesRemoved;
                Mark.mav$moveMarkInFileOverviewMargin(mark, oldMarkLine);
                try {
                    this._columnListener.markMoved(mark, oldMarkLine, newMarkLine);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            for (Mark mark : removedList) {
                int oldMarkLine = mark.getLine();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                try {
                    this._columnListener.markRemoved(mark, oldMarkLine);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            this.updateAllMarkHighlights();
        }

        public void attributeUpdate(int attribute) {
            if (attribute == 4) {
                LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
                ArrayList<Mark> removedList = new ArrayList<Mark>();
                Iterator<Mark> i = this._marksList.iterator();
                while (i.hasNext()) {
                    Mark mark = i.next();
                    if (mark.isOptionSet(2)) continue;
                    int oldLine = mark.getLine() - 1;
                    if (oldLine < LineGutterPlugin.ra$_lineCount(LineGutterPlugin.this)) {
                        int markOffset = lineMap.getLineStartOffset(oldLine);
                        mark.setOffset(markOffset);
                        continue;
                    }
                    removedList.add(mark);
                    i.remove();
                    mark.removeHighlight();
                }
                for (Mark mark : removedList) {
                    Mark.mav$removeMarkInFileOverviewMargin(mark);
                    int oldMarkLine = mark.getLine();
                    try {
                        this._columnListener.markRemoved(mark, oldMarkLine);
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                this.updateAllMarkHighlights();
            }
        }

        @Override
        public Gutter getGutter() {
            return LineGutterPlugin.this;
        }

        @Override
        public String getColumnName() {
            return this._columnName;
        }

        @Override
        public void beginBlockAdd() {
            LineGutterPlugin.ra$_document(LineGutterPlugin.this).readLock();
            if (this._inBlockUpdate) {
                throw new IllegalStateException("block add already active");
            }
            this._inBlockUpdate = true;
        }

        @Override
        public void endBlockAdd() {
            if (!this._inBlockUpdate) {
                throw new IllegalStateException("block add not active");
            }
            this._inBlockUpdate = false;
            LineGutterPlugin.ra$_document(LineGutterPlugin.this).readUnlock();
            LineGutterPlugin.mav$marksChanged(LineGutterPlugin.this);
        }

        @Override
        public GutterMark addGutterMark(int line, Icon icon, HighlightStyle highlightStyle, int markOrder, int markOptions) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            Mark mark = null;
            boolean alreadyLocked = this._inBlockUpdate;
            if (!alreadyLocked) {
                LineGutterPlugin.ra$_document(LineGutterPlugin.this).readLock();
            }
            try {
                LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
                int lineCount = lineMap.getLineCount();
                int adjustedLine = line - 1;
                if (adjustedLine >= 0 && adjustedLine < lineCount) {
                    int startOffset = lineMap.getLineStartOffset(adjustedLine);
                    mark = new Mark(line, startOffset, icon, highlightStyle, markOrder, markOptions);
                    mark.updateHighlight(lineMap);
                    this._marksList.add(mark);
                    int width = LineGutterPlugin.this.markWidth(mark);
                    if (!this._inBlockUpdate) {
                        LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, mark, 0, width);
                    }
                    LineGutterPlugin.ra$LOG().trace("adding mark of width {0} to column {1} in {2}", width, (Object)this, (Object)LineGutterPlugin.this);
                }
            }
            finally {
                if (!alreadyLocked) {
                    LineGutterPlugin.ra$_document(LineGutterPlugin.this).readUnlock();
                }
            }
            return mark;
        }

        @Override
        public GutterMark[] lookupGutterMarks(int line) {
            ArrayList<Mark> markList = new ArrayList<Mark>();
            this.getMarks(markList, line);
            int numMarks = markList.size();
            GutterMark[] markResults = new GutterMark[numMarks];
            return markList.toArray(markResults);
        }

        @Override
        public void removeGutterMark(GutterMark mark) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            int existingIndex = this._marksList.indexOf(mark);
            if (existingIndex != -1) {
                int oldWidth = LineGutterPlugin.this.markWidth(mark);
                this._marksList.remove(existingIndex);
                Mark m = (Mark)mark;
                m.removeHighlight();
                Mark.mav$removeMarkInFileOverviewMargin(m);
                if (!this._inBlockUpdate) {
                    LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, mark, oldWidth, 0);
                }
            }
        }

        @Override
        public void removeAllGutterMarks() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            int marksRemoved = this.removeAllGutterMarksImpl();
            if (marksRemoved > 0) {
                LineGutterPlugin.mav$columnMarksRemoved(LineGutterPlugin.this, this);
                LineGutterPlugin.ra$LOG().trace("revalidating after removing all marks in column {0}", (Object)this);
            }
        }

        public String toString() {
            String width = "?";
            if (this.groupIndex >= 0 && LineGutterPlugin.ra$_columnGroupWidths(LineGutterPlugin.this) != null && LineGutterPlugin.ra$_columnGroupWidths(LineGutterPlugin.this).length < this.groupIndex) {
                width = String.valueOf(LineGutterPlugin.ra$_columnGroupWidths(LineGutterPlugin.this)[this.groupIndex]);
            }
            return "column " + this._columnName + "{group " + this.group + ", width " + width + "}";
        }

        static boolean ra$_inBlockUpdate(Column column) {
            return column._inBlockUpdate;
        }

        public class Mark
        implements GutterMark,
        FileOverviewMark {
            private int _line;
            private int _lineStart;
            private Icon _icon;
            private HighlightStyle _style;
            private HighlightedText _highlight;
            private int _order;
            private int _options;
            private boolean _visible;
            private Object _userData;

            protected Mark(int line, int lineStart, Icon icon, HighlightStyle highlightStyle, int markOrder, int markOptions) {
                this._line = line;
                this._lineStart = lineStart;
                this._icon = icon;
                this._style = highlightStyle;
                this._order = markOrder;
                this._options = markOptions;
                this._highlight = null;
                this._visible = true;
                this._userData = null;
                this.createMarkInFileOverviewMargin();
            }

            protected void updateHighlight(LineMap lineMap) {
                if (this._style != null) {
                    if (this._highlight == null) {
                        this._highlight = LineGutterPlugin.ra$_highlightLayer(LineGutterPlugin.this).addLineHighlight(this._style, this._line - 1);
                    } else {
                        int lineStart = lineMap.getLineStartOffset(this._line - 1);
                        int lineEnd = lineMap.getLineEndOffset(this._line - 1);
                        if (this._highlight.getStartOffset() != lineStart || this._highlight.getEndOffset() != lineEnd) {
                            LineGutterPlugin.ra$_highlightLayer(LineGutterPlugin.this).changeHighlight(this._highlight, lineStart, lineEnd);
                        }
                    }
                }
            }

            protected void removeHighlight() {
                if (this._highlight != null) {
                    LineGutterPlugin.ra$_highlightLayer(LineGutterPlugin.this).removeHighlight(this._highlight);
                    this._highlight = null;
                }
                if (LineGutterPlugin.this._mouseInMark == this) {
                    LineGutterPlugin.this._mouseInMark = null;
                }
            }

            protected void setLine(int newLine) {
                this._line = newLine;
            }

            protected int getOffset() {
                return this._lineStart;
            }

            protected void setOffset(int offset) {
                this._lineStart = offset;
            }

            public boolean isOptionSet(int optionFlag) {
                return (this._options & optionFlag) != 0;
            }

            protected int getOptions() {
                return this._options;
            }

            public GutterColumn getGutterColumn() {
                return Column.this;
            }

            public Gutter getGutter() {
                return Column.this.getGutter();
            }

            public Icon getIcon() {
                return this._icon;
            }

            public void setIcon(Icon icon) {
                int oldWidth = LineGutterPlugin.this.markWidth(this);
                this._icon = icon;
                if (!Column.ra$_inBlockUpdate(Column.this)) {
                    LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, this, oldWidth, LineGutterPlugin.this.markWidth(this));
                }
            }

            public HighlightStyle getHighlightStyle() {
                return this._style;
            }

            public int getLine() {
                return this._line;
            }

            public int getOrder() {
                return this._order;
            }

            public void setVisible(boolean visible) {
                int oldWidth = LineGutterPlugin.this.markWidth(this);
                this._visible = visible;
                if (!Column.ra$_inBlockUpdate(Column.this)) {
                    LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, this, oldWidth, LineGutterPlugin.this.markWidth(this));
                }
            }

            public boolean isVisible() {
                return this._visible;
            }

            public Object getUserData() {
                return this._userData;
            }

            public void setUserData(Object userData) {
                this._userData = userData;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return Column.this.getMarkToolTip(this, mouseEvent);
            }

            public int getSelectionStart() {
                return this.getOffset();
            }

            public int getSelectionLength() {
                return 0;
            }

            public int getSeverity() {
                return 0;
            }

            private void createMarkInFileOverviewMargin() {
                FileOverviewMargin fileOverviewMargin;
                if (this.isOptionSet(4) && (fileOverviewMargin = FileOverviewMargin.getFileOverviewMargin(LineGutterPlugin.ra$_editor(LineGutterPlugin.this))) != null) {
                    fileOverviewMargin.addMark(Column.this._columnName, this._line, this);
                }
            }

            private void moveMarkInFileOverviewMargin(int oldMarkLine) {
                FileOverviewMargin fileOverviewMargin;
                if (this.isOptionSet(4) && (fileOverviewMargin = FileOverviewMargin.getFileOverviewMargin(LineGutterPlugin.ra$_editor(LineGutterPlugin.this))) != null) {
                    fileOverviewMargin.removeMark(Column.this._columnName, oldMarkLine, this);
                    fileOverviewMargin.addMark(Column.this._columnName, this._line, this);
                }
            }

            private void removeMarkInFileOverviewMargin() {
                FileOverviewMargin fileOverviewMargin;
                if (this.isOptionSet(4) && (fileOverviewMargin = FileOverviewMargin.getFileOverviewMargin(LineGutterPlugin.ra$_editor(LineGutterPlugin.this))) != null) {
                    fileOverviewMargin.removeMark(Column.this._columnName, this._line, this);
                }
            }

            static void mav$removeMarkInFileOverviewMargin(Mark mark) {
                mark.removeMarkInFileOverviewMargin();
            }

            static void mav$moveMarkInFileOverviewMargin(Mark mark, int n) {
                mark.moveMarkInFileOverviewMargin(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class MarkComparator
    implements Comparator<GutterMark> {
        @Override
        public int compare(GutterMark m1, GutterMark m2) {
            int comparison = m1.getLine() - m2.getLine();
            if (comparison == 0) {
                comparison = m1.getOrder() - m2.getOrder();
            }
            return comparison;
        }

        protected MarkComparator() {
        }
    }
}

