/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.editor.folding.FoldingBlock;

public abstract class AbstractFoldingBlock
implements FoldingBlock {
    private FoldingBlock parent;
    private List children;
    private boolean isExpanded;

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public FoldingBlock getParent() {
        return this.parent;
    }

    public void setParent(FoldingBlock parent) {
        this.parent = parent;
    }

    public void add(FoldingBlock child) {
        FoldingBlock oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
    }

    public void remove(FoldingBlock child) {
        if (this.children != null && this.children.remove(child)) {
            child.setParent(null);
        }
    }

    public void removeAll() {
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            FoldingBlock child = (FoldingBlock)it.next();
            child.setParent(null);
        }
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public Iterator getChildren() {
        return this.children != null ? this.children.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public int length() {
        int endOffset = this.getEndOffset();
        int startOffset = this.getStartOffset();
        return Math.abs(endOffset - startOffset);
    }

    public boolean bounds(int offset) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        return offset > startOffset && offset < endOffset;
    }

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public abstract String getReplacementText();
}

