/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.event.DocumentEvent;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.plugins.AbstractEditorPlugin;

public abstract class AbstractCodeFoldingPlugin
extends AbstractEditorPlugin {
    private CodeFoldingProvider provider;
    private CodeFoldingMargin margin;
    private BasicDocument.PrePostDocumentListener documentHandler;

    protected void installImpl(BasicEditorPane editorPane) {
        if (this.isMarginEnabled()) {
            this.attach(editorPane);
        }
    }

    protected void deinstallImpl(BasicEditorPane editorPane) {
        if (this.margin.isVisible()) {
            this.detach(editorPane);
        }
        this.provider = null;
        this.margin = null;
    }

    protected void propertyChangeImpl(PropertyChangeEvent e) {
        CodeFoldingMargin margin = this.getMargin();
        if (margin == null) {
            return;
        }
        String propertyName = e.getPropertyName();
        if (propertyName.equals("editor-font") || propertyName.equals("trailing-blank-rows") || propertyName.equals("code-folding-highlight") || propertyName.equals("code-folding-enabled")) {
            margin.repaint();
        } else if (propertyName.equals("right-margin-color")) {
            Color fg = (Color)e.getNewValue();
            margin.setForeground(fg);
        } else if (propertyName.equals("code-folding-margin-visible")) {
            BasicEditorPane editorPane = (BasicEditorPane)e.getSource();
            Boolean visibleValue = (Boolean)e.getNewValue();
            boolean isVisible = visibleValue;
            if (isVisible) {
                this.attach(editorPane);
            } else {
                this.detach(editorPane);
            }
            margin.setVisible(isVisible);
        }
    }

    protected abstract CodeFoldingProvider createProvider();

    protected void attach(BasicEditorPane editorPane) {
        CodeFoldingMargin margin = this.getMargin();
        margin.attach(editorPane);
        this.documentHandler = this.createPrePostDocumentListener();
        if (this.documentHandler != null) {
            BasicDocument document = (BasicDocument)editorPane.getDocument();
            document.addPrePostDocumentListener(this.documentHandler);
        }
    }

    protected void detach(BasicEditorPane editorPane) {
        if (this.documentHandler != null) {
            BasicDocument document = (BasicDocument)editorPane.getDocument();
            document.removePrePostDocumentListener(this.documentHandler);
            this.documentHandler = null;
        }
        CodeFoldingMargin margin = this.getMargin();
        margin.detach(editorPane);
    }

    protected boolean isMarginEnabled() {
        EditorProperties properties = EditorProperties.getProperties();
        return properties.getBooleanProperty("code-folding-margin-visible");
    }

    protected CodeFoldingModel getModel() {
        CodeFoldingMargin margin = this.getMargin();
        return margin.getModel();
    }

    protected void setModel(CodeFoldingModel model) {
        CodeFoldingMargin margin = this.getMargin();
        margin.setModel(model);
    }

    protected CodeFoldingProvider getProvider() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    protected CodeFoldingMargin getMargin() {
        if (this.margin == null) {
            this.margin = this.createMargin();
        }
        return this.margin;
    }

    protected CodeFoldingMargin createMargin() {
        CodeFoldingProvider provider = this.getProvider();
        return new CodeFoldingMargin(provider);
    }

    protected BasicDocument.PrePostDocumentListener createPrePostDocumentListener() {
        return new DocumentHandler();
    }

    protected class DocumentHandler
    implements BasicDocument.PrePostDocumentListener {
        protected DocumentHandler() {
        }

        protected boolean isInsertOrRemoveEvent(DocumentEvent event) {
            DocumentEvent.EventType type = event.getType();
            return type == DocumentEvent.EventType.INSERT || type == DocumentEvent.EventType.REMOVE;
        }

        public void preNotify(DocumentEvent event) {
            boolean isInsert;
            if (!this.isInsertOrRemoveEvent(event)) {
                return;
            }
            CodeFoldingProvider provider = AbstractCodeFoldingPlugin.this.getProvider();
            CodeFoldingModel model = AbstractCodeFoldingPlugin.this.getModel();
            int offset = event.getOffset();
            int length = event.getLength();
            boolean bl = isInsert = event.getType() == DocumentEvent.EventType.INSERT;
            if (isInsert) {
                provider.insertUpdate(model, offset, length);
            } else {
                provider.removeUpdate(model, offset, length);
            }
        }

        public void postNotify(DocumentEvent event) {
            CodeFoldingMargin margin = AbstractCodeFoldingPlugin.this.getMargin();
            margin.repaint();
        }
    }
}

