/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class WeakPropertyChangeSupport {
    private transient List viewListeners;
    private transient Object source;

    public WeakPropertyChangeSupport(Object source) {
        this.source = source;
        this.viewListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        List list = this.viewListeners;
        synchronized (list) {
            int index = this.findListener(listener);
            if (index == -1) {
                WeakReference<PropertyChangeListener> reference = new WeakReference<PropertyChangeListener>(listener);
                this.viewListeners.add(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        List list = this.viewListeners;
        synchronized (list) {
            int index = this.findListener(listener);
            if (index != -1) {
                this.viewListeners.set(index, null);
            }
        }
    }

    public synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.valuesMatch(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        this.fireEvent(event);
    }

    public synchronized void firePropertyChange(PropertyChangeEvent event) {
        if (this.valuesMatch(event.getOldValue(), event.getNewValue())) {
            return;
        }
        this.fireEvent(event);
    }

    private int findListener(PropertyChangeListener listener) {
        int numListeners = this.viewListeners.size();
        int i = 0;
        while (i < numListeners) {
            Object referent;
            WeakReference reference = (WeakReference)this.viewListeners.get(i);
            if (reference != null && (referent = reference.get()) == listener) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void packListeners() {
        Iterator iterator = this.viewListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference reference = (WeakReference)iterator.next();
            if (reference != null && reference.get() != null) continue;
            iterator.remove();
        }
    }

    private boolean valuesMatch(Object first, Object second) {
        return first == second || first != null && second != null && first.equals(second);
    }

    private void fireEvent(PropertyChangeEvent event) {
        for (WeakReference reference : this.viewListeners) {
            PropertyChangeListener listener;
            if (reference == null || (listener = (PropertyChangeListener)reference.get()) == null) continue;
            try {
                listener.propertyChange(event);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.packListeners();
    }
}

