/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;

public final class EditorSelectionWrap
implements EditorSelection,
ActionHookInvoker {
    private BasicEditorPane _editor;
    private HighlightedText _highlightedText;

    public int getSelectionStart() {
        Caret caret = this._editor.getCaret();
        return Math.min(caret.getDot(), caret.getMark());
    }

    public int getSelectionEnd() {
        Caret caret = this._editor.getCaret();
        return Math.max(caret.getDot(), caret.getMark());
    }

    public String getSelectedText() {
        int p1;
        String txt = null;
        int p0 = this.getSelectionStart();
        if (p0 != (p1 = this.getSelectionEnd())) {
            try {
                Document doc = this._editor.getDocument();
                txt = doc.getText(p0, p1 - p0);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return txt;
    }

    public void duplicateSelection() {
        Toolkit toolkit = this._editor.getToolkit();
        this._editor.makeEditable();
        if (this._editor.isEditable() && this._editor.isEnabled()) {
            BasicDocument document = (BasicDocument)this._editor.getDocument();
            try {
                int start = this.getSelectionStart();
                int end = this.getSelectionEnd();
                if (start == end && this._editor.isCutCopyLineEnabled()) {
                    int offset = this._editor.getCaretPosition();
                    LineMap lineMap = document.getLineMap();
                    int currentLine = lineMap.getLineFromOffset(offset);
                    start = lineMap.getLineStartOffset(currentLine);
                    end = lineMap.getLineEndOffset(currentLine);
                }
                if (start != end) {
                    String data = document.getText(start, end - start);
                    this._editor.beginEdit(BasicEditorPane.duplicateDescriptor);
                    document.insertString(end, data, null);
                    int length = end - start;
                    this._editor.select(end, end + length);
                    this._editor.endEdit();
                }
            }
            catch (BadLocationException e) {}
        } else {
            toolkit.beep();
        }
    }

    public void updateSelectionHighlight(HighlightLayer layer, HighlightStyle caretStyle) {
        int end;
        if (this._editor == null) {
            this.clearSelectionHighlights(layer);
            return;
        }
        int start = this.getSelectionStart();
        if (start == (end = this.getSelectionEnd()) && layer != null) {
            this.clearSelectionHighlights(layer);
        }
        if (start != end) {
            if (this._highlightedText != null) {
                layer.changeHighlight(this._highlightedText, caretStyle, start, end);
            } else {
                this._highlightedText = layer.addHighlight(caretStyle, start, end);
            }
        }
    }

    public void install(BasicEditorPane editor) {
        if (this._editor == null) {
            this._editor = editor;
            this._editor.addActionHookInvoker(this);
        }
    }

    public void deinstall() {
        if (this._editor != null) {
            this._editor.removeActionHookInvoker(this);
        }
        this._editor = null;
    }

    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("duplicate-selection")) {
            this.duplicateSelection();
            return true;
        }
        return false;
    }

    public void setStartSelectionPoint(Point p) {
    }

    public void setEndSelectionPoint(Point p) {
    }

    public void clearSelectionHighlights(HighlightLayer selectionLayer) {
        selectionLayer.removeHighlight(this._highlightedText);
        this._highlightedText = null;
    }

    public void deleteSelection() throws BadLocationException {
        int selectStart = this._editor.getSelectionStart();
        int selectEnd = this._editor.getSelectionEnd();
        Document document = this._editor.getDocument();
        document.remove(selectStart, selectEnd - selectStart);
    }

    public void insertText(int offset, String text) throws BadLocationException {
        this._editor.getDocument().insertString(offset, text, null);
    }

    public boolean isInSelection(int offset) {
        int selectStart = this._editor.getSelectionStart();
        int selectEnd = this._editor.getSelectionEnd();
        boolean inSelection = selectStart <= offset && offset <= selectEnd;
        return inSelection;
    }

    public void selectAll() {
    }

    public boolean canSupportEditor(BasicEditorPane editorPane) {
        return true;
    }
}

