/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorSelectionColumns
implements EditorSelection,
ActionHookInvoker {
    private BasicEditorPane _editor;
    private Point _startPoint;
    private Point _endPoint;
    private int _startColumn;
    private int _endColumn;
    private int _startLine;
    private int _endLine;
    private HighlightedText[] _highlightedTextRows;

    private void $init$() {
        this._startColumn = -1;
        this._endColumn = -1;
        this._startLine = -1;
        this._endLine = -1;
        this._highlightedTextRows = new HighlightedText[0];
    }

    @Override
    public int getSelectionStart() {
        Caret caret = this._editor.getCaret();
        return Math.min(caret.getDot(), caret.getMark());
    }

    @Override
    public int getSelectionEnd() {
        Caret caret = this._editor.getCaret();
        return Math.max(caret.getDot(), caret.getMark());
    }

    @Override
    public String getSelectedText() {
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        StringBuffer data = new StringBuffer();
        if (this._startColumn == this._endColumn) {
            return null;
        }
        try {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (start != end) {
                int startLine = this._editor.getLineFromOffset(start);
                int endLine = this._editor.getLineFromOffset(end);
                int lines = endLine - startLine + 1;
                int line = startLine;
                while (line < startLine + lines) {
                    Pair<Integer, Integer> offsets = this._getSelectedLineOffsets(line);
                    if (offsets != null && (Integer)offsets.second > (Integer)offsets.first) {
                        data.append(document.getText((Integer)offsets.first, (Integer)offsets.second - (Integer)offsets.first));
                    }
                    data.append("\n");
                    ++line;
                }
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return data.toString();
    }

    public void copy() {
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        document.readLock();
        try {
            String data;
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (start != end && (data = this.getSelectedText()) != null) {
                this._editor.setClipboardContents(data.toString());
            }
        }
        finally {
            document.readUnlock();
        }
    }

    public void cut() {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        int start = this.getSelectionStart();
        this.copy();
        this._editor.beginEdit(BasicEditorPane.cutDescriptor);
        try {
            this.delete();
        }
        catch (BadLocationException e) {
            this._editor.getToolkit().beep();
        }
        this._editor.setCaretPosition(start);
        this._editor.endEdit();
    }

    public void delete() throws BadLocationException {
        int end;
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        int start = this.getSelectionStart();
        if (start == (end = this.getSelectionEnd()) && this._editor.isCutCopyLineEnabled()) {
            int offset = this._editor.getCaretPosition();
            LineMap lineMap = document.getLineMap();
            int currentLine = lineMap.getLineFromOffset(offset);
            start = lineMap.getLineStartOffset(currentLine);
            end = lineMap.getLineEndOffset(currentLine);
        }
        if (start != end) {
            int startLine = this._editor.getLineFromOffset(start);
            int endLine = this._editor.getLineFromOffset(end);
            int lines = endLine - startLine + 1;
            this._editor.beginEdit(BasicEditorPane.deletePrevDescriptor);
            try {
                int line = startLine + lines - 1;
                while (line >= startLine) {
                    Pair<Integer, Integer> offsets = this._getSelectedLineOffsets(line);
                    if (offsets != null) {
                        document.remove((Integer)offsets.first, (Integer)offsets.second - (Integer)offsets.first);
                    }
                    --line;
                }
            }
            finally {
                this._editor.endEdit();
            }
            this._editor.setCaretPosition(start);
        }
    }

    public void paste() {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int startLine = this._editor.getLineFromOffset(start);
        int startColumn = start - this._editor.getLineStartOffset(startLine);
        this._editor.beginEdit(BasicEditorPane.pasteDescriptor);
        try {
            try {
                BasicDocument document = (BasicDocument)this._editor.getDocument();
                if (start != end) {
                    int endLine = this._editor.getLineFromOffset(end);
                    int lines = endLine - startLine + 1;
                    int line = startLine;
                    while (line < startLine + lines) {
                        Pair<Integer, Integer> offsets = this._getSelectedLineOffsets(line);
                        if (offsets != null) {
                            document.remove((Integer)offsets.first, (Integer)offsets.second - (Integer)offsets.first);
                        }
                        ++line;
                    }
                }
                end = this.pasteFromClipboard(startLine, startColumn);
                this._editor.setCaretPosition(start);
            }
            catch (BadLocationException e) {
                this._editor.getToolkit().beep();
            }
        }
        finally {
            this._editor.endEdit();
        }
    }

    private int pasteFromClipboard(int insertAtLine, int startColumn) {
        Transferable transferable;
        Toolkit toolkit = this._editor.getToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        if (clipboard != null && this._editor.isEditable() && this._editor.isEnabled() && (transferable = clipboard.getContents(this)) != null) {
            try {
                Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                String stringData = (String)data;
                int n = this._insertText(insertAtLine, startColumn, stringData);
                return n;
            }
            catch (Exception e) {
                toolkit.beep();
            }
        }
        return -1;
    }

    private int _insertText(int insertAtLine, int startColumn, String stringData) throws IOException, BadLocationException {
        int finalOffset = this._editor.getLineStartOffset(insertAtLine) + startColumn;
        if (stringData != null && stringData.length() > 0) {
            String[] lines = stringData.split("\n");
            int linesToAdd = insertAtLine + lines.length - this._editor.getLineCount();
            StringBuffer addition = new StringBuffer();
            int addLine = 0;
            while (addLine < linesToAdd) {
                addition.append("\n");
                ++addLine;
            }
            if (addition.length() > 0) {
                int lastOffset = this._editor.getDocument().getLength();
                this._editor.getDocument().insertString(lastOffset, addition.toString(), null);
            }
            int n = 0;
            while (n < lines.length) {
                int line = insertAtLine + n;
                int lineStart = this._editor.getLineStartOffset(line);
                int lineEnd = this._editor.getLineEndOffset(line);
                if (line == this._editor.getLineCount() - 1) {
                    ++lineEnd;
                }
                String lineString = lines[n];
                int offset = lineStart + startColumn;
                if (offset >= lineEnd) {
                    int i = 0;
                    while (i <= offset - lineEnd) {
                        lineString = " " + lineString;
                        ++i;
                    }
                    offset = lineEnd - 1;
                }
                offset = Math.min(offset, this._editor.getDocument().getLength());
                offset = Math.max(offset, 0);
                this._editor.getDocument().insertString(offset, lineString, null);
                finalOffset = offset + lineString.length();
                ++n;
            }
        }
        return finalOffset;
    }

    private int getLineEndOffset(int line) {
        int lineEnd = this._editor.getLineEndOffset(line);
        if (line != this._editor.getLineCount() - 1) {
            --lineEnd;
        }
        return lineEnd;
    }

    private Pair<Integer, Integer> _getSelectedLineOffsets(int line) {
        if (this._startColumn == -1 || this._endColumn == -1) {
            return null;
        }
        int lineStart = this._editor.getLineStartOffset(line);
        int lineEnd = this.getLineEndOffset(line);
        int startOffset = Math.min(lineEnd, lineStart + this._startColumn);
        int endOffset = Math.min(lineEnd, lineStart + this._endColumn);
        return new Pair<Integer, Integer>(startOffset, endOffset);
    }

    @Override
    public void updateSelectionHighlight(HighlightLayer layer, HighlightStyle caretStyle) {
        int end;
        if (this._editor == null) {
            this.clearSelectionHighlights(layer);
            return;
        }
        int start = this.getSelectionStart();
        if (start == (end = this.getSelectionEnd()) && layer != null) {
            this.clearSelectionHighlights(layer);
        }
        if (start != end) {
            layer.beginBlockUpdate();
            try {
                int startLine = this._editor.getLineFromOffset(start);
                int endLine = this._editor.getLineFromOffset(end);
                int lines = endLine - startLine + 1;
                int charWidth = this._editor.getFontMetrics(this._editor.getFont()).charWidth('T');
                int startColumn = this._startPoint.x / charWidth;
                int endColumn = this._endPoint.x / charWidth;
                if (endColumn < startColumn) {
                    int temp = startColumn;
                    startColumn = endColumn;
                    endColumn = temp;
                }
                if (startColumn == this._startColumn && endColumn == this._endColumn && startLine == this._startLine && endLine == this._endLine) {
                    return;
                }
                this.clearSelectionHighlights(layer);
                this._startColumn = startColumn;
                this._endColumn = endColumn;
                this._startLine = startLine;
                this._endLine = endLine;
                this._highlightedTextRows = new HighlightedText[lines];
                if (startColumn == endColumn) {
                    return;
                }
                int i = 0;
                while (i < lines) {
                    int startLineOffset = this._editor.getLineStartOffset(startLine + i);
                    int endLineOffset = this.getLineEndOffset(startLine + i);
                    int startOffset = Math.min(endLineOffset, startLineOffset + startColumn);
                    int endOffset = Math.min(endLineOffset, startLineOffset + endColumn);
                    this._highlightedTextRows[i] = layer.addHighlight(caretStyle, startOffset, endOffset);
                    ++i;
                }
            }
            finally {
                layer.endBlockUpdate();
            }
        }
    }

    @Override
    public void install(BasicEditorPane editor) {
        if (this._editor == null) {
            this._editor = editor;
            this._editor.addActionHookInvoker(this);
        }
    }

    @Override
    public void deinstall() {
        if (this._editor != null) {
            this._editor.removeActionHookInvoker(this);
        }
        this._editor = null;
    }

    @Override
    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("cut-to-clipboard")) {
            this.cut();
            return true;
        }
        if (actionKey.equals("copy-to-clipboard")) {
            this.copy();
            return true;
        }
        if (actionKey.equals("paste-from-clipboard")) {
            this.paste();
            return true;
        }
        if (actionKey.equals("duplicate-selection")) {
            return true;
        }
        if (actionKey.equals("delete-next") || actionKey.equals("delete-previous")) {
            if (!this._editor.hasSelection()) {
                return false;
            }
            try {
                this.delete();
            }
            catch (BadLocationException e) {
                this._editor.getToolkit().beep();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setStartSelectionPoint(Point p) {
        this._startPoint = (Point)p.clone();
        this._startPoint.x = Math.max(0, this._startPoint.x);
        this._startPoint.x = Math.min(this._editor.getWidth(), this._startPoint.x);
        this._startPoint.y = Math.max(0, this._startPoint.y);
        this._startPoint.y = Math.min(this._editor.getHeight(), this._startPoint.y);
    }

    @Override
    public void setEndSelectionPoint(Point p) {
        this._endPoint = (Point)p.clone();
        this._endPoint.x = Math.max(0, this._endPoint.x);
        this._endPoint.x = Math.min(this._editor.getWidth(), this._endPoint.x);
        this._endPoint.y = Math.max(0, this._endPoint.y);
        this._endPoint.y = Math.min(this._editor.getHeight(), this._endPoint.y);
    }

    @Override
    public void clearSelectionHighlights(HighlightLayer selectionLayer) {
        selectionLayer.removeAllHighlights();
        this._highlightedTextRows = new HighlightedText[0];
        this._startColumn = -1;
        this._endColumn = -1;
        this._startLine = -1;
        this._endLine = -1;
    }

    @Override
    public void deleteSelection() throws BadLocationException {
        this.delete();
    }

    @Override
    public void insertText(int offset, String text) throws BadLocationException {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        int startLine = this._editor.getLineFromOffset(offset);
        int column = offset - this._editor.getLineStartOffset(startLine);
        try {
            this._insertText(startLine, column, text);
        }
        catch (IOException e) {
            this._editor.getToolkit().beep();
        }
    }

    @Override
    public boolean isInSelection(int offset) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        int selStartLine = this._editor.getLineFromOffset(this.getSelectionStart());
        int selEndLine = this._editor.getLineFromOffset(this.getSelectionEnd());
        int thisLine = this._editor.getLineFromOffset(offset);
        if (thisLine < selStartLine || thisLine > selEndLine) {
            return false;
        }
        Pair<Integer, Integer> lineOffsets = this._getSelectedLineOffsets(thisLine);
        if (lineOffsets == null) {
            return false;
        }
        return offset >= (Integer)lineOffsets.first && offset <= (Integer)lineOffsets.second;
    }

    @Override
    public void selectAll() {
        this._startPoint = new Point(0, 0);
        this._endPoint = new Point(this._editor.getSize().width, this._editor.getSize().height);
    }

    @Override
    public boolean canSupportEditor(BasicEditorPane editorPane) {
        FontMetrics fm = editorPane.getFontMetrics(editorPane.getFont());
        return fm.charWidth('i') == fm.charWidth('W');
    }

    public static boolean isEditorFixedWidthFont(BasicEditorPane editorPane) {
        FontMetrics fm = editorPane.getFontMetrics(editorPane.getFont());
        return fm.charWidth('.') == fm.charWidth('W');
    }

    public EditorSelectionColumns() {
        this.$init$();
    }
}

