/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.Log;

public class BasicEditorUI
extends BasicEditorPaneUI {
    private static final Log LOG = new Log("expiration");

    public static ComponentUI createUI(JComponent component) {
        return new BasicEditorUI();
    }

    public void installUI(JComponent component) {
        JTextComponent editor;
        super.installUI(component);
        if (component instanceof JTextComponent && (editor = (JTextComponent)component) instanceof BasicEditorPane) {
            Color caretColor;
            BasicEditorPane editorPane = (BasicEditorPane)editor;
            boolean enableBlink = editorPane.getBooleanProperty("caret-enable-blink");
            int blinkRate = enableBlink ? editorPane.getIntegerProperty("caret-blink-rate") : 0;
            Caret caret = editorPane.getCaret();
            if (caret != null) {
                caret.setBlinkRate(blinkRate);
            }
            if ((caretColor = (Color)editorPane.getProperty("caret-color")) != null) {
                editor.setCaretColor(caretColor);
            } else {
                editor.setCaretColor(Color.black);
            }
        }
    }

    protected Caret createCaret() {
        BasicCaret caret = new BasicCaret();
        return caret;
    }

    protected void paintSafely(Graphics graphics) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        document.readLock();
        try {
            super.paintSafely(graphics);
        }
        finally {
            document.readUnlock();
        }
    }

    public Dimension getPreferredSize(JComponent component) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Dimension size = null;
        document.readLock();
        try {
            size = super.getPreferredSize(component);
        }
        finally {
            document.readUnlock();
        }
        return size;
    }

    public Dimension getMinimumSize(JComponent component) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Dimension size = null;
        document.readLock();
        try {
            size = super.getMinimumSize(component);
        }
        finally {
            document.readUnlock();
        }
        return size;
    }

    public Dimension getMaximumSize(JComponent component) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Dimension size = null;
        document.readLock();
        try {
            size = super.getMaximumSize(component);
        }
        finally {
            document.readUnlock();
        }
        return size;
    }

    public Rectangle modelToView(JTextComponent component, int offset, Position.Bias bias) throws BadLocationException {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        Rectangle locationRect = null;
        try {
            document.readLock();
            try {
                locationRect = super.modelToView(component, offset, bias);
            }
            finally {
                document.readUnlock();
            }
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in BasicEditoUI.modelToView: {0}", (Object)e);
            throw new BadLocationException(e.getMessage(), offset);
        }
        return locationRect;
    }

    public int viewToModel(JTextComponent component, Point point, Position.Bias[] biasReturn) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        int offset = -1;
        document.readLock();
        try {
            offset = super.viewToModel(component, point, biasReturn);
        }
        finally {
            document.readUnlock();
        }
        return offset;
    }

    public int getNextVisualPositionFrom(JTextComponent component, int offset, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        int nextOffset = offset;
        document.readLock();
        try {
            nextOffset = super.getNextVisualPositionFrom(component, offset, bias, direction, biasRet);
        }
        finally {
            document.readUnlock();
        }
        return nextOffset;
    }

    public void damageRange(JTextComponent component, int startOffset, int endOffset, Position.Bias startOffsetBias, Position.Bias endOffsetBias) {
        BasicEditorPane editorPane = (BasicEditorPane)this.getComponent();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        document.readLock();
        try {
            try {
                super.damageRange(component, startOffset, endOffset, startOffsetBias, endOffsetBias);
            }
            catch (NullPointerException e) {}
        }
        finally {
            document.readUnlock();
        }
    }
}

