/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.BasicWriteAction;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EmacsAction;
import oracle.javatools.editor.EmacsWriteAction;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.keys.KeyRecorder;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.resource.BundleHelper;

public class BasicEditorKit
extends DefaultEditorKit
implements ViewFactory {
    private static Action[] augmentedActions = null;
    private static ActionMap actionMap = null;
    private static final String MERGE_TYPED_INSERT = "merge-typed-insert";
    private static final String MERGE_TYPED_REPLACE = "merge-typed-replace";
    private static final String MERGE_DELETE_NEXT = "merge-delete-next";
    private static final String MERGE_DELETE_PREVIOUS = "merge-delete-previous";
    private static boolean MAC_OS_X = System.getProperty("os.name").indexOf("Mac OS X") != 1;

    public BasicEditorKit() {
        this.initializeActionMap();
    }

    public String getContentType() {
        return "text/plain";
    }

    public Object clone() {
        return new BasicEditorKit();
    }

    public Caret createCaret() {
        return new BasicCaret();
    }

    public Document createDefaultDocument() {
        return new BasicDocument();
    }

    public final ViewFactory getViewFactory() {
        return this;
    }

    public View create(Element elem) {
        return new BasicView(elem);
    }

    public Action[] getActions() {
        return augmentedActions;
    }

    private void initializeActionMap() {
        if (actionMap == null) {
            Action[] builtInActions = new Action[]{new CutAction(), new CopyAction(), new PasteAction(), new ExtendedPasteAction(), new NOPAction("cancel"), new NOPAction("completion-insight"), new NOPAction("smart-completion-insight"), new NOPAction("tooltip-insight"), new BlockIndentOutdentAction("block-indent", true), new BlockIndentOutdentAction("block-outdent", false), new ConvertSelectionCaseAction("upcase-selection", true), new ConvertSelectionCaseAction("downcase-selection", false), new DefaultKeyTypedAction(), new DeleteLineAction(), new DeleteNextCharAction(), new DeletePrevCharAction(), new DeleteUntilEOLAction(), new DeleteNextWordAction("delete-next-word-start", 1), new DeleteNextWordAction("delete-next-word-end", 2), new DeleteNextWordAction("delete-next-word-break", 3), new DeletePreviousWordAction("delete-previous-word-start", 1), new DeletePreviousWordAction("delete-previous-word-end", 2), new DeletePreviousWordAction("delete-previous-word-break", 3), new InsertBreakAction(), new InsertTabAction(), new OpenLineAction(), new ReverseTabAction(), new SortSelectedLines(), new TabifyAction(), new ToggleCommentsAction(), new TransposeCharsAction(), new UntabifyAction(), new TrimWhitespaceAction(), new BeepAction(), new SetLocalTabSizeAction("set-local-tabsize-2", 2), new SetLocalTabSizeAction("set-local-tabsize-4", 4), new SetLocalTabSizeAction("set-local-tabsize-8", 8), new ReadOnlyAction(), new WritableAction(), new ToggleInsertModeAction(), new MacroRecorderAction("playback-macro", true), new MacroRecorderAction("toggle-macro-recording", false), new GotoMatchingBraceAction("goto-matching-brace", false), new GotoMatchingBraceAction("selection-matching-brace", true), new NOPAction("show-matching-brace"), new PageUpAction("page-up", false), new PageUpAction("selection-page-up", true), new PageDownAction("page-down", false), new PageDownAction("selection-page-down", true), new ForwardAction("caret-forward", false), new ForwardAction("selection-forward", true), new BackwardAction("caret-backward", false), new BackwardAction("selection-backward", true), new UpAction("caret-up", false), new UpAction("selection-up", true), new DownAction("caret-down", false), new DownAction("selection-down", true), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("caret-end-word", false), new EndWordAction("selection-end-word", true), new PreviousWordAction("caret-previous-word-start", 1, false), new PreviousWordAction("caret-previous-word-end", 2, false), new PreviousWordAction("caret-previous-word-break", 3, false), new PreviousWordAction("selection-previous-word-start", 1, true), new PreviousWordAction("selection-previous-word-end", 2, true), new PreviousWordAction("selection-previous-word-break", 3, true), new NextWordAction("caret-next-word-start", 1, false), new NextWordAction("caret-next-word-end", 2, false), new NextWordAction("caret-next-word-break", 3, false), new NextWordAction("selection-next-word-start", 1, true), new NextWordAction("selection-next-word-end", 2, true), new NextWordAction("selection-next-word-break", 3, true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new EndAction("caret-end", false), new EndAction("selection-end", true), new SelectWordAction(), new SelectLineAction(), new SelectAllAction(), new UnselectAction(), new RecenterLineAction(), new ScrollLineUpAction(), new ScrollLineDownAction(), new ScrollPageUpAction(), new ScrollPageDownAction(), new EmacsSetMarkAction(), new EmacsExchangePointMarkAction(), new EmacsBeginAction(), new EmacsEndAction(), new EmacsMarkBufferAction(), new EmacsKillWordAction(), new EmacsBackwardKillWordAction(), new EmacsKillLineAction(), new EmacsKillRegionAction("emacs-kill-region", false), new EmacsKillRegionAction("emacs-kill-ring-save", true), new EmacsAppendNextKillAction(), new EmacsYankAction("emacs-yank", true), new EmacsYankAction("emacs-yank-pop", false), new EmacsCapitalizeWordAction(), new EmacsDowncaseWordAction(), new EmacsUpcaseWordAction(), new EmacsCaseRegionAction("emacs-upcase-region", true), new EmacsCaseRegionAction("emacs-downcase-region", false), new EmacsDeleteHorizontalSpaceAction()};
            Action[] combinedActions = TextAction.augmentList(super.getActions(), builtInActions);
            actionMap = new ActionMap();
            int listSize = combinedActions.length;
            int i = 0;
            while (i < listSize) {
                Action action = combinedActions[i];
                String actionName = (String)action.getValue("Name");
                actionMap.put(actionName, action);
                ++i;
            }
            ArrayList<Action> list = new ArrayList<Action>();
            list.add(actionMap.get("default-typed"));
            listSize = list.size();
            augmentedActions = new Action[listSize];
            int i2 = 0;
            while (i2 < listSize) {
                BasicEditorKit.augmentedActions[i2] = (Action)list.get(i2);
                ++i2;
            }
        }
    }

    public Action findAction(String actionKey) {
        return actionMap.get(actionKey);
    }

    static boolean ra$MAC_OS_X() {
        return MAC_OS_X;
    }

    public static class CutAction
    extends BasicWriteAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            CutAction.makeEditable(editor);
            editor.cut();
        }
    }

    public static class CopyAction
    extends BasicWriteAction {
        public CopyAction() {
            super("copy-to-clipboard");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.copy();
        }
    }

    public static class PasteAction
    extends BasicWriteAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            PasteAction.makeEditable(editor);
            editor.paste();
        }
    }

    public static class ExtendedPasteAction
    extends BasicWriteAction {
        public ExtendedPasteAction() {
            super("extended-paste-from-clipboard");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            if (ClipboardStack.adjustCurrentClipboard()) {
                ExtendedPasteAction.makeEditable(editor);
                editor.paste();
            }
        }
    }

    public static class NOPAction
    extends BasicAction {
        public NOPAction(String actionName) {
            super(actionName);
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
        }
    }

    public static class BlockIndentOutdentAction
    extends BasicWriteAction {
        private boolean doIndent;
        private static EditDescriptor indentDescriptor;
        private static EditDescriptor outdentDescriptor;

        protected boolean shouldPerformBlockOperation(BasicEditorPane editor) {
            int selectEnd;
            int selectStart = editor.getSelectionStart();
            if (selectStart != (selectEnd = editor.getSelectionEnd())) {
                Boolean doBlockBool = (Boolean)editor.getProperty("do-block-indents-on-selection");
                boolean doBlockIndents = doBlockBool;
                return doBlockIndents;
            }
            return false;
        }

        public BlockIndentOutdentAction(String actionName, boolean doIndent) {
            super(actionName);
            this.doIndent = doIndent;
            if (indentDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String indentName = resources.getString("UNDO_BLOCK_INDENT");
                indentDescriptor = new EditDescriptor(indentName);
                String outdentName = resources.getString("UNDO_BLOCK_OUTDENT");
                outdentDescriptor = new EditDescriptor(outdentName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            BlockIndentOutdentAction.makeEditable(editor);
            if (!BlockIndentOutdentAction.isEditable(editor, true)) {
                return;
            }
            TextBuffer textBuffer = document.getTextBuffer();
            LineMap lineMap = document.getLineMap();
            int startOffset = editor.getSelectionStart();
            int endOffset = editor.getSelectionEnd();
            boolean forwardSelection = editor.getCaretPosition() == endOffset;
            int startLine = lineMap.getLineFromOffset(startOffset);
            int endLine = lineMap.getLineFromOffset(endOffset);
            if (startOffset != endOffset && endOffset == lineMap.getLineStartOffset(endLine)) {
                --endLine;
            }
            int indentSize = BlockIndentOutdentAction.getIndentSizeProperty(editor);
            int tabSize = BlockIndentOutdentAction.getTabSizeProperty(editor);
            boolean useTabs = BlockIndentOutdentAction.getUseTabsProperty(editor);
            int indentChange = this.doIndent ? indentSize : -indentSize;
            EditDescriptor editDescriptor = this.doIndent ? indentDescriptor : outdentDescriptor;
            editor.beginEdit(editDescriptor);
            try {
                Rectangle visibleRect = BlockIndentOutdentAction.getVisibleRect(editor);
                editor.setCaretPosition(0);
                int line = startLine;
                while (line <= endLine) {
                    int lineEnd;
                    int lineStart = lineMap.getLineStartOffset(line);
                    int offset = BlockIndentOutdentAction.skipLeadingIndent(textBuffer, lineStart, lineEnd = lineMap.getLineEndOffset(line));
                    if (offset == -1) {
                        offset = lineEnd == textBuffer.getLength() ? lineEnd : lineEnd - 1;
                    }
                    int currentIndentSize = Utilities.getColumnFromOffset(textBuffer, line, offset, tabSize);
                    int newIndentSize = Math.max(currentIndentSize + indentChange, 0);
                    String newIndent = BlockIndentOutdentAction.buildIndent(useTabs, tabSize, newIndentSize);
                    try {
                        document.remove(lineStart, offset - lineStart);
                        document.insertString(lineStart, newIndent, null);
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    ++line;
                }
                int blockStart = lineMap.getLineStartOffset(startLine);
                int blockEnd = lineMap.getLineEndOffset(endLine);
                if (forwardSelection) {
                    editor.setCaretPosition(blockStart);
                    editor.moveCaretPosition(blockEnd);
                } else {
                    editor.setCaretPosition(blockEnd);
                    editor.moveCaretPosition(blockStart);
                }
                if (visibleRect != null) {
                    editor.scrollRectToVisible(visibleRect);
                }
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class ConvertSelectionCaseAction
    extends BasicWriteAction {
        private boolean doUpcase;
        private static EditDescriptor upcaseDescriptor;
        private static EditDescriptor downcaseDescriptor;

        public ConvertSelectionCaseAction(String actionName, boolean doUpcase) {
            super(actionName);
            this.doUpcase = doUpcase;
            if (upcaseDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String upcaseName = resources.getString("UNDO_CONVERT_SELECTION_UPCASE");
                upcaseDescriptor = new EditDescriptor(upcaseName);
                String downcaseName = resources.getString("UNDO_CONVERT_SELECTION_DOWNCASE");
                downcaseDescriptor = new EditDescriptor(downcaseName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int endOffset;
            ConvertSelectionCaseAction.makeEditable(editor);
            if (!ConvertSelectionCaseAction.isEditable(editor, true)) {
                return;
            }
            TextBuffer textBuffer = document.getTextBuffer();
            int startOffset = editor.getSelectionStart();
            if (startOffset == (endOffset = editor.getSelectionEnd())) {
                return;
            }
            EditDescriptor editDescriptor = this.doUpcase ? upcaseDescriptor : downcaseDescriptor;
            editor.beginEdit(editDescriptor);
            try {
                int len = endOffset - startOffset;
                String selectionText = textBuffer.getString(startOffset, len);
                String replaceText = this.doUpcase ? selectionText.toUpperCase() : selectionText.toLowerCase();
                int caretPos = editor.getCaretPosition();
                boolean caretAtStart = caretPos == startOffset;
                try {
                    document.remove(startOffset, len);
                    document.insertString(startOffset, replaceText, null);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                if (caretAtStart) {
                    editor.setCaretPosition(endOffset);
                    editor.moveCaretPosition(startOffset);
                } else {
                    editor.setCaretPosition(startOffset);
                    editor.moveCaretPosition(endOffset);
                }
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends BasicWriteAction {
        private static EditDescriptor insertDescriptor;
        private static EditDescriptor replaceDescriptor;
        private static EditDescriptor smartDescriptor;
        private static final TextAction originalKeyTypedAction;

        public DefaultKeyTypedAction() {
            super("default-typed");
            if (insertDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String insertName = resources.getString("UNDO_TYPED_INSERT");
                insertDescriptor = new EditDescriptor(insertName, BasicEditorKit.MERGE_TYPED_INSERT);
                String replaceName = resources.getString("UNDO_TYPED_REPLACE");
                replaceDescriptor = new EditDescriptor(replaceName, BasicEditorKit.MERGE_TYPED_REPLACE);
                String smartName = resources.getString("UNDO_SMART_INDENT");
                smartDescriptor = new EditDescriptor(smartName);
            }
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent component = this.getTextComponent(event);
            if (component instanceof BasicEditorPane) {
                super.actionPerformed(event);
            } else {
                originalKeyTypedAction.actionPerformed(event);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int insertOffset;
            char c;
            block20: {
                String content = event.getActionCommand();
                int modifiers = event.getModifiers();
                if (content == null || content.length() == 0) {
                    return;
                }
                if (BasicEditorKit.ra$MAC_OS_X() ? (modifiers & 6) != 0 : (modifiers & 8) != (modifiers & 2)) {
                    return;
                }
                c = content.charAt(0);
                if (c < ' ' || c == '\u007f') {
                    return;
                }
                DefaultKeyTypedAction.makeEditable(editor);
                if (!DefaultKeyTypedAction.isEditable(editor, true)) {
                    return;
                }
                insertOffset = editor.getSelectionStart();
                int selectionEnd = editor.getSelectionEnd();
                try {
                    if (insertOffset != selectionEnd) {
                        editor.beginEdit(replaceDescriptor);
                        editor.replaceSelection(content);
                        editor.endEdit();
                        break block20;
                    }
                    boolean inReplaceMode = false;
                    Caret caret = editor.getCaret();
                    if (caret != null && caret instanceof BasicCaret) {
                        BasicCaret basicCaret = (BasicCaret)caret;
                        boolean inInsertMode = basicCaret.getInsertMode();
                        inReplaceMode = inInsertMode ^ true;
                    }
                    boolean doReplace = false;
                    if (inReplaceMode && insertOffset < document.getLength() && !document.getText(insertOffset, 1).equals("\n")) {
                        doReplace = true;
                    }
                    EditDescriptor editDescriptor = doReplace ? replaceDescriptor : insertDescriptor;
                    editor.beginEdit(editDescriptor);
                    try {
                        if (doReplace) {
                            document.remove(insertOffset, 1);
                        }
                        document.insertString(insertOffset, content, null);
                    }
                    finally {
                        editor.endEdit();
                    }
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException("Error while typing: " + e);
                }
            }
            SmartIndentProvider smartProvider = DefaultKeyTypedAction.getSmartIndentProvider(editor, document);
            if (smartProvider != null && smartProvider.isAutoReindentTriggerChar(c) && !this.caretInsideStyle("java-comment-style", document, insertOffset) && !this.caretInsideStyle("java-string-style", document, insertOffset)) {
                TextBuffer textBuffer = document.getTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int currentLine = lineMap.getLineFromOffset(insertOffset);
                int lineStart = lineMap.getLineStartOffset(currentLine);
                int lineEnd = lineMap.getLineEndOffset(currentLine);
                int indentSize = DefaultKeyTypedAction.getIndentSizeProperty(editor);
                int tabSize = DefaultKeyTypedAction.getTabSizeProperty(editor);
                boolean useTabs = DefaultKeyTypedAction.getUseTabsProperty(editor);
                int indentToUse = smartProvider.getIndentForLine(currentLine, indentSize);
                int endLeading = DefaultKeyTypedAction.skipLeadingIndent(textBuffer, lineStart, lineEnd);
                if (endLeading == -1) {
                    int lastLine = lineMap.getLineCount() - 1;
                    endLeading = currentLine == lastLine ? lineEnd : lineEnd - 1;
                }
                editor.beginEdit(smartDescriptor);
                try {
                    try {
                        String indent = DefaultKeyTypedAction.buildIndent(useTabs, tabSize, indentToUse);
                        document.remove(lineStart, endLeading - lineStart);
                        document.insertString(lineStart, indent, null);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
            editor.fireCharacterTypedEvent(insertOffset, c);
        }

        private boolean caretInsideStyle(String javaStyle, BasicDocument document, int insertOffset) {
            int currLine = document.getLineFromOffset(insertOffset);
            StyledFragmentsList sfl = document.getDocumentRenderer().renderLines(currLine, currLine);
            int i = 0;
            while (i < sfl.size()) {
                StyledFragment sf = sfl.get(i);
                if (javaStyle.equals(sf.styleName) && insertOffset > sf.startOffset && insertOffset < sf.endOffset) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        static {
            originalKeyTypedAction = new DefaultEditorKit.DefaultKeyTypedAction();
        }
    }

    public static class DeleteLineAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public DeleteLineAction() {
            super("delete-line");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_LINE");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            DeleteLineAction.makeEditable(editor);
            if (!DeleteLineAction.isEditable(editor, true)) {
                return;
            }
            int offset = editor.getCaretPosition();
            editor.setCaretPosition(offset);
            LineMap lineMap = document.getLineMap();
            int line = lineMap.getLineFromOffset(offset);
            int lineStart = lineMap.getLineStartOffset(line);
            int lineEnd = lineMap.getLineEndOffset(line);
            if (lineStart != lineEnd) {
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        editor.unselect();
                        document.remove(lineStart, lineEnd - lineStart);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }

    public static class DeleteNextCharAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public DeleteNextCharAction() {
            super("delete-next");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_NEXT");
                editDescriptor = new EditDescriptor(editName, BasicEditorKit.MERGE_DELETE_NEXT);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            boolean error;
            block12: {
                DeleteNextCharAction.makeEditable(editor);
                if (!DeleteNextCharAction.isEditable(editor, true)) {
                    return;
                }
                int selectStart = editor.getSelectionStart();
                int selectEnd = editor.getSelectionEnd();
                error = true;
                try {
                    if (selectStart != selectEnd) {
                        editor.beginEdit(editDescriptor);
                        try {
                            document.remove(selectStart, selectEnd - selectStart);
                        }
                        finally {
                            editor.endEdit();
                        }
                        error = false;
                        break block12;
                    }
                    if (selectStart >= document.getLength()) break block12;
                    editor.beginEdit(editDescriptor);
                    try {
                        document.remove(selectStart, 1);
                    }
                    finally {
                        editor.endEdit();
                    }
                    error = false;
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            if (error) {
                DeleteNextCharAction.beep(editor);
            }
        }
    }

    public static class DeletePrevCharAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public DeletePrevCharAction() {
            super("delete-previous");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_PREVIOUS");
                editDescriptor = new EditDescriptor(editName, BasicEditorKit.MERGE_DELETE_PREVIOUS);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            boolean error;
            block14: {
                DeletePrevCharAction.makeEditable(editor);
                if (!DeletePrevCharAction.isEditable(editor, true)) {
                    return;
                }
                int selectStart = editor.getSelectionStart();
                int selectEnd = editor.getSelectionEnd();
                error = true;
                try {
                    if (selectStart != selectEnd) {
                        editor.beginEdit(editDescriptor);
                        try {
                            document.remove(selectStart, selectEnd - selectStart);
                        }
                        finally {
                            editor.endEdit();
                        }
                        error = false;
                        break block14;
                    }
                    if (selectStart == 0) break block14;
                    TextBuffer textBuffer = document.getTextBuffer();
                    LineMap lineMap = document.getLineMap();
                    int currentOffset = editor.getCaretPosition();
                    int line = lineMap.getLineFromOffset(currentOffset);
                    int indentSize = DeletePrevCharAction.getIndentSizeProperty(editor);
                    int tabSize = DeletePrevCharAction.getTabSizeProperty(editor);
                    boolean useTabs = DeletePrevCharAction.getUseTabsProperty(editor);
                    int lineStart = lineMap.getLineStartOffset(line);
                    int lineEnd = lineMap.getLineEndOffset(line);
                    int endLeading = DeletePrevCharAction.skipLeadingIndent(textBuffer, lineStart, lineEnd);
                    editor.beginEdit(editDescriptor);
                    try {
                        if (endLeading != -1 && endLeading < currentOffset || currentOffset == lineStart) {
                            document.remove(currentOffset - 1, 1);
                            error = false;
                        } else {
                            int currentColumn = Utilities.getColumnFromOffset(textBuffer, line, currentOffset, tabSize);
                            int previousIndent = currentColumn - 1;
                            previousIndent -= previousIndent % indentSize;
                            String newIndent = DeletePrevCharAction.buildIndent(useTabs, tabSize, previousIndent);
                            document.remove(lineStart, currentOffset - lineStart);
                            document.insertString(lineStart, newIndent, null);
                            error = false;
                        }
                    }
                    finally {
                        editor.endEdit();
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            if (error) {
                DeletePrevCharAction.beep(editor);
            }
        }
    }

    public static class DeleteUntilEOLAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public DeleteUntilEOLAction() {
            super("delete-until-eol");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_UNTIL_EOL");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            DeleteUntilEOLAction.makeEditable(editor);
            if (!DeleteUntilEOLAction.isEditable(editor, true)) {
                return;
            }
            int begOffset = editor.getCaretPosition();
            int endOffset = Utilities.getRowEnd(document, begOffset);
            if (endOffset > begOffset) {
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        editor.unselect();
                        document.remove(begOffset, endOffset - begOffset);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }

    public static class DeleteNextWordAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public DeleteNextWordAction(String actionName, int wordBehavior) {
            super(actionName);
            this.wordBehavior = wordBehavior;
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_NEXT_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
            if (wordBehavior != 1 && wordBehavior != 2 && wordBehavior != 3) {
                throw new IllegalStateException("invalid word behavior: " + wordBehavior);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int nextWord;
            DeleteNextWordAction.makeEditable(editor);
            if (!DeleteNextWordAction.isEditable(editor, true)) {
                return;
            }
            int offset = editor.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    nextWord = Utilities.getNextWordStart(document, offset);
                    break;
                }
                case 2: {
                    nextWord = Utilities.getNextWordEnd(document, offset);
                    break;
                }
                case 3: {
                    nextWord = Math.min(Utilities.getNextWordStart(document, offset), Utilities.getNextWordEnd(document, offset));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (offset != nextWord) {
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        editor.unselect();
                        document.remove(offset, nextWord - offset);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }

    public static class DeletePreviousWordAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public DeletePreviousWordAction(String actionName, int wordBehavior) {
            super(actionName);
            this.wordBehavior = wordBehavior;
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_PREVIOUS_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
            if (wordBehavior != 1 && wordBehavior != 2 && wordBehavior != 3) {
                throw new IllegalStateException("invalid word behavior: " + wordBehavior);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int previousWord;
            DeletePreviousWordAction.makeEditable(editor);
            if (!DeletePreviousWordAction.isEditable(editor, true)) {
                return;
            }
            int offset = editor.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    previousWord = Utilities.getPreviousWordStart(document, offset);
                    break;
                }
                case 2: {
                    previousWord = Utilities.getPreviousWordEnd(document, offset);
                    break;
                }
                case 3: {
                    previousWord = Math.max(Utilities.getPreviousWordStart(document, offset), Utilities.getPreviousWordEnd(document, offset));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (offset != previousWord) {
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        editor.unselect();
                        document.remove(previousWord, offset - previousWord);
                        editor.setCaretPosition(previousWord);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends BasicWriteAction {
        private static EditDescriptor newlineDescriptor;

        public InsertBreakAction() {
            super("insert-break");
            if (newlineDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_INSERT_LINE");
                newlineDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            InsertBreakAction.makeEditable(editor);
            if (!InsertBreakAction.isEditable(editor, true)) {
                return;
            }
            TextBuffer textBuffer = document.getTextBuffer();
            LineMap lineMap = document.getLineMap();
            int selectStart = editor.getSelectionStart();
            int selectEnd = editor.getSelectionEnd();
            int oldLine = lineMap.getLineFromOffset(selectStart);
            int tabSize = InsertBreakAction.getTabSizeProperty(editor);
            boolean useTabs = InsertBreakAction.getUseTabsProperty(editor);
            boolean skipIndent = false;
            editor.beginEdit(newlineDescriptor);
            try {
                try {
                    int oldEnd;
                    int oldStart;
                    int endLeading;
                    if (selectStart != selectEnd) {
                        document.remove(selectStart, selectEnd - selectStart);
                    }
                    if ((endLeading = InsertBreakAction.skipLeadingIndent(textBuffer, oldStart = lineMap.getLineStartOffset(oldLine), oldEnd = lineMap.getLineEndOffset(oldLine))) == -1 || selectStart <= endLeading) {
                        int column = Utilities.getColumnFromOffset(textBuffer, oldLine, selectStart, tabSize);
                        String indent = InsertBreakAction.buildIndent(useTabs, tabSize, column);
                        skipIndent = true;
                        document.insertString(selectStart, indent, null);
                        document.insertString(selectStart, "\n", null);
                    } else {
                        document.insertString(selectStart, "\n", null);
                    }
                    if (!skipIndent) {
                        int oldStart2 = lineMap.getLineStartOffset(oldLine);
                        int oldEnd2 = lineMap.getLineEndOffset(oldLine);
                        int newLine = oldLine + 1;
                        int newStart = oldEnd2;
                        int newEnd = lineMap.getLineEndOffset(newLine);
                        boolean doAutoIndent = InsertBreakAction.getUseAutoIndentProperty(editor);
                        SmartIndentProvider smartProvider = InsertBreakAction.getSmartIndentProvider(editor, document);
                        if (smartProvider != null) {
                            boolean indentOld = smartProvider.shouldAutoReindentOldLine();
                            boolean indentNew = smartProvider.shouldAutoIndentNewLine();
                            if (indentNew) {
                                int indentToUse = smartProvider.getIndentForLine(newLine, tabSize);
                                int endLeading2 = InsertBreakAction.skipLeadingIndent(textBuffer, newStart, newEnd);
                                if (endLeading2 == -1) {
                                    int lastLine = lineMap.getLineCount() - 1;
                                    endLeading2 = newLine == lastLine ? newEnd : newEnd - 1;
                                }
                                String indent = InsertBreakAction.buildIndent(useTabs, tabSize, indentToUse);
                                document.remove(newStart, endLeading2 - newStart);
                                document.insertString(newStart, indent, null);
                                editor.setCaretPosition(newStart + indent.length());
                            }
                            if (indentOld) {
                                int indentToUse = smartProvider.getIndentForLine(oldLine, tabSize);
                                int endLeading3 = InsertBreakAction.skipLeadingIndent(textBuffer, oldStart2, oldEnd2);
                                if (endLeading3 == -1) {
                                    int lastLine = lineMap.getLineCount() - 1;
                                    endLeading3 = newLine == lastLine ? oldEnd2 : oldEnd2 - 1;
                                }
                                String indent = InsertBreakAction.buildIndent(useTabs, tabSize, indentToUse);
                                document.remove(oldStart2, endLeading3 - oldStart2);
                                document.insertString(oldStart2, indent, null);
                            }
                        } else if (doAutoIndent) {
                            int endLeading4 = InsertBreakAction.skipLeadingIndent(textBuffer, oldStart2, oldEnd2);
                            if (endLeading4 == -1) {
                                endLeading4 = oldEnd2 - 1;
                            }
                            int indentToUse = Utilities.getColumnFromOffset(textBuffer, endLeading4, tabSize);
                            String indent = InsertBreakAction.buildIndent(useTabs, tabSize, indentToUse);
                            endLeading4 = InsertBreakAction.skipLeadingIndent(textBuffer, newStart, newEnd);
                            if (endLeading4 == -1) {
                                int lastLine = lineMap.getLineCount() - 1;
                                endLeading4 = newLine == lastLine ? newEnd : newEnd - 1;
                            }
                            document.remove(newStart, endLeading4 - newStart);
                            document.insertString(newStart, indent, null);
                            editor.setCaretPosition(newStart + indent.length());
                        }
                    }
                }
                catch (BadLocationException e) {}
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class InsertTabAction
    extends BlockIndentOutdentAction {
        private static EditDescriptor editDescriptor;

        public InsertTabAction() {
            super("insert-tab", true);
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_INSERT_TAB");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            block9: {
                int currentOffset;
                if (this.shouldPerformBlockOperation(editor)) {
                    super.actionPerformed(event, editor, document);
                    return;
                }
                InsertTabAction.makeEditable(editor);
                if (!InsertTabAction.isEditable(editor, true)) {
                    return;
                }
                int indentSize = InsertTabAction.getIndentSizeProperty(editor);
                int tabSize = InsertTabAction.getTabSizeProperty(editor);
                boolean useTabs = InsertTabAction.getUseTabsProperty(editor);
                TextBuffer textBuffer = document.getTextBuffer();
                LineMap lineMap = document.getLineMap();
                int selectStart = currentOffset = editor.getSelectionStart();
                int selectEnd = editor.getSelectionEnd();
                int line = lineMap.getLineFromOffset(currentOffset);
                int lineStart = lineMap.getLineStartOffset(line);
                int lineEnd = lineMap.getLineEndOffset(line);
                int endLeading = InsertTabAction.skipLeadingIndent(textBuffer, lineStart, lineEnd);
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        int currentColumn = Utilities.getColumnFromOffset(textBuffer, line, currentOffset, tabSize);
                        int nextTabStop = Utilities.getNextTabStop(indentSize, currentColumn);
                        if (endLeading != -1 && endLeading < currentOffset) {
                            String tabToUse;
                            int numSpaces = nextTabStop - currentColumn;
                            String string = tabToUse = useTabs ? "\t" : InsertTabAction.getSpaces(numSpaces);
                            if (selectStart != selectEnd) {
                                document.remove(selectStart, selectEnd - selectStart);
                            }
                            document.insertString(selectStart, tabToUse, null);
                            break block9;
                        }
                        String indentToUse = InsertTabAction.buildIndent(useTabs, tabSize, nextTabStop);
                        document.remove(lineStart, selectEnd - lineStart);
                        document.insertString(lineStart, indentToUse, null);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }

    public static class OpenLineAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public OpenLineAction() {
            super("open-line");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_OPEN_LINE");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            OpenLineAction.makeEditable(editor);
            if (!OpenLineAction.isEditable(editor, true)) {
                return;
            }
            int selectStart = editor.getSelectionStart();
            int selectEnd = editor.getSelectionEnd();
            editor.beginEdit(editDescriptor);
            try {
                try {
                    if (selectStart != selectEnd) {
                        document.remove(selectStart, selectEnd - selectStart);
                    }
                    document.insertString(selectStart, "\n", null);
                    editor.setCaretPosition(selectStart);
                }
                catch (BadLocationException e) {}
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class ReverseTabAction
    extends BlockIndentOutdentAction {
        public ReverseTabAction() {
            super("reverse-tab", false);
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            if (this.shouldPerformBlockOperation(editor)) {
                super.actionPerformed(event, editor, document);
                return;
            }
            int indentSize = ReverseTabAction.getIndentSizeProperty(editor);
            int tabSize = ReverseTabAction.getTabSizeProperty(editor);
            TextBuffer textBuffer = document.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int offset = editor.getCaretPosition();
            int column = Utilities.getColumnFromOffset(textBuffer, offset, tabSize);
            int prevTabStop = column - indentSize - 1;
            prevTabStop = prevTabStop > 0 ? Utilities.getNextTabStop(indentSize, prevTabStop) : 0;
            int line = lineMap.getLineFromOffset(offset);
            int prevOffset = Utilities.getOffsetFromColumn(textBuffer, line, prevTabStop, tabSize);
            if (offset != prevOffset) {
                editor.beginNavigation();
                try {
                    editor.setCaretPosition(prevOffset);
                }
                finally {
                    editor.endNavigation();
                }
            }
        }
    }

    public static class SortSelectedLines
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public SortSelectedLines() {
            super("sort-selected-lines");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_SORT_SELECTED_LINES");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            SortSelectedLines.makeEditable(editor);
            if (!SortSelectedLines.isEditable(editor, true)) {
                return;
            }
            if (!editor.hasSelection()) {
                return;
            }
            editor.beginEdit(editDescriptor);
            try {
                try {
                    LineMap lineMap = document.getLineMap();
                    int selectStart = editor.getSelectionStart();
                    int selectEnd = editor.getSelectionEnd();
                    int startLine = lineMap.getLineFromOffset(selectStart);
                    int endLine = lineMap.getLineFromOffset(selectEnd);
                    if (selectEnd == lineMap.getLineStartOffset(endLine)) {
                        --endLine;
                    }
                    ArrayList<String> textList = new ArrayList<String>();
                    int lastLine = lineMap.getLineCount() - 1;
                    int i = startLine;
                    while (i <= endLine) {
                        int textStart = lineMap.getLineStartOffset(i);
                        int textEnd = lineMap.getLineEndOffset(i);
                        if (i != lastLine) {
                            --textEnd;
                        }
                        String lineText = document.getText(textStart, textEnd - textStart);
                        textList.add(lineText);
                        ++i;
                    }
                    Collections.sort(textList, String.CASE_INSENSITIVE_ORDER);
                    int blockStart = lineMap.getLineStartOffset(startLine);
                    int blockEnd = lineMap.getLineEndOffset(endLine);
                    document.remove(blockStart, blockEnd - blockStart);
                    StringBuffer combinedText = new StringBuffer();
                    int numLines = textList.size();
                    int i2 = 0;
                    while (i2 < numLines) {
                        combinedText.append(textList.get(i2).toString());
                        combinedText.append('\n');
                        ++i2;
                    }
                    document.insertString(blockStart, combinedText.toString(), null);
                    editor.select(blockStart, blockStart + combinedText.length());
                }
                catch (BadLocationException e) {}
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class TrimWhitespaceAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public TrimWhitespaceAction() {
            super("trim-whitespace");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_TRIM_WHITESPACE");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            TrimWhitespaceAction.makeEditable(editor);
            if (!TrimWhitespaceAction.isEditable(editor, true)) {
                return;
            }
            editor.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = document.getTextBuffer();
                boolean endOfLine = true;
                int i = textBuffer.getLength() - 1;
                while (i >= 0) {
                    char c = textBuffer.getChar(i);
                    if (c == '\n') {
                        endOfLine = true;
                    } else if (Character.isWhitespace(c) && endOfLine) {
                        try {
                            document.remove(i, 1);
                        }
                        catch (BadLocationException e) {}
                    } else {
                        endOfLine = false;
                    }
                    --i;
                }
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class ToggleCommentsAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public ToggleCommentsAction() {
            super("toggle-java-comments");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_TOGGLE_COMMENTS");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        private boolean isWhitespaceOnly(TextBuffer textBuffer, int startOffset, int endOffset) {
            int current = startOffset;
            while (current < endOffset) {
                char c;
                if (Character.isWhitespace(c = textBuffer.getChar(current++))) continue;
                return false;
            }
            return true;
        }

        private int getCommentStart(TextBuffer textBuffer, String commentDelimiter, int lineStart, int lineEnd, boolean ignoreInitialWhitespace) {
            int commentLength = commentDelimiter.length();
            int lastOffsetToCheck = lineEnd - commentLength + 1;
            int current = lineStart;
            if (ignoreInitialWhitespace) {
                while (current < lastOffsetToCheck) {
                    char c = textBuffer.getChar(current);
                    if (!Character.isWhitespace(c)) break;
                    ++current;
                }
            }
            if (current < lastOffsetToCheck) {
                int i = 0;
                while (i < commentLength) {
                    char c_cd;
                    char c_tb = textBuffer.getChar(current + i);
                    if (c_tb != (c_cd = commentDelimiter.charAt(i))) {
                        return -1;
                    }
                    ++i;
                }
                return current;
            }
            return -1;
        }

        private int getCommentStart(String line, String commentDelimiter, boolean ignoreInitialWhitespace) {
            int commentLength = commentDelimiter.length();
            int lastOffsetToCheck = line.length();
            int current = 0;
            if (ignoreInitialWhitespace) {
                while (current < lastOffsetToCheck) {
                    char c = line.charAt(current);
                    if (!Character.isWhitespace(c)) break;
                    ++current;
                }
            }
            if (current < lastOffsetToCheck) {
                int i = 0;
                while (i < commentLength) {
                    char c_cd;
                    char c_tb = line.charAt(current + i);
                    if (c_tb != (c_cd = commentDelimiter.charAt(i))) {
                        return -1;
                    }
                    ++i;
                }
                return current;
            }
            return -1;
        }

        private boolean areLinesCommented(TextBuffer textBuffer, String commentDelimiter, int startLine, int endLine) {
            LineMap lineMap = textBuffer.getLineMap();
            boolean regionIsWhitespaceOnly = true;
            boolean isCommented = true;
            int i = startLine;
            while (i <= endLine) {
                int lineEnd;
                int lineStart = lineMap.getLineStartOffset(i);
                if (!this.isWhitespaceOnly(textBuffer, lineStart, lineEnd = lineMap.getLineEndOffset(i))) {
                    regionIsWhitespaceOnly = false;
                    if (this.getCommentStart(textBuffer, commentDelimiter, lineStart, lineEnd, true) == -1) {
                        isCommented = false;
                        break;
                    }
                }
                ++i;
            }
            if (regionIsWhitespaceOnly) {
                return false;
            }
            return isCommented;
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            ToggleCommentsAction.makeEditable(editor);
            if (!ToggleCommentsAction.isEditable(editor, true)) {
                return;
            }
            LanguageSupport support = document.getLanguageSupport();
            String commentDelimiter = (String)support.getProperty("line-comment-start");
            if (commentDelimiter == null || commentDelimiter.length() == 0) {
                return;
            }
            editor.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = document.getTextBuffer();
                LineMap lineMap = document.getLineMap();
                int selectStart = editor.getSelectionStart();
                int selectEnd = editor.getSelectionEnd();
                boolean hasSelection = selectStart != selectEnd;
                int startLine = lineMap.getLineFromOffset(selectStart);
                int endLine = lineMap.getLineFromOffset(selectEnd);
                if (startLine != endLine && lineMap.getLineStartOffset(endLine) == selectEnd) {
                    --endLine;
                }
                boolean doCommented = this.areLinesCommented(textBuffer, commentDelimiter, startLine, endLine) ^ true;
                try {
                    int firstLineStart = lineMap.getLineStartOffset(startLine);
                    int lastLineEnd = lineMap.getLineEndOffset(endLine);
                    String commentString = document.getText(firstLineStart, lastLineEnd - firstLineStart);
                    StringBuffer processedString = new StringBuffer(lastLineEnd - firstLineStart);
                    int i = startLine;
                    while (i <= endLine) {
                        int lineStart = lineMap.getLineStartOffset(i);
                        int lineEnd = lineMap.getLineEndOffset(i);
                        String line = document.getText(lineStart, lineEnd - lineStart);
                        if (doCommented) {
                            processedString.append(commentDelimiter);
                            processedString.append(line);
                        } else {
                            int commentStart = this.getCommentStart(line, commentDelimiter, true);
                            if (commentStart != -1) {
                                String before = line.substring(0, commentStart);
                                String after = line.substring(commentStart + commentDelimiter.length());
                                processedString.append(before);
                                processedString.append(after);
                            } else {
                                processedString.append(line);
                            }
                        }
                        ++i;
                    }
                    document.remove(firstLineStart, commentString.length());
                    document.insertString(firstLineStart, processedString.toString(), null);
                    int lineCount = endLine - startLine + 1;
                    if (doCommented) {
                        editor.setSelectionStart(selectStart + commentDelimiter.length());
                        editor.setSelectionEnd(selectEnd + commentDelimiter.length() * lineCount);
                    } else {
                        int lineStartOffset = editor.getLineStartOffset(editor.getLineFromOffset(selectStart));
                        int newOffset = Math.max(lineStartOffset, selectStart - commentDelimiter.length());
                        editor.setSelectionStart(newOffset);
                        editor.setSelectionEnd(selectEnd - commentDelimiter.length() * lineCount);
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                if (!hasSelection) {
                    int lineEnd = lineMap.getLineEndOffset(endLine);
                    EditorProperties properties = EditorProperties.getProperties();
                    boolean advanceCaret = properties.getBooleanProperty("toggle-comments-advance");
                    if (advanceCaret) {
                        editor.setCaretPosition(lineEnd);
                    }
                }
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class TabifyAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public TabifyAction() {
            super("tabify");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_TABIFY");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            TabifyAction.makeEditable(editor);
            if (!TabifyAction.isEditable(editor, true)) {
                return;
            }
            editor.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = document.getTextBuffer();
                LineMap lineMap = document.getLineMap();
                int lineCount = lineMap.getLineCount();
                int tabSize = TabifyAction.getTabSizeProperty(editor);
                boolean useTabs = true;
                int i = 0;
                while (i < lineCount) {
                    int lineEnd;
                    int lineStart = lineMap.getLineStartOffset(i);
                    int endLeading = TabifyAction.skipLeadingIndent(textBuffer, lineStart, lineEnd = lineMap.getLineEndOffset(i));
                    if (endLeading != -1) {
                        int indentSize = Utilities.getColumnFromOffset(textBuffer, i, endLeading, tabSize);
                        String newIndent = TabifyAction.buildIndent(true, tabSize, indentSize);
                        String currentIndent = textBuffer.getString(lineStart, endLeading - lineStart);
                        if (!currentIndent.equals(newIndent)) {
                            try {
                                document.remove(lineStart, endLeading - lineStart);
                                document.insertString(lineStart, newIndent, null);
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class TransposeCharsAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public TransposeCharsAction() {
            super("transpose-chars");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_TRANSPOSE_CHARS");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            TransposeCharsAction.makeEditable(editor);
            if (!TransposeCharsAction.isEditable(editor, true)) {
                return;
            }
            int offset = editor.getCaretPosition();
            if (offset == 0 || offset == document.getLength()) {
                TransposeCharsAction.beep(editor);
                return;
            }
            editor.beginEdit(editDescriptor);
            try {
                try {
                    editor.unselect();
                    String caretStr = document.getText(offset, 1);
                    document.remove(offset, 1);
                    document.insertString(offset - 1, caretStr, null);
                }
                catch (BadLocationException e) {}
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class UntabifyAction
    extends BasicWriteAction {
        private static EditDescriptor editDescriptor;

        public UntabifyAction() {
            super("untabify");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_UNTABIFY");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            UntabifyAction.makeEditable(editor);
            if (!UntabifyAction.isEditable(editor, true)) {
                return;
            }
            editor.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = document.getTextBuffer();
                LineMap lineMap = document.getLineMap();
                int length = textBuffer.getLength();
                int tabSize = UntabifyAction.getTabSizeProperty(editor);
                boolean useTabs = false;
                int i = length - 1;
                while (i >= 0) {
                    char c = textBuffer.getChar(i);
                    if (c == '\t') {
                        int line = lineMap.getLineFromOffset(i);
                        int column = Utilities.getColumnFromOffset(textBuffer, line, i, tabSize);
                        int spaces = tabSize - column % tabSize;
                        String spaceStr = UntabifyAction.buildIndent(false, tabSize, spaces);
                        try {
                            document.remove(i, 1);
                            document.insertString(i, spaceStr, null);
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                    }
                    --i;
                }
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static class BeepAction
    extends BasicAction {
        public BeepAction() {
            super("beep");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            BeepAction.beep(editor);
        }
    }

    public static class SetLocalTabSizeAction
    extends BasicAction {
        private Integer tabSize;

        public SetLocalTabSizeAction(String actionName, int size) {
            super(actionName);
            this.tabSize = new Integer(size);
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.putProperty("tab-size", this.tabSize);
        }
    }

    public static class ReadOnlyAction
    extends BasicAction {
        public ReadOnlyAction() {
            super("set-read-only");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.setEditable(false);
        }
    }

    public static class WritableAction
    extends BasicAction {
        public WritableAction() {
            super("set-writable");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.setEditable(true);
        }
    }

    public static class ToggleInsertModeAction
    extends BasicAction {
        public ToggleInsertModeAction() {
            super("toggle-insert-mode");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Caret caret = editor.getCaret();
            if (caret != null && caret instanceof BasicCaret) {
                BasicCaret basicCaret = (BasicCaret)caret;
                basicCaret.toggleInsertMode();
            }
        }
    }

    public static class MacroRecorderAction
    extends BasicWriteAction {
        private static KeyRecorder recorder = new KeyRecorder();
        private boolean doPlayback;

        public MacroRecorderAction(String name, boolean doPlayback) {
            super(name);
            this.doPlayback = doPlayback;
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            if (this.doPlayback) {
                recorder.playbackRecording(editor);
            } else {
                recorder.toggleRecording(editor);
            }
        }
    }

    public static class GotoMatchingBraceAction
    extends BasicAction {
        private boolean performSelect;
        private static String NOT_AVAILABLE;
        private static String NONE_AT_CURSOR;
        private static String MISMATCH;

        public GotoMatchingBraceAction(String actionName, boolean performSelect) {
            super(actionName);
            this.performSelect = performSelect;
            if (NOT_AVAILABLE == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                NOT_AVAILABLE = resources.getString("BRACE_MATCHING_NOT_AVAILABLE");
                NONE_AT_CURSOR = resources.getString("BRACE_MATCHING_NONE_AT_CURSOR");
                MISMATCH = resources.getString("BRACE_MATCHING_MISMATCH");
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            LanguageSupport languageSupport = document.getLanguageSupport();
            BraceProvider braceProvider = languageSupport.getBraceProvider();
            if (braceProvider == null) {
                GotoMatchingBraceAction.showMessage(editor, NOT_AVAILABLE);
                return;
            }
            NumberRange braceLocation = new NumberRange(0, 0);
            NumberRange matchingLocation = new NumberRange(0, 0);
            int caretOffset = editor.getCaretPosition();
            int braceType = -1;
            if (caretOffset > 0) {
                braceType = braceProvider.isPartOfBrace(caretOffset - 1, braceLocation);
            }
            if (braceType == -1) {
                braceType = braceProvider.isPartOfBrace(caretOffset, braceLocation);
            }
            if (braceType == -1) {
                GotoMatchingBraceAction.showMessage(editor, NONE_AT_CURSOR);
                return;
            }
            int matchResult = braceProvider.findMatchingBrace(braceType, braceLocation, matchingLocation);
            if (matchResult != 3) {
                boolean matchBefore = matchingLocation.end <= braceLocation.start;
                editor.beginNavigation();
                if (this.performSelect) {
                    if (matchBefore) {
                        editor.setCaretPositionCenter(braceLocation.start);
                        editor.moveCaretPositionCenter(matchingLocation.end);
                    } else {
                        editor.setCaretPositionCenter(braceLocation.end);
                        editor.moveCaretPositionCenter(matchingLocation.start);
                    }
                } else {
                    editor.setCaretPositionCenter(matchingLocation.end);
                }
                editor.endNavigation();
            } else {
                GotoMatchingBraceAction.showMessage(editor, MISMATCH);
            }
        }
    }

    public static abstract class NavigateAction
    extends BasicAction {
        private boolean performSelect;

        protected NavigateAction(String actionName, boolean performSelect) {
            super(actionName);
            this.performSelect = performSelect;
        }

        protected final boolean doSelect() {
            return this.performSelect;
        }

        public final void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.beginNavigation();
            try {
                this.navigatePerformed(event, editor, document);
            }
            finally {
                editor.endNavigation();
            }
        }

        protected abstract void navigatePerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3);
    }

    public static class PageUpAction
    extends NavigateAction {
        public PageUpAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Rectangle visibleRect = PageUpAction.getVisibleRect(editor);
            int fontHeight = PageUpAction.getFontHeight(editor);
            int visibleRows = visibleRect.height / fontHeight;
            int scrollHeight = visibleRows * fontHeight;
            visibleRect.y -= scrollHeight;
            visibleRect.y = Math.max(0, visibleRect.y);
            editor.scrollRectToVisible(visibleRect);
            try {
                int offset = editor.getCaretPosition();
                Point magicPosition = PageUpAction.getMagicCaretPosition(editor);
                Rectangle caretRect = editor.modelToView(offset);
                Point newCaretPosition = new Point(caretRect.x, caretRect.y);
                newCaretPosition.y -= scrollHeight;
                newCaretPosition.y = Math.max(0, newCaretPosition.y);
                newCaretPosition.x = magicPosition.x;
                int newOffset = editor.viewToModel(newCaretPosition);
                if (newOffset != offset) {
                    if (this.doSelect()) {
                        editor.moveCaretPosition(newOffset);
                    } else {
                        editor.setCaretPosition(newOffset);
                    }
                }
                PageUpAction.setMagicCaretPosition(editor, newCaretPosition);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class PageDownAction
    extends NavigateAction {
        public PageDownAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Rectangle visibleRect = PageDownAction.getVisibleRect(editor);
            int fontHeight = PageDownAction.getFontHeight(editor);
            int visibleRows = visibleRect.height / fontHeight;
            int scrollHeight = visibleRows * fontHeight;
            visibleRect.y += scrollHeight;
            int editorHeight = editor.getHeight();
            if (visibleRect.y + visibleRect.height > editorHeight) {
                visibleRect.y = editorHeight - visibleRect.height;
            }
            editor.scrollRectToVisible(visibleRect);
            try {
                int offset = editor.getCaretPosition();
                Point magicPosition = PageDownAction.getMagicCaretPosition(editor);
                Rectangle caretRect = editor.modelToView(offset);
                Point newCaretPosition = new Point(caretRect.x, caretRect.y);
                newCaretPosition.y += scrollHeight;
                newCaretPosition.y = Math.min(newCaretPosition.y, editor.getHeight());
                newCaretPosition.x = magicPosition.x;
                int newOffset = editor.viewToModel(newCaretPosition);
                if (newOffset != offset) {
                    if (this.doSelect()) {
                        editor.moveCaretPosition(newOffset);
                    } else {
                        editor.setCaretPosition(newOffset);
                    }
                }
                PageDownAction.setMagicCaretPosition(editor, newCaretPosition);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class ForwardAction
    extends NavigateAction {
        public ForwardAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            int nextOffset = Math.min(offset + 1, document.getLength());
            if (nextOffset != offset) {
                if (this.doSelect()) {
                    editor.moveCaretPosition(nextOffset);
                } else {
                    editor.setCaretPosition(nextOffset);
                }
            }
        }
    }

    public static class BackwardAction
    extends NavigateAction {
        public BackwardAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            int previousOffset = Math.max(offset - 1, 0);
            if (previousOffset != offset) {
                if (this.doSelect()) {
                    editor.moveCaretPosition(previousOffset);
                } else {
                    editor.setCaretPosition(previousOffset);
                }
            }
        }
    }

    public static class UpAction
    extends NavigateAction {
        public UpAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            try {
                int fontHeight = UpAction.getFontHeight(editor);
                int offset = editor.getCaretPosition();
                Point magicPosition = UpAction.getMagicCaretPosition(editor);
                Rectangle caretRect = editor.modelToView(offset);
                Point newCaretPosition = new Point(caretRect.x, caretRect.y);
                newCaretPosition.y -= fontHeight;
                newCaretPosition.y = Math.max(0, newCaretPosition.y);
                newCaretPosition.x = magicPosition.x;
                int newOffset = editor.viewToModel(newCaretPosition);
                if (newOffset != offset) {
                    if (this.doSelect()) {
                        editor.moveCaretPosition(newOffset);
                    } else {
                        editor.setCaretPosition(newOffset);
                    }
                }
                UpAction.setMagicCaretPosition(editor, newCaretPosition);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class DownAction
    extends NavigateAction {
        public DownAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            try {
                int fontHeight = DownAction.getFontHeight(editor);
                int offset = editor.getCaretPosition();
                Point magicPosition = DownAction.getMagicCaretPosition(editor);
                Rectangle caretRect = editor.modelToView(offset);
                Point newCaretPosition = new Point(caretRect.x, caretRect.y);
                newCaretPosition.y += fontHeight;
                newCaretPosition.y = Math.min(newCaretPosition.y, editor.getHeight());
                newCaretPosition.x = magicPosition.x;
                int newOffset = editor.viewToModel(newCaretPosition);
                if (newOffset != offset) {
                    if (this.doSelect()) {
                        editor.moveCaretPosition(newOffset);
                    } else {
                        editor.setCaretPosition(newOffset);
                    }
                }
                DownAction.setMagicCaretPosition(editor, newCaretPosition);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class BeginWordAction
    extends NavigateAction {
        public BeginWordAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            int wordStart = Utilities.getWordStart(document, offset);
            if (this.doSelect()) {
                editor.moveCaretPosition(wordStart);
            } else {
                editor.setCaretPosition(wordStart);
            }
        }
    }

    public static class EndWordAction
    extends NavigateAction {
        public EndWordAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            int wordEnd = Utilities.getWordEnd(document, offset);
            if (this.doSelect()) {
                editor.moveCaretPosition(wordEnd);
            } else {
                editor.setCaretPosition(wordEnd);
            }
        }
    }

    public static class PreviousWordAction
    extends NavigateAction {
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public PreviousWordAction(String actionName, int wordBehavior, boolean performSelect) {
            super(actionName, performSelect);
            this.wordBehavior = wordBehavior;
            if (wordBehavior != 1 && wordBehavior != 2 && wordBehavior != 3) {
                throw new IllegalStateException("invalid word behavior: " + wordBehavior);
            }
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int previousWord;
            int offset = editor.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    previousWord = Utilities.getPreviousWordStart(document, offset);
                    break;
                }
                case 2: {
                    previousWord = Utilities.getPreviousWordEnd(document, offset);
                    break;
                }
                case 3: {
                    previousWord = Math.max(Utilities.getPreviousWordStart(document, offset), Utilities.getPreviousWordEnd(document, offset));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (this.doSelect()) {
                editor.moveCaretPosition(previousWord);
            } else {
                editor.setCaretPosition(previousWord);
            }
        }
    }

    public static class NextWordAction
    extends NavigateAction {
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public NextWordAction(String actionName, int wordBehavior, boolean performSelect) {
            super(actionName, performSelect);
            this.wordBehavior = wordBehavior;
            if (wordBehavior != 1 && wordBehavior != 2 && wordBehavior != 3) {
                throw new IllegalStateException("invalid word behavior: " + wordBehavior);
            }
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int nextWord;
            int offset = editor.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    nextWord = Utilities.getNextWordStart(document, offset);
                    break;
                }
                case 2: {
                    nextWord = Utilities.getNextWordEnd(document, offset);
                    break;
                }
                case 3: {
                    nextWord = Math.min(Utilities.getNextWordStart(document, offset), Utilities.getNextWordEnd(document, offset));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (this.doSelect()) {
                editor.moveCaretPosition(nextWord);
            } else {
                editor.setCaretPosition(nextWord);
            }
        }
    }

    public static class BeginLineAction
    extends NavigateAction {
        public BeginLineAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Boolean useSmartBool = (Boolean)editor.getProperty("use-smart-home");
            boolean useSmartHome = useSmartBool;
            int offset = editor.getCaretPosition();
            TextBuffer textBuffer = document.getTextBuffer();
            try {
                offset = Math.max(0, offset);
                offset = Math.min(textBuffer.getLength(), offset);
                Rectangle caretRect = editor.modelToView(offset);
                Point startPoint = new Point(0, caretRect.y);
                int rowStart = editor.viewToModel(startPoint);
                Point endPoint = new Point(editor.getWidth(), caretRect.y);
                int rowEnd = editor.viewToModel(endPoint);
                if (useSmartHome) {
                    int checkOffset = rowStart;
                    while (checkOffset < rowEnd) {
                        char c = textBuffer.getChar(checkOffset);
                        if (c == '\n' || !Character.isWhitespace(c)) break;
                        ++checkOffset;
                    }
                    if (offset != checkOffset) {
                        rowStart = checkOffset;
                    }
                }
                if (this.doSelect()) {
                    editor.moveCaretPosition(rowStart);
                } else {
                    editor.setCaretPosition(rowStart);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class EndLineAction
    extends NavigateAction {
        public EndLineAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Boolean useSmartBool = (Boolean)editor.getProperty("use-smart-end");
            boolean useSmartEnd = useSmartBool;
            int offset = editor.getCaretPosition();
            TextBuffer textBuffer = document.getTextBuffer();
            try {
                offset = Math.max(0, offset);
                offset = Math.min(textBuffer.getLength(), offset);
                Rectangle caretRect = editor.modelToView(offset);
                Point startPoint = new Point(0, caretRect.y);
                int rowStart = editor.viewToModel(startPoint);
                Point endPoint = new Point(editor.getWidth(), caretRect.y);
                int rowEnd = editor.viewToModel(endPoint);
                if (useSmartEnd) {
                    int checkOffset = rowEnd;
                    while (checkOffset > rowStart) {
                        char c = textBuffer.getChar(checkOffset - 1);
                        if (c == '\n' || !Character.isWhitespace(c)) break;
                        --checkOffset;
                    }
                    if (offset != checkOffset) {
                        rowEnd = checkOffset;
                    }
                }
                if (this.doSelect()) {
                    editor.moveCaretPosition(rowEnd);
                } else {
                    editor.setCaretPosition(rowEnd);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class BeginAction
    extends NavigateAction {
        public BeginAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            if (this.doSelect()) {
                editor.moveCaretPosition(0);
            } else {
                editor.setCaretPosition(0);
            }
        }
    }

    public static class EndAction
    extends NavigateAction {
        public EndAction(String actionName, boolean performSelect) {
            super(actionName, performSelect);
        }

        protected void navigatePerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int length = document.getLength();
            if (this.doSelect()) {
                editor.moveCaretPosition(length);
            } else {
                editor.setCaretPosition(length);
            }
        }
    }

    public static class SelectWordAction
    extends BasicAction {
        public SelectWordAction() {
            super("select-word");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            int wordStart = Utilities.getWordStart(document, offset);
            int wordEnd = Utilities.getWordEnd(document, offset);
            editor.beginNavigation();
            try {
                editor.setCaretPosition(wordStart);
                editor.moveCaretPosition(wordEnd);
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static class SelectLineAction
    extends BasicAction {
        public SelectLineAction() {
            super("select-line");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getSelectionStart();
            try {
                offset = Math.max(0, offset);
                offset = Math.min(document.getLength(), offset);
                Rectangle caretRect = editor.modelToView(offset);
                Point startPoint = new Point(0, caretRect.y);
                int rowStart = editor.viewToModel(startPoint);
                int fontHeight = SelectLineAction.getFontHeight(editor);
                Point endPoint = new Point(0, caretRect.y + fontHeight);
                int rowEnd = editor.viewToModel(endPoint);
                editor.beginNavigation();
                try {
                    editor.setCaretPosition(rowStart);
                    editor.moveCaretPosition(rowEnd);
                }
                finally {
                    editor.endNavigation();
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class SelectAllAction
    extends BasicAction {
        public SelectAllAction() {
            super("select-all");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.beginNavigation();
            try {
                editor.selectAll();
                if (editor.getCaret() instanceof BasicCaret) {
                    BasicCaret bCarat = (BasicCaret)editor.getCaret();
                    bCarat.getEditorSelection().selectAll();
                    bCarat.updateHighlight();
                }
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static class UnselectAction
    extends BasicAction {
        public UnselectAction() {
            super("unselect");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            editor.beginNavigation();
            try {
                editor.unselect();
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static class RecenterLineAction
    extends BasicAction {
        public RecenterLineAction() {
            super("recenter-line");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            try {
                int offset = editor.getCaretPosition();
                Rectangle offsetRect = editor.modelToView(offset);
                Rectangle visibleRect = RecenterLineAction.getVisibleRect(editor);
                visibleRect.y = offsetRect.y - (visibleRect.height - offsetRect.height >> 1);
                visibleRect.y = Math.max(0, visibleRect.y);
                int editorHeight = editor.getHeight();
                if (visibleRect.y + visibleRect.height > editorHeight) {
                    visibleRect.y = editorHeight - visibleRect.height;
                }
                editor.scrollRectToVisible(visibleRect);
                editor.scrollRectToVisible(offsetRect);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public static class ScrollLineUpAction
    extends BasicAction {
        public ScrollLineUpAction() {
            super("scroll-line-up");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            block7: {
                int fontHeight = ScrollLineUpAction.getFontHeight(editor);
                Rectangle oldVisibleRect = ScrollLineUpAction.getVisibleRect(editor);
                Rectangle visibleRect = new Rectangle(oldVisibleRect);
                visibleRect.y -= fontHeight;
                visibleRect.y = Math.max(0, visibleRect.y);
                if (oldVisibleRect.y == visibleRect.y) {
                    return;
                }
                editor.scrollRectToVisible(visibleRect);
                try {
                    boolean fullyVisible;
                    Rectangle caretRect;
                    int caretOffset = editor.getCaretPosition();
                    Rectangle caretInsets = caretRect = editor.modelToView(caretOffset);
                    Caret caret = editor.getCaret();
                    if (caret != null && caret instanceof BasicCaret) {
                        caretInsets = ((BasicCaret)caret).getCaretInsets(caretRect);
                    }
                    if (fullyVisible = visibleRect.contains(caretInsets)) break block7;
                    int insetHeight = (caretInsets.height + fontHeight) / 2;
                    Point bottomPoint = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
                    Point magicPosition = ScrollLineUpAction.getMagicCaretPosition(editor);
                    Point newCaretPosition = new Point(bottomPoint);
                    newCaretPosition.y -= insetHeight;
                    newCaretPosition.y = Math.max(0, newCaretPosition.y);
                    newCaretPosition.x = magicPosition.x;
                    int newOffset = editor.viewToModel(newCaretPosition);
                    editor.beginNavigation();
                    try {
                        editor.setCaretPosition(newOffset);
                    }
                    finally {
                        editor.endNavigation();
                    }
                    ScrollLineUpAction.setMagicCaretPosition(editor, newCaretPosition);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
    }

    public static class ScrollLineDownAction
    extends BasicAction {
        public ScrollLineDownAction() {
            super("scroll-line-down");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            block8: {
                int fontHeight = ScrollLineDownAction.getFontHeight(editor);
                Rectangle oldVisibleRect = ScrollLineDownAction.getVisibleRect(editor);
                Rectangle visibleRect = new Rectangle(oldVisibleRect);
                visibleRect.y += fontHeight;
                int editorHeight = editor.getHeight();
                if (visibleRect.y + visibleRect.height > editorHeight) {
                    visibleRect.y = editorHeight - visibleRect.height;
                }
                if (oldVisibleRect.y == visibleRect.y) {
                    return;
                }
                editor.scrollRectToVisible(visibleRect);
                try {
                    boolean fullyVisible;
                    Rectangle caretRect;
                    int caretOffset = editor.getCaretPosition();
                    Rectangle caretInsets = caretRect = editor.modelToView(caretOffset);
                    Caret caret = editor.getCaret();
                    if (caret != null && caret instanceof BasicCaret) {
                        caretInsets = ((BasicCaret)caret).getCaretInsets(caretRect);
                    }
                    if (fullyVisible = visibleRect.contains(caretInsets)) break block8;
                    int insetHeight = (caretInsets.height + fontHeight) / 2;
                    Point topPoint = new Point(visibleRect.x, visibleRect.y);
                    Point magicPosition = ScrollLineDownAction.getMagicCaretPosition(editor);
                    Point newCaretPosition = new Point(topPoint);
                    newCaretPosition.y += insetHeight;
                    newCaretPosition.y = Math.min(newCaretPosition.y, editor.getHeight());
                    newCaretPosition.x = magicPosition.x;
                    int newOffset = editor.viewToModel(newCaretPosition);
                    editor.beginNavigation();
                    try {
                        editor.setCaretPosition(newOffset);
                    }
                    finally {
                        editor.endNavigation();
                    }
                    ScrollLineDownAction.setMagicCaretPosition(editor, newCaretPosition);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
    }

    public static class ScrollPageUpAction
    extends BasicAction {
        public ScrollPageUpAction() {
            super("scroll-page-up");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Rectangle visibleRect = ScrollPageUpAction.getVisibleRect(editor);
            int fontHeight = ScrollPageUpAction.getFontHeight(editor);
            int visibleRows = visibleRect.height / fontHeight;
            int scrollHeight = visibleRows * fontHeight;
            visibleRect.y -= scrollHeight;
            visibleRect.y = Math.max(0, visibleRect.y);
            editor.scrollRectToVisible(visibleRect);
        }
    }

    public static class ScrollPageDownAction
    extends BasicAction {
        public ScrollPageDownAction() {
            super("scroll-page-down");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            Rectangle visibleRect = ScrollPageDownAction.getVisibleRect(editor);
            int fontHeight = ScrollPageDownAction.getFontHeight(editor);
            int visibleRows = visibleRect.height / fontHeight;
            int scrollHeight = visibleRows * fontHeight;
            visibleRect.y += scrollHeight;
            int editorHeight = editor.getHeight();
            if (visibleRect.y + visibleRect.height > editorHeight) {
                visibleRect.y = editorHeight - visibleRect.height;
            }
            editor.scrollRectToVisible(visibleRect);
        }
    }

    public static class EmacsSetMarkAction
    extends EmacsAction {
        public EmacsSetMarkAction() {
            super("emacs-set-mark");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            EmacsSetMarkAction.setMark(editor, offset);
            EmacsSetMarkAction.showMarkSetMessage(editor);
        }
    }

    public static class EmacsExchangePointMarkAction
    extends EmacsAction {
        public EmacsExchangePointMarkAction() {
            super("emacs-exchange-point-mark");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int markOffset = EmacsExchangePointMarkAction.getMark(editor);
            if (markOffset == -1) {
                EmacsExchangePointMarkAction.showMarkNotSetMessage(editor);
                EmacsExchangePointMarkAction.beep(editor);
                return;
            }
            int offset = editor.getCaretPosition();
            EmacsExchangePointMarkAction.setMark(editor, offset);
            editor.beginNavigation();
            try {
                editor.setCaretPositionCenter(markOffset);
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static class EmacsBeginAction
    extends EmacsAction {
        public EmacsBeginAction() {
            super("emacs-caret-begin");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            EmacsBeginAction.setMark(editor, offset);
            EmacsBeginAction.showMarkSetMessage(editor);
            editor.beginNavigation();
            try {
                editor.setCaretPosition(0);
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static class EmacsEndAction
    extends EmacsAction {
        public EmacsEndAction() {
            super("emacs-caret-end");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int offset = editor.getCaretPosition();
            EmacsEndAction.setMark(editor, offset);
            EmacsEndAction.showMarkSetMessage(editor);
            int length = document.getLength();
            editor.beginNavigation();
            try {
                editor.setCaretPosition(length);
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static class EmacsMarkBufferAction
    extends EmacsAction {
        public EmacsMarkBufferAction() {
            super("emacs-mark-whole-buffer");
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            int endOffset = document.getLength();
            EmacsMarkBufferAction.setMark(editor, endOffset);
            EmacsMarkBufferAction.showMarkSetMessage(editor);
            editor.beginNavigation();
            try {
                editor.setCaretPosition(0);
            }
            finally {
                editor.endNavigation();
            }
        }
    }

    public static abstract class EmacsKillTypeAction
    extends EmacsWriteAction {
        private static EmacsAction.Tracker tracker;

        public EmacsKillTypeAction(String actionName) {
            super(actionName);
            if (tracker == null) {
                tracker = new EmacsAction.Tracker();
            }
        }

        protected abstract boolean killPerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3, boolean var4);

        public final void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            boolean wasKill = this.wasLastActionKill(editor);
            boolean killWasPerformed = this.killPerformed(event, editor, document, wasKill);
            if (killWasPerformed) {
                tracker.trackEditor(editor);
            }
        }

        private final boolean wasLastActionKill(BasicEditorPane editor) {
            int offset;
            BasicAction lastAction = this.getLastAction(editor);
            return lastAction != null && lastAction instanceof EmacsKillTypeAction && tracker.matchesEditor(editor, offset = editor.getCaretPosition());
        }
    }

    public static class EmacsKillWordAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;

        public EmacsKillWordAction() {
            super("emacs-kill-word");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_KILL_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        protected boolean killPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document, boolean lastActionWasKill) {
            block12: {
                int offset = editor.getCaretPosition();
                if (offset == document.getLength()) {
                    return false;
                }
                int killEnd = Utilities.getNextWordEnd(document, offset);
                try {
                    int killLength = killEnd - offset;
                    String killText = document.getText(offset, killLength);
                    if (lastActionWasKill) {
                        EmacsKillWordAction.appendKillRing(killText);
                    } else {
                        EmacsKillWordAction.addKillRing(killText);
                    }
                    EmacsKillWordAction.makeEditable(editor);
                    if (EmacsKillWordAction.isEditable(editor, true)) {
                        editor.beginEdit(editDescriptor);
                        try {
                            editor.unselect();
                            document.remove(offset, killLength);
                            break block12;
                        }
                        finally {
                            editor.endEdit();
                        }
                    }
                    EmacsKillWordAction.showReadOnlyMessage(editor);
                    EmacsKillWordAction.beep(editor);
                    editor.beginNavigation();
                    try {
                        editor.setCaretPosition(killEnd);
                    }
                    finally {
                        editor.endNavigation();
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public static class EmacsBackwardKillWordAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;

        public EmacsBackwardKillWordAction() {
            super("emacs-backward-kill-word");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_BACKWARD_KILL_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        protected boolean killPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document, boolean lastActionWasKill) {
            block12: {
                int offset = editor.getCaretPosition();
                if (offset == 0) {
                    return false;
                }
                int killStart = Utilities.getPreviousWordStart(document, offset);
                try {
                    int killLength = offset - killStart;
                    String killText = document.getText(killStart, killLength);
                    if (lastActionWasKill) {
                        EmacsBackwardKillWordAction.prependKillRing(killText);
                    } else {
                        EmacsBackwardKillWordAction.addKillRing(killText);
                    }
                    EmacsBackwardKillWordAction.makeEditable(editor);
                    if (EmacsBackwardKillWordAction.isEditable(editor, true)) {
                        editor.beginEdit(editDescriptor);
                        try {
                            editor.unselect();
                            document.remove(killStart, killLength);
                            break block12;
                        }
                        finally {
                            editor.endEdit();
                        }
                    }
                    EmacsBackwardKillWordAction.showReadOnlyMessage(editor);
                    EmacsBackwardKillWordAction.beep(editor);
                    editor.beginNavigation();
                    try {
                        editor.setCaretPosition(killStart);
                    }
                    finally {
                        editor.endNavigation();
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public static class EmacsKillLineAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;

        public EmacsKillLineAction() {
            super("emacs-kill-line");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_KILL_LINE");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        protected boolean killPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document, boolean lastActionWasKill) {
            block13: {
                int offset = editor.getCaretPosition();
                if (offset == document.getLength()) {
                    EmacsKillLineAction.showEndBufferMessage(editor);
                    EmacsKillLineAction.beep(editor);
                    return false;
                }
                int killEnd = Utilities.getRowEnd(document, offset);
                if (offset == killEnd) {
                    ++killEnd;
                }
                try {
                    int killLength = killEnd - offset;
                    String killText = document.getText(offset, killLength);
                    if (lastActionWasKill) {
                        EmacsKillLineAction.appendKillRing(killText);
                    } else {
                        EmacsKillLineAction.addKillRing(killText);
                    }
                    EmacsKillLineAction.makeEditable(editor);
                    if (EmacsKillLineAction.isEditable(editor, true)) {
                        editor.beginEdit(editDescriptor);
                        try {
                            editor.unselect();
                            document.remove(offset, killLength);
                            break block13;
                        }
                        finally {
                            editor.endEdit();
                        }
                    }
                    EmacsKillLineAction.showReadOnlyMessage(editor);
                    EmacsKillLineAction.beep(editor);
                    editor.beginNavigation();
                    try {
                        editor.setCaretPosition(killEnd);
                    }
                    finally {
                        editor.endNavigation();
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public static class EmacsKillRegionAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;
        private boolean doSave;

        public EmacsKillRegionAction(String actionName, boolean save) {
            super(actionName);
            this.doSave = save;
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_KILL_REGION");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        protected boolean killPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document, boolean lastActionWasKill) {
            block10: {
                int markOffset = EmacsKillRegionAction.getMark(editor);
                if (markOffset == -1) {
                    EmacsKillRegionAction.showMarkNotSetMessage(editor);
                    EmacsKillRegionAction.beep(editor);
                    return false;
                }
                int offset = editor.getCaretPosition();
                if (markOffset == offset) {
                    return false;
                }
                try {
                    int killStart = Math.min(markOffset, offset);
                    int killEnd = Math.max(markOffset, offset);
                    int killLength = killEnd - killStart;
                    String killText = document.getText(killStart, killLength);
                    if (lastActionWasKill) {
                        EmacsKillRegionAction.appendKillRing(killText);
                    } else {
                        EmacsKillRegionAction.addKillRing(killText);
                    }
                    if (this.doSave) break block10;
                    EmacsKillRegionAction.makeEditable(editor);
                    if (EmacsKillRegionAction.isEditable(editor, true)) {
                        editor.beginEdit(editDescriptor);
                        try {
                            editor.unselect();
                            document.remove(killStart, killLength);
                            break block10;
                        }
                        finally {
                            editor.endEdit();
                        }
                    }
                    EmacsKillRegionAction.showReadOnlyMessage(editor);
                    EmacsKillRegionAction.beep(editor);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return !this.doSave;
        }
    }

    public static class EmacsAppendNextKillAction
    extends EmacsKillTypeAction {
        public EmacsAppendNextKillAction() {
            super("emacs-append-next-kill");
        }

        protected boolean killPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document, boolean lastActionWasKill) {
            EmacsAppendNextKillAction.showNextKillAppendMessage(editor);
            return true;
        }
    }

    public static class EmacsYankAction
    extends EmacsWriteAction {
        private static EditDescriptor editDescriptor;
        private boolean doYank;
        private static EmacsAction.Tracker tracker;

        public EmacsYankAction(String actionName, boolean yank) {
            super(actionName);
            this.doYank = yank;
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_YANK");
                editDescriptor = new EditDescriptor(editName);
            }
            if (tracker == null) {
                tracker = new EmacsAction.Tracker();
            }
        }

        public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            EmacsYankAction.makeEditable(editor);
            if (!EmacsYankAction.isEditable(editor, true)) {
                EmacsYankAction.showReadOnlyMessage(editor);
                EmacsYankAction.beep(editor);
                return;
            }
            int offset = editor.getCaretPosition();
            if (this.doYank) {
                String yankText = EmacsYankAction.yankKillRing();
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        editor.unselect();
                        document.insertString(offset, yankText, null);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
                EmacsYankAction.setMark(editor, offset);
                EmacsYankAction.showMarkSetMessage(editor);
            } else {
                if (!this.wasLastActionYank(editor)) {
                    EmacsYankAction.showPreviousNotYankMessage(editor);
                    EmacsYankAction.beep(editor);
                    return;
                }
                int yankOffset = EmacsYankAction.getMark(editor);
                if (yankOffset > offset || yankOffset == -1) {
                    throw new IllegalStateException("yank: " + yankOffset + " offset: " + offset);
                }
                String yankText = EmacsYankAction.popKillRing();
                int length = offset - yankOffset;
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        document.remove(yankOffset, length);
                        document.insertString(yankOffset, yankText, null);
                        EmacsYankAction.setMark(editor, yankOffset);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
            tracker.trackEditor(editor);
        }

        private final boolean wasLastActionYank(BasicEditorPane editor) {
            int offset;
            BasicAction lastAction = this.getLastAction(editor);
            return lastAction != null && lastAction instanceof EmacsYankAction && tracker.matchesEditor(editor, offset = editor.getCaretPosition());
        }
    }

    public static abstract class EmacsCaseWordAction
    extends EmacsWriteAction {
        public EmacsCaseWordAction(String actionName) {
            super(actionName);
        }

        public final void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            EmacsCaseWordAction.makeEditable(editor);
            if (!EmacsCaseWordAction.isEditable(editor, true)) {
                return;
            }
            int offset = editor.getCaretPosition();
            int wordEnd = Utilities.getNextWordEnd(document, offset);
            while (offset < wordEnd) {
                TextBuffer textBuffer = document.getTextBuffer();
                char c = textBuffer.getChar(offset);
                if (Character.isLetterOrDigit(c)) break;
                ++offset;
            }
            if (wordEnd <= offset) {
                return;
            }
            EditDescriptor editDescriptor = this.getEditDescriptor();
            editor.beginEdit(editDescriptor);
            try {
                try {
                    editor.unselect();
                    int wordLength = wordEnd - offset;
                    String wordText = document.getText(offset, wordLength);
                    String replaceText = this.performModification(wordText);
                    document.remove(offset, wordLength);
                    document.insertString(offset, replaceText, null);
                    editor.setCaretPosition(wordEnd);
                }
                catch (BadLocationException e) {}
            }
            finally {
                editor.endEdit();
            }
        }

        public abstract String performModification(String var1);

        public abstract EditDescriptor getEditDescriptor();
    }

    public static final class EmacsUpcaseWordAction
    extends EmacsCaseWordAction {
        private static EditDescriptor editDescriptor;

        public EmacsUpcaseWordAction() {
            super("emacs-upcase-word");
        }

        public String performModification(String wordText) {
            return wordText.toUpperCase();
        }

        public EditDescriptor getEditDescriptor() {
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_UPCASE_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
            return editDescriptor;
        }
    }

    public static final class EmacsDowncaseWordAction
    extends EmacsCaseWordAction {
        private static EditDescriptor editDescriptor;

        public EmacsDowncaseWordAction() {
            super("emacs-downcase-word");
        }

        public String performModification(String wordText) {
            return wordText.toLowerCase();
        }

        public EditDescriptor getEditDescriptor() {
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DOWNCASE_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
            return editDescriptor;
        }
    }

    public static final class EmacsCapitalizeWordAction
    extends EmacsCaseWordAction {
        private static EditDescriptor editDescriptor;

        public EmacsCapitalizeWordAction() {
            super("emacs-capitalize-word");
        }

        public String performModification(String wordText) {
            int length = wordText.length();
            int wordStart = 0;
            while (wordStart < length) {
                char c = wordText.charAt(wordStart);
                if (!Character.isWhitespace(c)) break;
                ++wordStart;
            }
            String replaceText = wordText;
            if (wordStart < length) {
                String initialText = wordText.substring(0, wordStart);
                String capitalText = wordText.substring(wordStart, wordStart + 1);
                String trailingText = wordText.substring(wordStart + 1);
                replaceText = initialText + capitalText.toUpperCase() + trailingText.toLowerCase();
            }
            return replaceText;
        }

        public EditDescriptor getEditDescriptor() {
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_CAPITALIZE_WORD");
                editDescriptor = new EditDescriptor(editName);
            }
            return editDescriptor;
        }
    }

    public static final class EmacsCaseRegionAction
    extends EmacsWriteAction {
        private boolean doUpcase;
        private static EditDescriptor upperDescriptor;
        private static EditDescriptor lowerDescriptor;

        public EmacsCaseRegionAction(String actionName, boolean doUpcase) {
            super(actionName);
            this.doUpcase = doUpcase;
            if (upperDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String upperName = resources.getString("UNDO_UPCASE_REGION");
                upperDescriptor = new EditDescriptor(upperName);
                String lowerName = resources.getString("UNDO_DOWNCASE_REGION");
                lowerDescriptor = new EditDescriptor(lowerName);
            }
        }

        public final void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            EmacsCaseRegionAction.makeEditable(editor);
            if (!EmacsCaseRegionAction.isEditable(editor, true)) {
                return;
            }
            int markOffset = EmacsCaseRegionAction.getMark(editor);
            if (markOffset == -1) {
                EmacsCaseRegionAction.showMarkNotSetMessage(editor);
                EmacsCaseRegionAction.beep(editor);
                return;
            }
            int currentOffset = editor.getCaretPosition();
            if (currentOffset == markOffset) {
                return;
            }
            EditDescriptor editDescriptor = this.doUpcase ? upperDescriptor : lowerDescriptor;
            editor.beginEdit(editDescriptor);
            try {
                try {
                    String replaceText;
                    editor.unselect();
                    int regionStart = Math.min(currentOffset, markOffset);
                    int regionEnd = Math.max(currentOffset, markOffset);
                    int regionLength = regionEnd - regionStart;
                    String regionText = document.getText(regionStart, regionLength);
                    String string = replaceText = this.doUpcase ? regionText.toUpperCase() : regionText.toLowerCase();
                    if (!regionText.equals(replaceText)) {
                        document.remove(regionStart, regionLength);
                        document.insertString(regionStart, replaceText, null);
                    }
                    editor.setCaretPosition(currentOffset);
                    EmacsCaseRegionAction.setMark(editor, markOffset);
                }
                catch (BadLocationException e) {}
            }
            finally {
                editor.endEdit();
            }
        }
    }

    public static final class EmacsDeleteHorizontalSpaceAction
    extends EmacsWriteAction {
        private static EditDescriptor editDescriptor;

        public EmacsDeleteHorizontalSpaceAction() {
            super("emacs-delete-horizontal-space");
            if (editDescriptor == null) {
                BundleHelper resources = EditorProperties.getEditorBundle();
                String editName = resources.getString("UNDO_DELETE_HORIZONTAL_SPACE");
                editDescriptor = new EditDescriptor(editName);
            }
        }

        public final void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
            EmacsDeleteHorizontalSpaceAction.makeEditable(editor);
            if (!EmacsDeleteHorizontalSpaceAction.isEditable(editor, true)) {
                return;
            }
            int currentOffset = editor.getCaretPosition();
            int bufferLength = document.getLength();
            int spaceEnd = currentOffset;
            TextBuffer buffer = document.getTextBuffer();
            while (spaceEnd < bufferLength) {
                char c = buffer.getChar(spaceEnd);
                if (c != ' ' && c != '\t') break;
                ++spaceEnd;
            }
            int spaceStart = currentOffset;
            while (spaceStart > 0) {
                char c = buffer.getChar(spaceStart - 1);
                if (c != ' ' && c != '\t') break;
                --spaceStart;
            }
            if (spaceStart != spaceEnd) {
                editor.beginEdit(editDescriptor);
                try {
                    try {
                        editor.unselect();
                        int lengthToRemove = spaceEnd - spaceStart;
                        document.remove(spaceStart, lengthToRemove);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    editor.endEdit();
                }
            }
        }
    }
}

