/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;

public class DndUtils {
    public static final DataFlavor FLAVOR_TRIGGER_EVENT = TransferUtils.createLocalJvmFlavor(InputEvent.class);

    public static void addTriggerEvent(AugmentableTransferable trans, InputEvent event) {
        trans.augment(TransferUtils.createDataInfo(FLAVOR_TRIGGER_EVENT, event, 0.0f, null));
    }

    public static InputEvent getTriggerEvent(Transferable trans) {
        return (InputEvent)TransferUtils.getDataIfAvailable(trans, FLAVOR_TRIGGER_EVENT, InputEvent.class);
    }

    public static Transferable getTransferable(DropTargetEvent event) {
        DropTargetDropEvent evil = event instanceof DropTargetDropEvent ? (DropTargetDropEvent)event : new DropTargetDropEvent(event.getDropTargetContext(), new Point(0, 0), 1, 1);
        Transferable data = evil.getTransferable();
        if (data == null) {
            throw new IllegalStateException("null transferable for " + event);
        }
        ExtendedTransferable et = ExtendedTransferable.getExtendedTransferable(data);
        if (et != null) {
            DataFlavor[] flavors = data.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (!et.isDataFlavorSupported(flavors[i])) {
                    return data;
                }
                ++i;
            }
            return et;
        }
        return data;
    }

    public static boolean isDataFlavorSupported(DropTargetEvent event, DataFlavor flavor) {
        if (event instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)event).isDataFlavorSupported(flavor);
        }
        if (event instanceof DropTargetDropEvent) {
            return ((DropTargetDropEvent)event).isDataFlavorSupported(flavor);
        }
        return false;
    }

    private DndUtils() {
    }
}

