/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.DialogUtil;

public class ProgressMonitor {
    private JProgressBar _myBar;
    private JLabel _noteLabel;
    private Component _parentComponent;
    private String _note;
    private Object _message;
    private long _T0;
    private int _millisToDecideToPopup;
    private int _millisToPopup;
    private int _min;
    private int _max;
    private int _v;
    private int _lastDisp;
    private int _reportDelta;
    private JEWTDialog _dialog;
    private String _title;
    private Component _detailContent;
    private boolean _barVisible;
    private boolean _indeterminate;
    private boolean _cancellable;

    public ProgressMonitor(Component parentComponent, String title, Object message, String note, int min, int max) {
        this._min = min;
        this._max = max;
        this._parentComponent = parentComponent;
        this._title = title;
        this._barVisible = true;
        this._reportDelta = (this._max - this._min) / 100;
        if (this._reportDelta < 1) {
            this._reportDelta = 1;
        }
        this._v = this._min;
        this._message = message;
        this._note = note;
        this._cancellable = true;
        this._T0 = System.currentTimeMillis();
    }

    public ProgressMonitor(Component parentComponent, String title, String message, String note, int min, int max) {
        this(parentComponent, title, (Object)message, note, min, max);
    }

    public ProgressMonitor(Component parentComponent, String title, int min, int max) {
        this(parentComponent, title, "", "", min, max);
    }

    public void setProgress(int nv) {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot update progress monitor from the AWT event thread.").printStackTrace();
        }
        if (this._indeterminate || this._max <= this._min) {
            this.display();
            return;
        }
        this._v = nv;
        if (nv >= this._max) {
            this.close();
        } else if (nv >= this._lastDisp + this._reportDelta) {
            this._lastDisp = nv;
            if (this._myBar != null) {
                this._myBar.setValue(nv);
            } else {
                int predictedCompletionTime;
                long T = System.currentTimeMillis();
                long dT = (int)(T - this._T0);
                if (dT >= (long)this._millisToDecideToPopup && (predictedCompletionTime = nv > this._min ? (int)(dT * (long)(this._max - this._min) / (long)(nv - this._min)) : this._millisToPopup) >= this._millisToPopup) {
                    this.display();
                }
            }
        }
    }

    public void close() {
        if (this._dialog != null) {
            this.hideDialogLater((Dialog)this._dialog);
            this._dialog = null;
        }
        if (this._myBar != null) {
            this._myBar = null;
        }
        if (this._noteLabel != null) {
            this._noteLabel = null;
        }
    }

    public int getMinimum() {
        return this._min;
    }

    public void setMinimum(int m) {
        this._min = m;
    }

    public int getMaximum() {
        return this._max;
    }

    public void setMaximum(int m) {
        this._max = m;
    }

    public boolean isCanceled() {
        return this._dialog != null && this._dialog.isCancelled();
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this._millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this._millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this._millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this._millisToPopup;
    }

    public void setNote(String note) {
        this._note = note;
        if (this._noteLabel != null) {
            this._noteLabel.setText(note);
        }
    }

    public void setMessage(String message) {
        if (this._message instanceof JLabel) {
            ((JLabel)this._message).setText(message);
        }
    }

    public String getNote() {
        return this._note;
    }

    public void setDetailContent(Component detailContent) {
        this._detailContent = detailContent;
    }

    public Component getDetailContent() {
        return this._detailContent;
    }

    public void setBarVisible(boolean barVisible) {
        this._barVisible = barVisible;
    }

    public boolean isBarVisible() {
        return this._barVisible;
    }

    public void setIndeterminate(boolean indeterminate) {
        this._indeterminate = indeterminate;
    }

    public boolean isIndeterminate() {
        return this._indeterminate;
    }

    public void setCancellable(boolean cancellable) {
        this._cancellable = cancellable;
    }

    public boolean isCancellable() {
        return this._cancellable;
    }

    public void display() {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot display progress monitor from the AWT event thread.").printStackTrace();
        }
        if (this._dialog != null) {
            return;
        }
        this._dialog = this.createDialog();
        this.showDialogLater((Dialog)this._dialog);
    }

    private ProgressDialog createDialog() {
        ProgressDialog dialog = this.createDialogImpl();
        dialog.setContent(this.createDialogContent());
        dialog.setDetailContent(this._detailContent);
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setLocationRelativeTo(this._parentComponent);
        return dialog;
    }

    private ProgressDialog createDialogImpl() {
        Frame f;
        int buttons = 0;
        if (this._cancellable) {
            buttons |= 2;
        }
        if (this._detailContent != null) {
            buttons |= 0x10;
        }
        ProgressDialog dialog = null;
        Dialog d = DialogUtil.getAncestorDialog(this._parentComponent);
        if (d != null) {
            dialog = new ProgressDialog(d, this._title, buttons, null);
        }
        if (dialog == null && (f = DialogUtil.getAncestorFrame(this._parentComponent)) != null) {
            dialog = new ProgressDialog(f, this._title, buttons, null);
        }
        if (dialog == null) {
            throw new IllegalStateException();
        }
        return dialog;
    }

    private Component createDialogContent() {
        this._myBar = new JProgressBar();
        this._myBar.setIndeterminate(this._indeterminate || this._max <= this._min);
        this._myBar.setMinimum(this._min);
        this._myBar.setMaximum(this._max);
        this._myBar.setValue(this._v);
        if (this._note != null) {
            this._noteLabel = new JLabel(this._note);
        }
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        Component messageComponent = this._message instanceof Component ? (Component)this._message : new JLabel(this._message.toString());
        this._message = messageComponent;
        content.add(messageComponent, constraints);
        if (this._barVisible) {
            ++constraints.gridy;
            content.add((Component)this._myBar, constraints);
        }
        if (this._noteLabel != null) {
            ++constraints.gridy;
            content.add((Component)this._noteLabel, constraints);
        }
        ++constraints.gridy;
        content.add(Box.createHorizontalStrut(300), constraints);
        return content;
    }

    private void showDialogLater(Dialog d) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue.invokeLater(new 1(this, d));
    }

    private void hideDialogLater(Dialog d) {
        if (EventQueue.isDispatchThread()) {
            d.hide();
            WindowUtils.unregisterWindow((Window)d);
            d.dispose();
            return;
        }
        EventQueue.invokeLater(new 2(this, d));
    }

    static void mav$hideDialogLater(ProgressMonitor progressMonitor, Dialog dialog) {
        progressMonitor.hideDialogLater(dialog);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Dialog v$d;
        final /* synthetic */ ProgressMonitor this$0;

        public final void run() {
            WindowUtils.registerWindow((Window)this.v$d);
            this.v$d.show();
        }

        public 1(ProgressMonitor progressMonitor, Dialog dialog) {
            this.v$d = dialog;
            this.this$0 = progressMonitor;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Dialog v$d;
        final /* synthetic */ ProgressMonitor this$0;

        public final void run() {
            ProgressMonitor.mav$hideDialogLater(this.this$0, this.v$d);
        }

        public 2(ProgressMonitor progressMonitor, Dialog dialog) {
            this.v$d = dialog;
            this.this$0 = progressMonitor;
        }
    }

    private static class ProgressDialog
    extends DetailDialog {
        private boolean _cancelled;
        private JButton _cancelButton;

        private ProgressDialog(Dialog dialog, String title, int buttonMask) {
            super(dialog, title, ProgressDialog.adjustButtonMask(buttonMask));
            this.initializeDialog(buttonMask);
        }

        private ProgressDialog(Frame frame, String title, int buttonMask) {
            super(frame, title, ProgressDialog.adjustButtonMask(buttonMask));
            this.initializeDialog(buttonMask);
        }

        public boolean isCancelled() {
            return this._cancelled;
        }

        protected void dismissDialog(boolean cancelled) {
        }

        private void initializeDialog(int buttonMask) {
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            if ((buttonMask & 2) <= 0) {
                return;
            }
            this._cancelButton = new JButton((String)UIManager.get("OptionPane.cancelButtonText"));
            this.addCustomButton(this._cancelButton);
            this._cancelButton.addActionListener(new 1());
        }

        private JButton getCancelButton() {
            return this._cancelButton;
        }

        private static int adjustButtonMask(int buttonMask) {
            return (buttonMask & 2) > 0 ? buttonMask ^ 2 : buttonMask;
        }

        ProgressDialog(Dialog dialog, String string, int n, 1 var4_4) {
            this(dialog, string, n);
        }

        ProgressDialog(Frame frame, String string, int n, 1 var4_4) {
            this(frame, string, n);
        }

        static void wa$_cancelled(ProgressDialog progressDialog, boolean bl) {
            progressDialog._cancelled = bl;
        }

        static JButton mav$getCancelButton(ProgressDialog progressDialog) {
            return progressDialog.getCancelButton();
        }

        final class 1
        implements ActionListener {
            public final void actionPerformed(ActionEvent e) {
                ProgressDialog.wa$_cancelled(ProgressDialog.this, true);
                ProgressDialog.mav$getCancelButton(ProgressDialog.this).setEnabled(false);
            }
        }
    }
}

