/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import oracle.javatools.dialogs.ExceptionDialog;

public class MessageDialogPersistence {
    private Map _settings;
    private static final String PERSISTENCE_FILE = ".oracle_javatools_msgdlg.properties";

    private Map getSettings() {
        if (this._settings == null) {
            try {
                this._settings = this.loadSettings();
            }
            catch (IOException ioe) {
                this.handleError(ioe);
                this._settings = Collections.EMPTY_MAP;
            }
        }
        return this._settings;
    }

    public final boolean isHidden(String messageDialogId) {
        String setting = String.valueOf(this.getSettings().get(messageDialogId));
        return Boolean.valueOf(setting);
    }

    public final void setHidden(String messageDialogId, boolean isHidden) {
        Map settings = this.getSettings();
        settings.put(messageDialogId, String.valueOf(isHidden));
        this.safeSave(settings);
    }

    public final Boolean getConfirmed(String messageDialogId) {
        String setting = (String)this.getSettings().get(messageDialogId);
        return setting != null ? Boolean.valueOf(setting) : null;
    }

    public final void setConfirmed(String messageDialogId, Boolean isConfirmed) {
        Map settings = this.getSettings();
        if (isConfirmed == null) {
            settings.remove(messageDialogId);
        } else {
            String setting = isConfirmed.toString();
            settings.put(messageDialogId, setting);
        }
        this.safeSave(settings);
    }

    final void clearSettings() {
        this._settings = new Properties();
        this.safeSave(this._settings);
    }

    private void safeSave(Map settings) {
        try {
            this.saveSettings(settings);
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
    }

    protected Map loadSettings() throws IOException {
        File persistenceFile = new File(this.getUserDirectory(), PERSISTENCE_FILE);
        if (!persistenceFile.exists()) {
            return new Properties();
        }
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(persistenceFile);
        p.load(fis);
        ((InputStream)fis).close();
        return p;
    }

    protected void saveSettings(Map settings) throws IOException {
        if (settings == Collections.EMPTY_MAP) {
            return;
        }
        File persistenceFile = new File(this.getUserDirectory(), PERSISTENCE_FILE);
        PrintWriter w = new PrintWriter(new FileWriter(persistenceFile));
        if (settings instanceof Properties) {
            ((Properties)settings).list(w);
        } else {
            Properties p = new Properties();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Object keyObject = e.getKey();
                Object valueObject = e.getValue();
                p.setProperty(String.valueOf(keyObject), String.valueOf(valueObject));
            }
            p.list(w);
        }
        w.close();
    }

    protected File getUserDirectory() {
        return new File(System.getProperty("user.home"));
    }

    protected void handleError(Exception e) {
        ExceptionDialog.showExceptionDialog(null, e);
    }
}

