/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.datatransfer.TransferableBackedTransferDataInfo;

final class SimpleAugmentableTransferable
extends AugmentableTransferable {
    private int _modCount;
    private String _shortDesc;
    private String _mediumDesc;
    private final HashMap _map;
    private final ArrayList _sortedFlavorList;
    private final Comparator _comparator;
    private static final float _RANK_DELTA_WHEN_ADDING_TRANSFERABLE = 1.0E-4f;
    private static final float _DEFAULT_INITIAL_RANK_WHEN_ADDING_TRANSFERABLE = 0.5f;

    public SimpleAugmentableTransferable() {
        this.$init$();
    }

    public SimpleAugmentableTransferable(Transferable base) {
        this.$init$();
        if (base instanceof AugmentableTransferable) {
            throw new IllegalStateException("tried to create proxying transferable from already augmentable one: " + base);
        }
        this._augmentWithTransferable(base, false);
    }

    public static AugmentableTransferable createPrefetchedCopy(Transferable original) {
        SimpleAugmentableTransferable ret = new SimpleAugmentableTransferable();
        ret._augmentWithTransferable(original, true);
        return ret;
    }

    public AugmentableTransferable getCopy() {
        return new SimpleAugmentableTransferable(this);
    }

    public List getDataInfos(DataFlavor flavor) {
        List ret = (List)this._map.get(flavor);
        if (ret != null) {
            return ret;
        }
        return Collections.EMPTY_LIST;
    }

    public String getShortDescription() {
        return this._shortDesc;
    }

    public String getMediumDescription() {
        return this._mediumDesc;
    }

    public void augment(TransferDataInfo info) {
        this._augmentHelper(info);
        this._sortFlavorList();
        ++this._modCount;
    }

    public int getModificationCount() {
        return this._modCount;
    }

    public Iterator getOrderedFlavorIterator() {
        return this._sortedFlavorList.iterator();
    }

    protected int getFlavorCount() {
        return this._map.size();
    }

    protected boolean isFlavorSupported(DataFlavor flavor) {
        return this._map.containsKey(flavor);
    }

    private List _findOrCreateList(DataFlavor flavor) {
        LinkedList ret = this._findList(flavor);
        if (ret == null) {
            ret = new LinkedList();
            this._map.put(flavor, ret);
            this._sortedFlavorList.add(flavor);
        }
        return ret;
    }

    private void _sortFlavorList() {
        Collections.sort(this._sortedFlavorList, this._comparator);
    }

    private void _augmentHelper(TransferDataInfo info) {
        Object md;
        Object md2;
        List list = this._findOrCreateList(info.getDataFlavor());
        if (list.isEmpty()) {
            list.add(info);
        } else {
            ListIterator<TransferDataInfo> itor = list.listIterator();
            while (itor.hasNext()) {
                TransferDataInfo other = (TransferDataInfo)itor.next();
                if (other.compareTo(info) <= 0) continue;
                itor.previous();
                break;
            }
            itor.add(info);
        }
        if (this._shortDesc == null && (md2 = info.getMetadata(TransferDataInfo.METADATA_SHORT_DESCRIPTION)) != null) {
            this._shortDesc = md2.toString();
        }
        if (this._mediumDesc == null && (md = info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION)) != null) {
            this._mediumDesc = md.toString();
        }
    }

    private void _augmentWithTransferable(Transferable base, boolean eager) {
        if (!eager && base instanceof ExtendedTransferable) {
            this._augmentWithExtendedTransferable((ExtendedTransferable)base);
        } else {
            this._augmentWithRegularTransferable(base, eager);
        }
        this._sortFlavorList();
        ++this._modCount;
    }

    private void _augmentWithRegularTransferable(Transferable trans, boolean eager) {
        DataFlavor[] flavors = trans.getTransferDataFlavors();
        boolean allowEarlyFetch = trans.isDataFlavorSupported(TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER);
        float rank = 0.5f;
        int i = 0;
        while (i < flavors.length) {
            DataFlavor flavor = flavors[i];
            if (flavor != TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER) {
                TransferDataInfo info = eager ? TransferUtils.createDataInfo(flavor, TransferUtils.getDataIfAvailable(trans, flavor), rank, null) : new TransferableBackedTransferDataInfo(trans, flavor, rank, allowEarlyFetch);
                this._augmentHelper(info);
                rank -= 1.0E-4f;
            }
            ++i;
        }
    }

    private void _augmentWithExtendedTransferable(ExtendedTransferable base) {
        Iterator flavorItor = base.getOrderedFlavorIterator();
        while (flavorItor.hasNext()) {
            List infos = base.getDataInfos((DataFlavor)flavorItor.next());
            Iterator infoItor = infos.iterator();
            while (infoItor.hasNext()) {
                this._augmentHelper((TransferDataInfo)infoItor.next());
            }
        }
    }

    private List _findList(DataFlavor flavor) {
        return (List)this._map.get(flavor);
    }

    private SimpleAugmentableTransferable(SimpleAugmentableTransferable source) {
        this.$init$();
        this._modCount = source._modCount;
        this._shortDesc = source._shortDesc;
        this._mediumDesc = source._mediumDesc;
        this._map.putAll(source._map);
        this._sortedFlavorList.addAll(source._sortedFlavorList);
    }

    private void $init$() {
        this._modCount = 0;
        this._shortDesc = null;
        this._mediumDesc = null;
        this._map = new HashMap(17);
        this._sortedFlavorList = new ArrayList();
        this._comparator = new FlavorByHighestRankComparator(null);
    }

    static List mav$_findList(SimpleAugmentableTransferable simpleAugmentableTransferable, DataFlavor dataFlavor) {
        return simpleAugmentableTransferable._findList(dataFlavor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FlavorByHighestRankComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = FlavorByHighestRankComparator.class.desiredAssertionStatus() ^ true;
        }

        public int compare(Object o1, Object o2) {
            DataFlavor f1 = (DataFlavor)o1;
            DataFlavor f2 = (DataFlavor)o2;
            List list1 = SimpleAugmentableTransferable.mav$_findList(SimpleAugmentableTransferable.this, f1);
            List list2 = SimpleAugmentableTransferable.mav$_findList(SimpleAugmentableTransferable.this, f2);
            if (!$assertionsDisabled && list1 == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && list2 == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && list1.isEmpty()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && list2.isEmpty()) {
                throw new AssertionError();
            }
            Comparable first1 = (Comparable)list1.get(0);
            Comparable first2 = (Comparable)list2.get(0);
            return first1.compareTo(first2);
        }

        private FlavorByHighestRankComparator() {
        }

        FlavorByHighestRankComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

