/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;

public abstract class ExtendedTransferable
implements Transferable {
    public static final DataFlavor FLAVOR_EXTENDED_TRANSFERABLE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ExtendedTransferable getExtendedTransferable(Transferable trans) {
        Object ret = TransferUtils.getDataIfAvailable(trans, FLAVOR_EXTENDED_TRANSFERABLE);
        if (ret instanceof ExtendedTransferable) {
            return (ExtendedTransferable)ret;
        }
        return null;
    }

    static {
        $assertionsDisabled = ExtendedTransferable.class.desiredAssertionStatus() ^ true;
        FLAVOR_EXTENDED_TRANSFERABLE = TransferUtils.createLocalJvmFlavor(ExtendedTransferable.class);
    }

    public final DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] ret = new DataFlavor[this.getFlavorCount() + 1];
        int i = 0;
        Iterator flavorItor = this.getOrderedFlavorIterator();
        while (flavorItor.hasNext()) {
            ret[i] = (DataFlavor)flavorItor.next();
            ++i;
        }
        if (!$assertionsDisabled && i != ret.length - 1) {
            throw new AssertionError();
        }
        ret[i] = FLAVOR_EXTENDED_TRANSFERABLE;
        return ret;
    }

    public final boolean isDataFlavorSupported(DataFlavor flavor) {
        return FLAVOR_EXTENDED_TRANSFERABLE.equals(flavor) || this.isFlavorSupported(flavor);
    }

    public final Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (FLAVOR_EXTENDED_TRANSFERABLE.equals(flavor)) {
            return this;
        }
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        List dataInfos = this.getDataInfos(flavor);
        if (dataInfos.isEmpty()) {
            return null;
        }
        TransferDataInfo info = (TransferDataInfo)dataInfos.get(0);
        return info.getData(FetchMode.STANDARD, false);
    }

    public final List getSupportedFlavors(Set callerWants) {
        ArrayList ret = new ArrayList(callerWants.size());
        Iterator supportedItor = this.getOrderedFlavorIterator();
        while (supportedItor.hasNext()) {
            Object flavor = supportedItor.next();
            if (!callerWants.contains(flavor)) continue;
            ret.add(flavor);
        }
        return ret;
    }

    public final TransferDataInfo getHighestRankedData() {
        Iterator flavorItor = this.getOrderedFlavorIterator();
        while (flavorItor.hasNext()) {
            DataFlavor flavor = (DataFlavor)flavorItor.next();
            TransferDataInfo ret = this.getHighestRankedData(flavor);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public final TransferDataInfo getHighestRankedData(DataFlavor flavor) {
        List data = this.getDataInfos(flavor);
        if (data.size() > 0) {
            return (TransferDataInfo)data.get(0);
        }
        return null;
    }

    public abstract List getDataInfos(DataFlavor var1);

    public abstract Iterator getOrderedFlavorIterator();

    public abstract String getShortDescription();

    public abstract String getMediumDescription();

    protected abstract int getFlavorCount();

    protected abstract boolean isFlavorSupported(DataFlavor var1);
}

