/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

public class FileSystemFieldInsightProvider
implements FieldInsightProvider {
    private static final boolean IS_FS_CASE_SENSITIVE;
    private boolean m_onlyDirectories;

    static {
        File f1 = new File("A");
        File f2 = new File("a");
        IS_FS_CASE_SENSITIVE = f1.equals(f2) ^ true;
    }

    public FileSystemFieldInsightProvider(boolean onlyDirectories) {
        this.m_onlyDirectories = onlyDirectories;
    }

    public FileSystemFieldInsightProvider() {
        this(false);
    }

    public void setOnlyDirectories(boolean onlyDirectories) {
        this.m_onlyDirectories = onlyDirectories;
    }

    public boolean isOnlyDirectories() {
        return this.m_onlyDirectories;
    }

    protected boolean isValid(File f) {
        if (this.m_onlyDirectories) {
            return f.isDirectory();
        }
        return true;
    }

    public ListCellRenderer getCellRenderer() {
        return new 1();
    }

    private FileFragment getFileFragment(Document doc, int pos) {
        try {
            String docSoFar = doc.getText(0, pos);
            int startFragment = -1;
            String fragment = null;
            int i = pos - 1;
            while (i >= 0) {
                int startFile;
                String path;
                File f;
                char c = docSoFar.charAt(i);
                if (startFragment == -1 && File.separatorChar == c) {
                    startFragment = i + 1;
                    fragment = docSoFar.substring(startFragment);
                }
                if (startFragment != -1 && (Character.isWhitespace(c) || i == 0 || doc.getLength() == 1) && (f = new File(path = docSoFar.substring(startFile = i == 0 || doc.getLength() == 1 ? 0 : i + 1, startFragment))).exists() && this.isValid(f)) {
                    FileFragment frag = new FileFragment(null);
                    frag.baseFile = f;
                    frag.fragment = fragment;
                    frag.startFile = startFile;
                    frag.startFragment = startFragment;
                    FileFragment fileFragment = frag;
                    return fileFragment;
                }
                --i;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return null;
    }

    public boolean handlesInsight(Document doc, int pos) {
        return this.getFileFragment(doc, pos) != null;
    }

    public Object[] getInsightData(Document doc, int pos) {
        FileFragment frag = this.getFileFragment(doc, pos);
        if (frag != null) {
            File f;
            Object[] files;
            boolean haveFragment;
            ArrayList<File> al = new ArrayList<File>();
            boolean bl = haveFragment = frag.fragment != null && frag.fragment.length() > 0;
            if (this.m_onlyDirectories && !haveFragment) {
                al.add(frag.baseFile);
            }
            if ((files = File.separator.equals((f = frag.baseFile).getName()) ? File.listRoots() : f.listFiles()) == null || files.length == 0) {
                return null;
            }
            int i = 0;
            while (i < files.length) {
                File thisFile = files[i];
                if (this.isValid(thisFile)) {
                    if (frag.fragment == null || frag.fragment.length() == 0) {
                        al.add(thisFile);
                    } else {
                        String partial;
                        String fileName;
                        if (!IS_FS_CASE_SENSITIVE) {
                            fileName = thisFile.getName().toUpperCase();
                            partial = frag.fragment.toUpperCase();
                        } else {
                            fileName = thisFile.getName();
                            partial = frag.fragment;
                        }
                        if (fileName.startsWith(partial)) {
                            al.add(thisFile);
                        }
                    }
                }
                ++i;
            }
            files = new File[al.size()];
            al.toArray(files);
            return files;
        }
        return null;
    }

    public void completeInsight(Document doc, int pos, Object insightObject) {
        File f = (File)insightObject;
        if (f == null) {
            return;
        }
        String completeFilename = f.getPath();
        if (f.isDirectory()) {
            completeFilename = completeFilename + File.separatorChar;
        }
        try {
            FileFragment frag = this.getFileFragment(doc, pos);
            doc.remove(frag.startFile, pos - frag.startFile);
            doc.insertString(frag.startFile, completeFilename, null);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public boolean isAutoPopupChar(char c) {
        return c == File.separatorChar;
    }

    final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            String newText;
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof File && ((File)value).isDirectory() && (newText = String.valueOf(value)).charAt(newText.length() - 1) != File.separatorChar) {
                this.setText(newText + File.separator);
            }
            return c;
        }
    }

    private class FileFragment {
        File baseFile;
        String fragment;
        int startFile;
        int startFragment;

        private FileFragment() {
        }

        FileFragment(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

