/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextComponent;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.highlight.ZigZagLinePainter;

public class CompletionTextField
extends JTextField
implements CompletionTextComponent {
    private static final int VALIDATION_TIMER_DELAY_MS = 500;
    private final CompletionPopupHandler _popupHandler;
    private final Timer _validationTimer;
    private boolean _textIsValid;
    private final UnderlinePainter _underlinePainter;

    private void $init$() {
        this._validationTimer = new Timer(500, new TimerListener(null));
        this._textIsValid = true;
        this._underlinePainter = new ZigZagLinePainter(2, 1);
    }

    public CompletionTextField() {
        this.$init$();
        this._popupHandler = new CompletionPopupHandler(this);
        this.initializeValidation();
    }

    public CompletionTextField(CompletionPopupHandler popupHandler) {
        this.$init$();
        this._popupHandler = popupHandler;
        this.initializeValidation();
    }

    private void initializeValidation() {
        this._validationTimer.setRepeats(false);
        this.getDocument().addDocumentListener(new 1());
    }

    public final CompletionPopupHandler getPopupHandler() {
        return this._popupHandler;
    }

    public void removeNotify() {
        super.removeNotify();
        this._popupHandler.setInsightVisible(false);
    }

    public final void setText(String text) {
        this._popupHandler.acquireInsightLock();
        try {
            super.setText(text);
        }
        finally {
            this._popupHandler.yieldInsightLock();
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled() && this.isEditable() && !this._textIsValid) {
            Insets insets = this.getInsets();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int[][] ranges = this.getInvalidCharacterRanges();
            int i = 0;
            while (i < ranges.length) {
                int end;
                int[] range = ranges[i];
                int start = range[0];
                if (start >= 0 && start <= this.getText().length() - 1 && (end = range[1]) >= 0 && end >= start && end <= this.getText().length() - 1) {
                    try {
                        Rectangle startRect = this.modelToView(start);
                        int left = startRect.x;
                        Rectangle endRect = this.modelToView(end + 1);
                        int width = endRect.x + endRect.width - startRect.x;
                        int yTop = insets.top;
                        int yBaseline = fm.getHeight();
                        int descent = fm.getDescent();
                        this._underlinePainter.paintUnderline(g, Color.RED, left, width, yTop, yBaseline, descent);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    protected int[][] getInvalidCharacterRanges() {
        return new int[][]{{0, this.getText().length() - 1}};
    }

    protected boolean isTextValid() {
        return true;
    }

    public final void setAlignWithField(boolean isAlignWithField) {
        this._popupHandler.setAlignWithField(isAlignWithField);
    }

    public final void setWidthOfField(boolean isWidthOfField) {
        this._popupHandler.setWidthOfField(isWidthOfField);
    }

    public final void setInsightVisible(boolean isVisible) {
        this._popupHandler.setInsightVisible(isVisible);
    }

    static void wa$_textIsValid(CompletionTextField completionTextField, boolean bl) {
        completionTextField._textIsValid = bl;
    }

    static Timer ra$_validationTimer(CompletionTextField completionTextField) {
        return completionTextField._validationTimer;
    }

    final class 1
    implements DocumentListener {
        private void update() {
            CompletionTextField.ra$_validationTimer(CompletionTextField.this).restart();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }
    }

    private class TimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CompletionTextField.wa$_textIsValid(CompletionTextField.this, CompletionTextField.this.isTextValid());
            CompletionTextField.this.repaint();
        }

        private TimerListener() {
        }

        TimerListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

