/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.SwingUtilities;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.GraphicsUtils;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.util.SwingUtils;

public class SplashScreen {
    private static SplashWindow splash;
    protected static Image splashImage;
    private static final int progressOffsetStart = 20;
    private static int progressOffset;
    private static int msgCounter;
    private static int lastPos;
    private static final int defaultTotalMsgs = 153;
    private static int totalSqares;
    private static int totalMsgs;

    protected SplashScreen() {
    }

    public static void create(String filename) {
        if (splashImage != null || !SplashScreen._fileExists(filename)) {
            return;
        }
        splashImage = Toolkit.getDefaultToolkit().createImage(filename);
        SplashScreen._create();
    }

    public static void create(String filename, int nsteps) {
        SplashScreen.create(filename);
        totalMsgs = nsteps;
    }

    public static int getCurrentMsgCounter() {
        return msgCounter;
    }

    public static void setVisible(boolean visible) {
        if (splash != null) {
            splash.setVisible(visible);
        }
    }

    public static void dismiss() {
        if (splash != null) {
            try {
                new 1(true).run();
            }
            catch (ClosureException closureException) {
                // empty catch block
            }
        }
    }

    public static void log(String msg) {
        int pos;
        if (splash == null) {
            return;
        }
        Graphics g = splash.getGraphics();
        if (g != null && lastPos != (pos = ++msgCounter * totalSqares / totalMsgs) && progressOffset - 20 < 360) {
            lastPos = pos;
            int offset = progressOffset;
            progressOffset += 10;
            if (SwingUtilities.isEventDispatchThread()) {
                if (splash != null) {
                    g.setColor(Color.lightGray);
                    g.drawRect(19, 173, 360, 9);
                    g.setColor(Color.red);
                    int i = 20;
                    while (i <= offset) {
                        g.fillRect(i, 174, 9, 8);
                        i += 10;
                    }
                }
            } else {
                SwingUtilities.invokeLater(new 2(g, offset));
            }
        }
    }

    protected static void _create() {
        if (splashImage == null || splash != null) {
            return;
        }
        try {
            splash = new SplashWindow(SwingUtils.getStartupWindow());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SplashScreen.dismiss();
        }
    }

    private static synchronized void _dismiss() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
        if (splashImage != null) {
            splashImage.flush();
            splashImage = null;
        }
    }

    private static boolean _fileExists(String filename) {
        return new File(filename).exists();
    }

    static {
        progressOffset = 20;
        msgCounter = 0;
        lastPos = 0;
        totalSqares = 36;
        totalMsgs = 153;
    }

    static int ra$totalMsgs() {
        return totalMsgs;
    }

    static void wa$msgCounter(int n) {
        msgCounter = n;
    }

    static SplashWindow ra$splash() {
        return splash;
    }

    static void maS$_dismiss() {
        SplashScreen._dismiss();
    }

    static final class 1
    extends SwingClosure {
        public void runImpl() {
            SplashScreen.maS$_dismiss();
        }

        public 1(boolean bl) {
            super(bl);
        }
    }

    static final class 2
    implements Runnable {
        private final /* synthetic */ Graphics v$g;
        private final /* synthetic */ int v$offset;

        public void run() {
            if (SplashScreen.ra$splash() != null) {
                this.v$g.setColor(Color.lightGray);
                this.v$g.drawRect(19, 173, 360, 9);
                this.v$g.setColor(Color.red);
                int i = 20;
                while (i <= this.v$offset) {
                    this.v$g.fillRect(i, 174, 9, 8);
                    i += 10;
                }
            }
        }

        public 2(Graphics graphics, int n) {
            this.v$offset = n;
            this.v$g = graphics;
        }
    }

    private static final class SplashWindow
    extends Window
    implements MouseListener,
    Runnable {
        boolean waitForImage;

        private void $init$() {
            this.waitForImage = true;
        }

        public void run() {
            this.setVisible(true);
            this.waitForImage = false;
            Graphics g = this.getGraphics();
            this.paint(g);
        }

        public SplashWindow(Frame frame) {
            super(frame);
            this.$init$();
            Toolkit.getDefaultToolkit().prepareImage(splashImage, -1, -1, this);
            this.addMouseListener(this);
            while (this.waitForImage) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void paint(Graphics g) {
            g.drawImage(splashImage, 0, 0, this);
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x20) != 0) {
                this.setSize(width, height);
                GraphicsUtils.centerWindowOnScreen((Window)this);
                this.toFront();
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return super.imageUpdate(img, infoflags, x, y, width, height);
        }

        public void mouseReleased(MouseEvent e) {
            this.removeMouseListener(this);
            SplashScreen.dismiss();
            SplashScreen.wa$msgCounter(SplashScreen.ra$totalMsgs());
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }
    }
}

