/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;

public class PropertyChangeAdapter
implements PropertyChangeListener {
    private static ReferenceQueue _queue = new ReferenceQueue();
    private WeakAbstractButton _adapteeReference;

    public PropertyChangeAdapter(AbstractButton adaptee, Action action) {
        PropertyChangeAdapter.clearQueue();
        this._adapteeReference = new WeakAbstractButton(adaptee, action, this, _queue);
    }

    private static void clearQueue() {
        Reference ref;
        while ((ref = _queue.poll()) != null) {
            WeakAbstractButton weakAbstractButton = (WeakAbstractButton)ref;
            weakAbstractButton.clearReference();
        }
    }

    private boolean isDead() {
        return this._adapteeReference.get() == null;
    }

    protected AbstractButton getAdaptee() {
        return (AbstractButton)this._adapteeReference.get();
    }

    public final void propertyChange(PropertyChangeEvent e) {
        PropertyChangeAdapter.clearQueue();
        if (!this.isDead()) {
            this._propertyChange(e);
        }
    }

    protected void _propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("Name")) {
            this.nameChanged(e);
        } else if (propertyName.equals("ShortDescription")) {
            this.tooltipChanged(e);
        } else if (propertyName.equals("enabled")) {
            this.enabledChanged(e);
        } else if (propertyName.equals("SmallIcon")) {
            this.smallIconChanged(e);
        } else if (propertyName.equals("MnemonicKey")) {
            this.mnemonicChanged(e);
        } else if (propertyName.equals("State")) {
            this.stateChanged(e);
        }
    }

    protected void nameChanged(PropertyChangeEvent e) {
        AbstractButton adaptee = this.getAdaptee();
        adaptee.setText((String)e.getNewValue());
        adaptee.repaint();
    }

    protected void tooltipChanged(PropertyChangeEvent e) {
        this.getAdaptee().setToolTipText((String)e.getNewValue());
    }

    protected void enabledChanged(PropertyChangeEvent e) {
        Boolean enabledState = (Boolean)e.getNewValue();
        AbstractButton adaptee = this.getAdaptee();
        adaptee.setEnabled(enabledState);
        adaptee.repaint();
    }

    protected void smallIconChanged(PropertyChangeEvent e) {
        AbstractButton adaptee = this.getAdaptee();
        adaptee.setIcon((Icon)e.getNewValue());
        adaptee.invalidate();
        adaptee.repaint();
    }

    protected void mnemonicChanged(PropertyChangeEvent e) {
        Integer mnemonic = (Integer)e.getNewValue();
        AbstractButton adaptee = this.getAdaptee();
        adaptee.setMnemonic(mnemonic);
        adaptee.invalidate();
        adaptee.repaint();
    }

    protected void stateChanged(PropertyChangeEvent e) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeakAbstractButton
    extends WeakReference {
        protected PropertyChangeListener _listener;
        protected Action _action;

        public WeakAbstractButton(AbstractButton abstractButton, Action action, PropertyChangeListener listener, ReferenceQueue q) {
            super(abstractButton, q);
            this._action = action;
            this._listener = listener;
        }

        protected void clearReference() {
            this._action.removePropertyChangeListener(this._listener);
        }
    }
}

