/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressPanel
extends JPanel {
    private final JLabel _label;
    private final JButton _cancelButton;
    private String _cancelingText;

    private void $init$() {
        this._cancelingText = " ";
        this.setLayout(new ProgressLayout(null));
        this.setBackground((Color)UIManager.get("window"));
        this.setForeground((Color)UIManager.get("textText"));
        this._label = new JLabel(" ");
        this._label.setFocusable(true);
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setPreferredSize(new Dimension(250, jProgressBar.getPreferredSize().height));
        this._cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
        this._cancelButton.addActionListener(new 1(this, jProgressBar));
        this.add((Component)this._label, "Left");
        this.add((Component)jProgressBar, "Center");
        this.add((Component)this._cancelButton, "Right");
    }

    public String getCancelingText() {
        return this._cancelingText;
    }

    public void setCancelingText(String cancelingText) {
        this._cancelingText = cancelingText;
    }

    public String getLabelText() {
        return this._label.getText();
    }

    public void setLabelText(String text) {
        this._label.setText(text);
    }

    public void addCancelActionListener(ActionListener l) {
        this._cancelButton.addActionListener(l);
    }

    public void removeCancelActionListener(ActionListener l) {
        this._cancelButton.removeActionListener(l);
    }

    public void setCancelEnabled(boolean enabled) {
        this._cancelButton.setEnabled(enabled);
    }

    public boolean isCancelEnabled() {
        return this._cancelButton.isEnabled();
    }

    public static void main(String[] argv) {
        ProgressPanel p = new ProgressPanel();
        p.setLabelText("Compare in progress...");
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.add((Component)p, "Center");
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setVisible(true);
    }

    public ProgressPanel() {
        this.$init$();
    }

    static JButton ra$_cancelButton(ProgressPanel progressPanel) {
        return progressPanel._cancelButton;
    }

    static JLabel ra$_label(ProgressPanel progressPanel) {
        return progressPanel._label;
    }

    static String ra$_cancelingText(ProgressPanel progressPanel) {
        return progressPanel._cancelingText;
    }

    final class 1
    implements ActionListener {
        private final /* synthetic */ JProgressBar v$progressComponent;
        final /* synthetic */ ProgressPanel this$0;

        public void actionPerformed(ActionEvent ae) {
            this.v$progressComponent.setIndeterminate(false);
            ProgressPanel.ra$_cancelButton(this.this$0).setEnabled(false);
            ProgressPanel.ra$_label(this.this$0).setText(ProgressPanel.ra$_cancelingText(this.this$0));
        }

        public 1(ProgressPanel progressPanel, JProgressBar jProgressBar) {
            this.v$progressComponent = jProgressBar;
            this.this$0 = progressPanel;
        }
    }

    private class ProgressLayout
    implements LayoutManager2 {
        private static final int VERTICAL_SPACING = 5;
        private static final String CENTER = "Center";
        private static final String LEFT = "Left";
        private static final String RIGHT = "Right";
        private final Map<Component, String> _components;

        private void $init$() {
            this._components = new LinkedHashMap<Component, String>();
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.computeTotalDimensions(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Dimension d = this.computeTotalDimensions(parent);
            int maxWidth = d.width;
            int totalHeight = d.height;
            int currentHeight = 0;
            Component[] componentArray = parent.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component c = componentArray[n];
                currentHeight += 5;
                currentHeight += parent.getInsets().top;
                d = c.getPreferredSize();
                int x = 0;
                String position = this._components.get(c);
                if (position == null || position.equals(CENTER)) {
                    c.setSize(maxWidth, d.height);
                    x = (parent.getWidth() - maxWidth) / 2;
                }
                if (position != null && position.equals(LEFT)) {
                    c.setSize(d);
                    x = (parent.getWidth() - maxWidth) / 2;
                }
                if (position != null && position.equals(RIGHT)) {
                    c.setSize(d);
                    x = (parent.getWidth() - maxWidth) / 2 + (maxWidth - d.width);
                }
                c.setLocation(x, (parent.getHeight() - totalHeight) / 2 + currentHeight);
                currentHeight += d.height;
                currentHeight += parent.getInsets().bottom;
                ++n;
            }
        }

        private Dimension computeTotalDimensions(Container parent) {
            Component[] components;
            int maxWidth = 0;
            int totalHeight = 0;
            Component[] componentArray = components = parent.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component c = componentArray[n];
                totalHeight += 5;
                totalHeight += parent.getInsets().top;
                Dimension d = c.getPreferredSize();
                totalHeight += d.height;
                totalHeight += parent.getInsets().bottom;
                maxWidth = Math.max(maxWidth, d.width);
                ++n;
            }
            return new Dimension(maxWidth, totalHeight);
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            this._components.put(comp, (String)constraints);
        }

        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        private ProgressLayout() {
            this.$init$();
        }

        ProgressLayout(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

