/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.concurrent;

import java.util.ArrayList;
import oracle.javatools.concurrent.Task;

final class Scheduler {
    private static final int DEFAULT_MAX_TOTAL_THREADS = 4;
    private static final Scheduler _INSTANCE = new Scheduler(4, 10000);
    private static final boolean DEBUG_VERBOSE = false;
    private ArrayList _taskList;
    private int _threadCount;
    private final ArrayList _threadList;
    private int _threadId;
    private final int _idleTimeout;
    private int _idleCount;
    private int _maxThreads;

    private void $init$() {
        this._taskList = new ArrayList();
        this._threadCount = 0;
        this._threadList = new ArrayList();
        this._threadId = 1;
        this._idleCount = 0;
    }

    private Scheduler(int maxThreads, int idleTimeout) {
        this.$init$();
        this._maxThreads = maxThreads;
        this._idleTimeout = idleTimeout;
    }

    static Scheduler getInstance() {
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Task task) {
        ArrayList arrayList = this._taskList;
        synchronized (arrayList) {
            this._taskList.add(task);
            int i = this._threadCount - 1;
            while (i >= 0) {
                Thread t = (Thread)this._threadList.get(i);
                if (!t.isAlive()) {
                    this._threadList.remove(t);
                    --this._threadCount;
                }
                --i;
            }
            if (this._idleCount > 0) {
                this._taskList.notify();
            } else if (this._threadCount < this._maxThreads) {
                TRunner r = new TRunner(this._threadId++);
                Thread t = new Thread(r);
                t.setPriority(1);
                this._threadList.add(t);
                ++this._threadCount;
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTask(Task task) {
        ArrayList arrayList = this._threadList;
        synchronized (arrayList) {
            this._threadList.remove(task);
        }
        task.cancel(null);
    }

    static ArrayList ra$_taskList(Scheduler scheduler) {
        return scheduler._taskList;
    }

    static int ra$_idleCount(Scheduler scheduler) {
        return scheduler._idleCount;
    }

    static void wa$_idleCount(Scheduler scheduler, int n) {
        scheduler._idleCount = n;
    }

    static int ra$_idleTimeout(Scheduler scheduler) {
        return scheduler._idleTimeout;
    }

    static int ra$_threadCount(Scheduler scheduler) {
        return scheduler._threadCount;
    }

    static void wa$_threadCount(Scheduler scheduler, int n) {
        scheduler._threadCount = n;
    }

    static ArrayList ra$_threadList(Scheduler scheduler) {
        return scheduler._threadList;
    }

    private class TRunner
    implements Runnable {
        private final int _threadId;

        TRunner(int threadId) {
            this._threadId = threadId;
        }

        private void printVerbose(String message) {
            String name = Thread.currentThread().getName();
            System.out.print("TRunner(" + name + ") ");
            System.out.println(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Task task = null;
                ArrayList arrayList = Scheduler.ra$_taskList(Scheduler.this);
                synchronized (arrayList) {
                    if (Scheduler.ra$_taskList(Scheduler.this).size() == 0) {
                        try {
                            Scheduler scheduler = Scheduler.this;
                            Scheduler.wa$_idleCount(scheduler, Scheduler.ra$_idleCount(scheduler) + 1);
                            Scheduler.ra$_taskList(Scheduler.this).wait(Scheduler.ra$_idleTimeout(Scheduler.this));
                            Scheduler scheduler2 = Scheduler.this;
                            Scheduler.wa$_idleCount(scheduler2, Scheduler.ra$_idleCount(scheduler2) - 1);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Scheduler.ra$_taskList(Scheduler.this).size() == 0) {
                            Scheduler scheduler = Scheduler.this;
                            Scheduler.wa$_threadCount(scheduler, Scheduler.ra$_threadCount(scheduler) - 1);
                            Scheduler.ra$_threadList(Scheduler.this).remove(Thread.currentThread());
                            return;
                        }
                    }
                    task = (Task)Scheduler.ra$_taskList(Scheduler.this).remove(0);
                }
                Thread.currentThread().setName("TaskThread-" + this._threadId + ": " + task.getName());
                task.run(null);
                Thread.currentThread().setName("TaskThread-" + this._threadId + ": idle");
            }
        }
    }
}

