/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.concurrent;

import java.net.URL;

public abstract class IntentionLock {
    private IntentionLock() {
    }

    public static IntentionLock newIntentionReadLock(URL resource) {
        return new IS(resource, null);
    }

    public static IntentionLock newIntentionWriteLock(URL resource) {
        return new IX(resource, null);
    }

    public static IntentionLock newIntentionCompositeLock(IntentionLock[] locks) {
        return new Group(locks, null);
    }

    public abstract boolean includes(IntentionLock var1);

    public abstract boolean isCompatible(IntentionLock var1);

    IntentionLock(1 var1_1) {
        this();
    }

    private static final class IS
    extends IntentionLock {
        private URL _resource;

        private IS(URL resource) {
            super(null);
            this._resource = resource;
        }

        public boolean includes(IntentionLock otherLock) {
            if (otherLock != null && otherLock.getClass() == IS.class) {
                IS otherIS = (IS)otherLock;
                if (otherIS._resource.equals(this._resource)) {
                    return true;
                }
            }
            return false;
        }

        public boolean isCompatible(IntentionLock otherLock) {
            if (otherLock != null) {
                Group otherGroup;
                IntentionLock[] locks;
                Class<?> otherClass = otherLock.getClass();
                if (otherClass == IS.class) {
                    return true;
                }
                if (otherClass == IX.class) {
                    IX otherIX = (IX)otherLock;
                    return IX.ra$_resource(otherIX).equals(this._resource) ^ true;
                }
                if (otherClass == Group.class && (locks = Group.mav$getLocks(otherGroup = (Group)otherLock)) != null) {
                    int n = locks.length;
                    int i = 0;
                    while (i < n) {
                        if (!this.isCompatible(locks[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            return true;
        }

        IS(URL uRL, 1 var2_2) {
            this(uRL);
        }

        static URL ra$_resource(IS iS) {
            return iS._resource;
        }

        public final class 1 {
        }
    }

    private static final class IX
    extends IntentionLock {
        private URL _resource;

        private IX(URL resource) {
            super(null);
            this._resource = resource;
        }

        public boolean includes(IntentionLock otherLock) {
            if (otherLock != null) {
                Class<?> otherClass = otherLock.getClass();
                URL resource = null;
                if (otherClass == IS.class) {
                    resource = IS.ra$_resource((IS)otherLock);
                } else if (otherClass == IX.class) {
                    resource = ((IX)otherLock)._resource;
                }
                return this._resource.equals(resource);
            }
            return false;
        }

        public boolean isCompatible(IntentionLock otherLock) {
            if (otherLock != null) {
                Group otherGroup;
                IntentionLock[] locks;
                Class<?> otherClass = otherLock.getClass();
                if (otherClass == IS.class) {
                    IS otherIS = (IS)otherLock;
                    return IS.ra$_resource(otherIS).equals(this._resource) ^ true;
                }
                if (otherClass == IX.class) {
                    IX otherIX = (IX)otherLock;
                    return otherIX._resource.equals(this._resource) ^ true;
                }
                if (otherClass == Group.class && (locks = Group.mav$getLocks(otherGroup = (Group)otherLock)) != null) {
                    int n = locks.length;
                    int i = 0;
                    while (i < n) {
                        if (!this.isCompatible(locks[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            return true;
        }

        IX(URL uRL, 1 var2_2) {
            this(uRL);
        }

        static URL ra$_resource(IX iX) {
            return iX._resource;
        }

        public final class 1 {
        }
    }

    private static final class Group
    extends IntentionLock {
        private final IntentionLock[] _locks;

        private Group(IntentionLock[] locks) {
            super(null);
            this._locks = locks;
        }

        private IntentionLock[] getLocks() {
            return this._locks;
        }

        public boolean includes(IntentionLock otherLock) {
            if (otherLock != null && this._locks != null) {
                Group otherGroup;
                IntentionLock[] otherLocks;
                Class<?> otherClass = otherLock.getClass();
                if (otherClass == IS.class || otherClass == IX.class) {
                    int n = this._locks.length;
                    int i = 0;
                    while (i < n) {
                        if (this._locks[i].includes(otherLock)) {
                            return true;
                        }
                        ++i;
                    }
                } else if (otherClass == Group.class && (otherLocks = (otherGroup = (Group)otherLock).getLocks()) != null) {
                    int n = otherLocks.length;
                    int i = 0;
                    while (i < n) {
                        if (!this.includes(otherLocks[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isCompatible(IntentionLock otherLock) {
            if (otherLock != null && this._locks != null) {
                int n = this._locks.length;
                int i = 0;
                while (i < n) {
                    if (!otherLock.isCompatible(this._locks[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        Group(IntentionLock[] intentionLockArray, 1 var2_2) {
            this(intentionLockArray);
        }

        static IntentionLock[] mav$getLocks(Group group) {
            return group.getLocks();
        }

        public final class 1 {
        }
    }

    public final class 1 {
    }
}

