/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.view.CompareViewUtil;
import oracle.javatools.compare.view.wedge.InlineCompareModel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

class InlineDiffHighlighter
implements EditorPlugin {
    private HighlightLayer _hiliteLayer;
    private final ContributorKind _contributor;
    static final String ADDITION_STYLE = "inline-character-compare-addition";
    static final String DELETION_STYLE = "inline-character-compare-deletion";
    static final String CHANGE_STYLE = "inline-character-compare-update";
    private final CompareViewBias _bias;

    public InlineDiffHighlighter(ContributorKind contributorKind, CompareViewBias bias) {
        this._contributor = contributorKind;
        this._bias = bias;
    }

    public void install(BasicEditorPane editor) {
        this._hiliteLayer = editor.createHighlightLayer();
    }

    public void deinstall(BasicEditorPane editor) {
        if (this._hiliteLayer != null) {
            editor.destroyHighlightLayer(this._hiliteLayer);
            this._hiliteLayer = null;
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
    }

    public void setModel(InlineCompareModel model, TextBuffer myBuffer) {
        Collection matchedLines = model.getMatchedLines();
        for (InlineCompareModel.MatchedLine matchedLine : matchedLines) {
            int line = matchedLine.getLine(this._contributor);
            int lineOffset = myBuffer.getLineMap().getLineStartOffset(line);
            SequenceCompareDifference[] diffs = matchedLine.getDifferences();
            int j = 0;
            while (j < diffs.length) {
                SequenceCompareDifference block = diffs[j];
                int start = lineOffset + block.getStart(this._contributor);
                int end = lineOffset + block.getStart(this._contributor) + block.getLength(this._contributor);
                HighlightStyle style = this.getStyle(block);
                if (style != null) {
                    this._hiliteLayer.addHighlight(style, start, end);
                }
                ++j;
            }
        }
    }

    private HighlightStyle getStyle(SequenceCompareDifference diff) {
        HighlightRegistry hr = EditorProperties.getProperties().getHighlightRegistry();
        if (diff.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            return hr.lookupStyle(CHANGE_STYLE);
        }
        if (CompareViewUtil.isRemoval((BaseCompareDifference)diff, ContributorKind.FIRST, ContributorKind.SECOND, this._bias)) {
            return hr.lookupStyle(DELETION_STYLE);
        }
        if (CompareViewUtil.isAddition((BaseCompareDifference)diff, ContributorKind.FIRST, ContributorKind.SECOND, this._bias)) {
            return hr.lookupStyle(ADDITION_STYLE);
        }
        return null;
    }
}

