/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.ColorConstants;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.compare.view.CompareViewUtil;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.DiffGutter;
import oracle.javatools.compare.view.EditableView;
import oracle.javatools.compare.view.NavigableConflictsView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.SplitPanel;
import oracle.javatools.compare.view.SplitPanelLayout;
import oracle.javatools.compare.view.SplitPanelView;
import oracle.javatools.compare.view.StatusView;
import oracle.javatools.compare.view.ToolTipView;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.compare.view.ViewMemento;
import oracle.javatools.resource.CompareResource;
import oracle.javatools.util.BundleLoader;

public abstract class BaseCompareView
implements CompareView,
NavigableView,
NavigableConflictsView,
StatusView,
EditableView,
ToolTipView,
SplitPanelView,
CustomHorizontalScrollView {
    protected static final int OVERVIEW_WIDTH;
    public static final String GUI_VERTICAL_SCROLLBAR = "verticalScrollbar";
    public static final String GUI_VERTICAL_SPACER = "verticalSpacer";
    private CompareMode _compareMode;
    private CompareModel _compareModel;
    private final Collection _positionChangeListeners;
    private final Collection _statusListeners;
    protected JScrollPane _leftScrollPane;
    protected JScrollPane _rightScrollPane;
    protected JScrollPane _centerScrollPane;
    private final JScrollBar _verticalScrollbar;
    private final CardLayout _verticalScrollCardLayout;
    private final JPanel _verticalScrollPanel;
    protected final JLabel _leftTitle;
    protected final JLabel _rightTitle;
    protected final JLabel _centerTitle;
    private boolean _editLocked;
    private final Collection _undoableEditListeners;
    private CompareToolTipProvider _toolTipProvider;
    private SplitPanel _panel;
    protected DiffGutter _leftDiffGutter;
    protected DiffGutter _rightDiffGutter;
    private JPanel _horizontalScrollPanel;
    private CompareViewBias _compareViewBias;
    private static final int EDIT_UPDATE_DELAY = 500;
    private ContributorListener _contributorListener;
    static final /* synthetic */ boolean $assertionsDisabled;
    private Icon _editRemoveIcon;
    private Icon _editLeftIcon;
    private Icon _editRightIcon;

    static {
        $assertionsDisabled = BaseCompareView.class.desiredAssertionStatus() ^ true;
        OVERVIEW_WIDTH = new JScrollBar((int)1).getPreferredSize().width;
        new ColorConstants();
    }

    private void $init$() {
        this._positionChangeListeners = new ArrayList();
        this._statusListeners = new ArrayList();
        this._verticalScrollbar = new JScrollBar(1);
        this._leftTitle = new JLabel();
        this._rightTitle = new JLabel();
        this._centerTitle = new JLabel();
        this._editLocked = false;
        this._undoableEditListeners = new ArrayList();
        this._editRemoveIcon = null;
        this._editLeftIcon = null;
        this._editRightIcon = null;
    }

    protected CompareViewBias getBias() {
        return this._compareViewBias;
    }

    protected boolean isAddition(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor) {
        return CompareViewUtil.isAddition(difference, firstContributor, secondContributor, this._compareViewBias);
    }

    protected boolean isRemoval(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor) {
        return CompareViewUtil.isRemoval(difference, firstContributor, secondContributor, this._compareViewBias);
    }

    protected JScrollPane getLeftScrollPane() {
        return this._leftScrollPane;
    }

    protected void setLeftScrollPane(JScrollPane leftScrollPane) {
        this._leftScrollPane = leftScrollPane;
    }

    protected JScrollPane getRightScrollPane() {
        return this._rightScrollPane;
    }

    protected void setRightScrollPane(JScrollPane rightScrollPane) {
        this._rightScrollPane = rightScrollPane;
    }

    protected JScrollPane getCenterScrollPane() {
        return this._centerScrollPane;
    }

    protected void setCenterScrollPane(JScrollPane centerScrollPane) {
        this._centerScrollPane = centerScrollPane;
    }

    protected JScrollBar getVerticalScrollBar() {
        return this._verticalScrollbar;
    }

    protected CardLayout getVerticalScrollCardLayout() {
        return this._verticalScrollCardLayout;
    }

    protected JPanel getVerticalScrollPanel() {
        return this._verticalScrollPanel;
    }

    protected JLabel getLeftTitle() {
        return this._leftTitle;
    }

    protected JLabel getRightTitle() {
        return this._rightTitle;
    }

    protected JLabel getCenterTitle() {
        return this._centerTitle;
    }

    protected boolean isEditLocked() {
        return this._editLocked;
    }

    protected void setEditLocked(boolean editLocked) {
        this._editLocked = editLocked;
    }

    protected Collection getUndoableEditListeners() {
        return this._undoableEditListeners;
    }

    public DiffGutter getLeftDiffGutter() {
        return this._leftDiffGutter;
    }

    protected void setLeftDiffGutter(DiffGutter leftDiffGutter) {
        this._leftDiffGutter = leftDiffGutter;
    }

    protected DiffGutter getRightDiffGutter() {
        return this._rightDiffGutter;
    }

    protected void setRightDiffGutter(DiffGutter rightDiffGutter) {
        this._rightDiffGutter = rightDiffGutter;
    }

    public static final int calculateRightEditorInset() {
        int inset = 0;
        inset += OVERVIEW_WIDTH;
        return inset += new JScrollBar((int)1).getPreferredSize().width;
    }

    public void setModel(CompareModel compareModel) {
        if (this.getCompareModel() != null) {
            if (this._contributorListener == null) {
                return;
            }
            this.getContributor(ContributorKind.FIRST).removePropertyChangeListener((PropertyChangeListener)this._contributorListener);
            this.getContributor(ContributorKind.SECOND).removePropertyChangeListener((PropertyChangeListener)this._contributorListener);
            if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                this.getContributor(ContributorKind.ANCESTOR).removePropertyChangeListener((PropertyChangeListener)this._contributorListener);
            }
            this.detachContributorChangeListeners();
            this._contributorListener = null;
        }
        if (compareModel != null) {
            try {
                CompareDifference[] differences = CompareDifference.cloneDifferences((CompareDifference[])compareModel.getDifferences());
                compareModel = this.createModel(compareModel, differences);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.setCompareModel(this.createMutableModel(compareModel));
        this.initializeView(this.getCompareModel());
        if (this.getCompareModel() != null) {
            this._contributorListener = new ContributorListener(null);
            this.getContributor(ContributorKind.FIRST).addPropertyChangeListener((PropertyChangeListener)this._contributorListener);
            this.getContributor(ContributorKind.SECOND).addPropertyChangeListener((PropertyChangeListener)this._contributorListener);
            if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                this.getContributor(ContributorKind.ANCESTOR).addPropertyChangeListener((PropertyChangeListener)this._contributorListener);
            }
            this.attachContributorChangeListeners();
            this.updateTitles();
            this.repaintOverview();
        }
        this.fireStatusChanged();
    }

    protected void attachContributorChangeListeners() {
        if (this.getContributor(ContributorKind.FIRST) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.FIRST)).addChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getContributor(ContributorKind.SECOND) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.SECOND)).addChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE && this.getContributor(ContributorKind.ANCESTOR) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.ANCESTOR)).addChangeListener((ChangeListener)this._contributorListener);
        }
        ((JComponent)this.getGUI()).addAncestorListener(this._contributorListener);
    }

    protected void detachContributorChangeListeners() {
        if (this.getContributor(ContributorKind.FIRST) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.FIRST)).removeChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getContributor(ContributorKind.SECOND) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.SECOND)).removeChangeListener((ChangeListener)this._contributorListener);
        }
        if (this.getCompareMode() == CompareMode.THREE_WAY_MERGE && this.getContributor(ContributorKind.ANCESTOR) instanceof TextCompareContributor) {
            ((TextCompareContributor)this.getContributor(ContributorKind.ANCESTOR)).removeChangeListener((ChangeListener)this._contributorListener);
        }
        ((JComponent)this.getGUI()).removeAncestorListener(this._contributorListener);
    }

    protected void initializeView(CompareModel compareModel) {
    }

    protected SplitPanel getSplitPanel() {
        if (this._panel == null) {
            this._panel = new SplitPanel();
        }
        return this._panel;
    }

    protected void setSplitPanel(SplitPanel splitPanel) {
        this._panel = splitPanel;
    }

    public Component getGUI() {
        this.getSplitPanel();
        return this._panel;
    }

    public Component getLeftOrCenterSplitter() {
        return ((SplitPanelLayout)this.getSplitPanel().getLayout()).getComponent("leftSplitTop");
    }

    public Component getRightSplitter() {
        return ((SplitPanelLayout)this.getSplitPanel().getLayout()).getComponent("centerSplitTop");
    }

    public void setSplitterLocation(Component splitter, int location) {
        this.getSplitPanel().moveSplitter(splitter, location, splitter == this.getRightSplitter());
    }

    public int getSplitterLocation(Component splitter) {
        return splitter.getLocation().x + 25;
    }

    protected BaseCompareView() {
        this(CompareMode.TWO_WAY_COMPARE);
    }

    protected BaseCompareView(CompareMode compareMode) {
        this(compareMode, CompareViewBias.RIGHT);
    }

    protected BaseCompareView(CompareMode compareMode, CompareViewBias compareViewBias) {
        this.$init$();
        this._compareMode = compareMode;
        this._compareViewBias = compareViewBias;
        this._verticalScrollbar.addAdjustmentListener(new 1());
        JPanel verticalSpacer = new JPanel();
        verticalSpacer.setBackground(UIManager.getColor("control"));
        verticalSpacer.setBorder(BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow")));
        this._verticalScrollCardLayout = new CardLayout();
        this._verticalScrollPanel = new JPanel(this._verticalScrollCardLayout);
        this._verticalScrollPanel.add((Component)this._verticalScrollbar, GUI_VERTICAL_SCROLLBAR);
        this._verticalScrollPanel.add((Component)verticalSpacer, GUI_VERTICAL_SPACER);
        Color borderColor = UIManager.getColor("controlShadow");
        CompoundBorder titleBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, borderColor), BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this._leftTitle.setBorder(titleBorder);
        this._centerTitle.setBorder(titleBorder);
        this._rightTitle.setBorder(titleBorder);
    }

    protected void updateTitles() {
        this.updateTitle(this.getCompareModel().getContributor(ContributorKind.FIRST), this.getLeftTitle());
        this.updateTitle(this.getCompareModel().getContributor(ContributorKind.SECOND), this.getRightTitle());
        this.updateTitle(this.getCompareModel().getContributor(ContributorKind.ANCESTOR), this.getCenterTitle());
    }

    private void updateTitle(CompareContributor contributor, JLabel title) {
        if (contributor == null) {
            return;
        }
        boolean isReadOnly = true;
        boolean isModified = false;
        if (contributor instanceof EditableContributor) {
            if (!this.isEditLocked()) {
                isReadOnly = ((EditableContributor)contributor).isEditable() ^ true;
            }
            isModified = ((EditableContributor)contributor).isModified();
        }
        String shortLabel = null;
        String longLabel = null;
        if (isReadOnly) {
            shortLabel = MessageFormat.format(this.getBundle().getString("TITLE_READ_ONLY"), contributor.getShortLabel());
            longLabel = MessageFormat.format(this.getBundle().getString("TOOLTIP_READ_ONLY"), contributor.getLongLabel());
        } else if (isModified) {
            shortLabel = contributor.getShortLabel();
            longLabel = MessageFormat.format(this.getBundle().getString("TOOLTIP_MODIFIED"), contributor.getLongLabel());
        } else {
            shortLabel = MessageFormat.format(this.getBundle().getString("TITLE_EDITABLE"), contributor.getShortLabel());
            longLabel = MessageFormat.format(this.getBundle().getString("TOOLTIP_EDITABLE"), contributor.getLongLabel());
        }
        title.setText(shortLabel);
        title.setToolTipText(longLabel);
        Font labelFont = UIManager.getFont("Label.font");
        if (isModified) {
            title.setFont(new Font(labelFont.getName(), 2, labelFont.getSize()));
        } else {
            title.setFont(labelFont);
        }
    }

    public CompareMode getCompareMode() {
        return this._compareMode;
    }

    protected CompareModel createMutableModel(CompareModel compareModel) {
        return compareModel;
    }

    public void addViewEditListener(ViewEditListener l) {
        this._undoableEditListeners.add(l);
    }

    public void removeViewEditListener(ViewEditListener l) {
        this._undoableEditListeners.remove(l);
    }

    protected ViewEditListener[] getViewEditListeners() {
        return this._undoableEditListeners.toArray(new ViewEditListener[0]);
    }

    protected void fireViewEditEvent(ViewEditEvent vee) {
        ViewEditListener[] l = this.getViewEditListeners();
        int i = l.length - 1;
        while (i >= 0) {
            l[i].viewEditHappened(vee);
            --i;
        }
        this.fireStatusChanged();
    }

    public void setToolTipProvider(CompareToolTipProvider toolTipProvider) {
        this._toolTipProvider = toolTipProvider;
    }

    protected CompareToolTipProvider getToolTipProvider() {
        return this._toolTipProvider;
    }

    protected void updateModel(CompareModel model) {
        this.setCompareModel(model);
        this.repaintDiffGutters();
        this.repaintOverview();
        this.updateModelImpl();
        this.fireStatusChanged();
    }

    protected void repaintDiffGutters() {
        if (this._leftDiffGutter != null) {
            this._leftDiffGutter.repaint();
        }
        if (this._rightDiffGutter != null) {
            this._rightDiffGutter.repaint();
        }
    }

    protected void repaintOverview() {
    }

    protected abstract void updateModelImpl();

    protected ViewMemento createMemento() {
        if (this.getCompareMode() != CompareMode.THREE_WAY_MERGE) {
            return null;
        }
        ViewMemento memento = new ViewMemento();
        try {
            memento.setDifferences(CompareDifference.cloneDifferences((CompareDifference[])this.getCompareModel().getDifferences()));
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return memento;
    }

    public void setMemento(ViewMemento memento) {
        if (this.getCompareMode() != CompareMode.THREE_WAY_MERGE) {
            return;
        }
        try {
            CompareDifference[] differences = CompareDifference.cloneDifferences((CompareDifference[])memento.getDifferences());
            this.updateModel(this.createModel(differences));
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
    }

    protected CompareModel createModel(CompareDifference[] differences) {
        return this.createModel(this.getCompareModel(), differences);
    }

    protected abstract CompareModel createModel(CompareModel var1, CompareDifference[] var2);

    public ResourceBundle getBundle() {
        return BundleLoader.getBundle((String)"oracle.javatools.resource.CompareResource");
    }

    protected JScrollPane createHorizontalScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view, 21, 30);
        this.initScrollPane(scrollPane);
        return scrollPane;
    }

    protected void initScrollPane(JScrollPane scrollPane) {
        scrollPane.setAutoscrolls(true);
        scrollPane.setWheelScrollingEnabled(false);
        scrollPane.setBorder(null);
        scrollPane.getHorizontalScrollBar().addAdjustmentListener(new 2());
        scrollPane.addMouseWheelListener(new 3());
    }

    protected Collection getHorizontalScrollBars() {
        ArrayList<JScrollBar> c = new ArrayList<JScrollBar>();
        if (this._leftScrollPane != null) {
            c.add(this._leftScrollPane.getHorizontalScrollBar());
        }
        if (this._rightScrollPane != null) {
            c.add(this._rightScrollPane.getHorizontalScrollBar());
        }
        if (this._centerScrollPane != null) {
            c.add(this._centerScrollPane.getHorizontalScrollBar());
        }
        return c;
    }

    public JScrollBar getVerticalScrollbar() {
        return this._verticalScrollbar;
    }

    protected void horizontalScrollTo(Object source, int value) {
        Collection scrollBars = this.getHorizontalScrollBars();
        for (JScrollBar scrollBar : scrollBars) {
            if (scrollBar == source) continue;
            scrollBar.setValue(Math.min(scrollBar.getMaximum(), value));
        }
    }

    protected abstract void verticalScrollTo(int var1);

    public CompareModel getModel() {
        return this._compareModel;
    }

    protected void setCompareModel(CompareModel compareModel) {
        this._compareModel = compareModel;
    }

    public CompareModel getCompareModel() {
        return this._compareModel;
    }

    public void addPositionListener(ChangeListener l) {
        this._positionChangeListeners.add(l);
    }

    public void removePositionListener(ChangeListener l) {
        this._positionChangeListeners.remove(l);
    }

    protected void firePositionChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        ChangeListener[] l = this._positionChangeListeners.toArray(new ChangeListener[0]);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].stateChanged(ce);
            --i;
        }
    }

    public boolean hasNavigableDifferences() {
        return this.getModel().getDifferenceCount() > 0;
    }

    public boolean hasNavigableConflicts() {
        CompareDifference[] compareDifferenceArray = this.getModel().getDifferences();
        int n = 0;
        while (n < compareDifferenceArray.length) {
            CompareDifference compareDifference = compareDifferenceArray[n];
            if (compareDifference.isConflict() && !compareDifference.isResolved()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addStatusListener(ChangeListener l) {
        this._statusListeners.add(l);
    }

    public void removeStatusListener(ChangeListener l) {
        this._statusListeners.remove(l);
    }

    protected void fireStatusChanged() {
        ChangeEvent ce = new ChangeEvent(this);
        Iterator itr = this._statusListeners.iterator();
        while (itr.hasNext()) {
            ((ChangeListener)itr.next()).stateChanged(ce);
        }
    }

    protected boolean isViewFocusOwner() {
        return true;
    }

    public Action[] getEditActions() {
        if (!this.isViewFocusOwner()) {
            return null;
        }
        ContributorKind contributor = this.getCurrentContributorKind();
        return this.getEditActions(this.getCurrentDifference(), contributor, this.getAdjacentContributorKind(contributor));
    }

    protected abstract CompareDifference getCurrentDifference();

    protected abstract ContributorKind getCurrentContributorKind();

    protected ContributorKind getAdjacentContributorKind(ContributorKind contributorKind) {
        return this.getAdjacentContributorKind(contributorKind, null);
    }

    protected ContributorKind getAdjacentContributorKind(ContributorKind contributorKind, ContributorBias bias) {
        if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
            if (contributorKind == ContributorKind.FIRST) {
                return bias == ContributorBias.LEFT ? null : ContributorKind.SECOND;
            }
            if (contributorKind == ContributorKind.SECOND) {
                return bias == ContributorBias.RIGHT ? null : ContributorKind.FIRST;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            if (contributorKind == ContributorKind.FIRST) {
                return bias == ContributorBias.LEFT ? null : ContributorKind.ANCESTOR;
            }
            if (contributorKind == ContributorKind.SECOND) {
                return bias == ContributorBias.RIGHT ? null : ContributorKind.ANCESTOR;
            }
            if (contributorKind == ContributorKind.ANCESTOR) {
                return bias == ContributorBias.RIGHT ? ContributorKind.SECOND : ContributorKind.FIRST;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return null;
    }

    protected CompareContributor getContributor(ContributorKind contributorKind) {
        return this.getCompareModel().getContributor(contributorKind);
    }

    protected void updateOnEdit() {
        try {
            CompareModel newModel = this.getCompareModel();
            if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
                newModel = CompareModelFactory.createCompareModel((CompareContributor)this.getContributor(ContributorKind.FIRST), (CompareContributor)this.getContributor(ContributorKind.SECOND), (CompareType)this.getCompareModel().getType());
            }
            this.updateModel(newModel);
        }
        catch (CompareFailedException cfe) {
            cfe.printStackTrace();
        }
    }

    protected void markResolved(CompareDifference difference) {
        ViewMemento undoMemento = this.createMemento();
        difference.setResolved(true);
        this.updateModel(this.getCompareModel());
        ViewMemento redoMemento = this.createMemento();
        this.fireViewEditEvent(new ViewEditEvent(this, 1, null, new ViewEdit(null, this.getBundle().getString("RESOLVE_ACTION_NAME"), this, undoMemento, redoMemento)));
    }

    protected void markAllResolved(CompareModel compareModel) {
        ViewMemento undoMemento = this.createMemento();
        CompareDifference[] differences = compareModel.getDifferences();
        int i = 0;
        while (i < differences.length) {
            differences[i].setResolved(true);
            ++i;
        }
        this.updateModel(this.getCompareModel());
        ViewMemento redoMemento = this.createMemento();
        this.fireViewEditEvent(new ViewEditEvent(this, 1, null, new ViewEdit(null, this.getBundle().getString("RESOLVE_ALL_ACTION_NAME"), this, undoMemento, redoMemento)));
    }

    protected Action createMarkResolvedAction(CompareDifference difference) {
        return new MarkResolvedAction(difference);
    }

    protected Action createMarkAllResolvedAction(CompareModel compareModel) {
        return new MarkAllResolvedAction(compareModel);
    }

    public boolean goToInitialDifference() {
        if (this.getCompareModel().getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this.getCompareModel().getDifferences()[0], false);
        return true;
    }

    public boolean hasPreviousDifference() {
        return this.getPreviousDifference() != null;
    }

    public boolean hasNextDifference() {
        return this.getNextDifference() != null;
    }

    public boolean goToFirstDifference() {
        if (this.getCompareModel().getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this.getCompareModel().getDifferences()[0]);
        return true;
    }

    public boolean goToLastDifference() {
        if (this.getCompareModel().getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this.getCompareModel().getDifferences()[this.getCompareModel().getDifferences().length - 1]);
        return true;
    }

    public boolean goToPreviousDifference() {
        CompareDifference block = this.getPreviousDifference();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    public boolean goToNextDifference() {
        CompareDifference block = this.getNextDifference();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    protected void goToDifference(CompareDifference block) {
        this.goToDifference(block, true);
    }

    protected abstract CompareDifference getPreviousDifference();

    protected abstract CompareDifference getNextDifference();

    protected abstract void goToDifference(CompareDifference var1, boolean var2);

    public boolean hasPreviousConflict() {
        return this.getPreviousConflict() != null;
    }

    public boolean hasNextConflict() {
        return this.getNextConflict() != null;
    }

    public boolean goToFirstConflict() {
        CompareDifference[] compareDifferenceArray = this.getCompareModel().getDifferences();
        int n = 0;
        while (n < compareDifferenceArray.length) {
            CompareDifference compareDifference = compareDifferenceArray[n];
            if (compareDifference.isConflict() && !compareDifference.isResolved()) {
                this.goToDifference(compareDifference);
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean goToLastConflict() {
        CompareDifference[] compareDifferences = this.getCompareModel().getDifferences();
        int i = compareDifferences.length - 1;
        while (i >= 0) {
            if (compareDifferences[i].isConflict() && !compareDifferences[i].isResolved()) {
                this.goToDifference(compareDifferences[i]);
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean goToPreviousConflict() {
        CompareDifference block = this.getPreviousConflict();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    public boolean goToNextConflict() {
        CompareDifference block = this.getNextConflict();
        if (block != null) {
            this.goToDifference(block);
            return true;
        }
        return false;
    }

    protected abstract CompareDifference getPreviousConflict();

    protected abstract CompareDifference getNextConflict();

    protected boolean isEditable(ContributorKind contributor) {
        return !this.isEditLocked() && this.getContributor(contributor) instanceof EditableContributor && ((EditableContributor)this.getContributor(contributor)).isEditable();
    }

    protected boolean canReadElement(CompareDifference difference, ContributorKind contributorKind) {
        return true;
    }

    protected boolean canWriteElement(CompareDifference difference, ContributorKind contributorKind) {
        return true;
    }

    protected boolean hasDefaultEditAction(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        if (difference == null || contributor == null) {
            return false;
        }
        if (((BaseCompareDifference)difference).getKind() == 0) {
            return false;
        }
        if (contributor == ContributorKind.ANCESTOR && adjacentContributor == ContributorKind.FIRST) {
            return false;
        }
        return this.isEditable(adjacentContributor) || this.isEditable(contributor);
    }

    protected Action getDefaultEditAction(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        BaseCompareDifference baseDifference = (BaseCompareDifference)difference;
        if (!this.hasDefaultEditAction(difference, contributor, adjacentContributor)) {
            return null;
        }
        if (this.canReadElement(difference, contributor) && this.canWriteElement(difference, adjacentContributor) && this.isEditable(adjacentContributor)) {
            if (baseDifference.isChange(contributor, adjacentContributor)) {
                return this.createReplaceBlockAction(baseDifference, contributor, adjacentContributor);
            }
            if (baseDifference.hasContribution(contributor) && (!baseDifference.hasContribution(adjacentContributor) || this.getCompareModel() != null && this.getCompareModel().getType() == CompareType.TEXT)) {
                return this.createInsertBlockAction(baseDifference, contributor, adjacentContributor);
            }
        }
        if (this.canWriteElement(difference, contributor) && this.isEditable(contributor) && baseDifference.hasContribution(contributor)) {
            return this.createDeleteBlockAction(baseDifference, contributor, adjacentContributor);
        }
        return null;
    }

    protected Action createReplaceBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        return new ReplaceBlockAction(difference, contributor, adjacentContributor);
    }

    protected Action createInsertBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        return new InsertBlockAction(difference, contributor, adjacentContributor);
    }

    protected Action createDeleteBlockAction(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        return new DeleteBlockAction(contributor, difference);
    }

    protected abstract void replaceBlock(BaseCompareDifference var1, ContributorKind var2, ContributorKind var3);

    protected abstract void insertBlockCopy(BaseCompareDifference var1, ContributorKind var2, ContributorKind var3);

    protected abstract void deleteBlock(BaseCompareDifference var1, ContributorKind var2);

    protected Action[] getEditActions(CompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor) {
        BaseCompareDifference baseDifference = (BaseCompareDifference)difference;
        if (baseDifference == null || baseDifference.getKind() == 0) {
            return null;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.canWriteElement(difference, contributor) && this.isEditable(contributor) && baseDifference.hasContribution(contributor)) {
            actions.add(this.createDeleteBlockAction(baseDifference, contributor, adjacentContributor));
        }
        if (this.canReadElement(difference, contributor) && this.canWriteElement(difference, adjacentContributor) && adjacentContributor != null && this.isEditable(adjacentContributor) && baseDifference.hasContribution(contributor)) {
            actions.add(null);
            if (baseDifference.isChange(contributor, adjacentContributor)) {
                actions.add(this.createReplaceBlockAction(baseDifference, contributor, adjacentContributor));
            }
            if (!baseDifference.hasContribution(adjacentContributor) || this.getCompareModel() != null && this.getCompareModel().getType() == CompareType.TEXT) {
                actions.add(this.createInsertBlockAction(baseDifference, contributor, adjacentContributor));
            }
        }
        if (actions.size() > 0 && actions.get(actions.size() - 1) == null) {
            actions.remove(actions.size() - 1);
        }
        if (adjacentContributor != null && (this.isEditable(contributor) || this.isEditable(adjacentContributor))) {
            int conflicts;
            actions.add(null);
            if (difference.isConflict() && !difference.isResolved()) {
                actions.add(this.createMarkResolvedAction(difference));
            }
            if ((conflicts = this.getCompareModel().getConflictCount()) > 0 && this.getCompareModel().getResolvedCount() < conflicts) {
                actions.add(this.createMarkAllResolvedAction(this.getCompareModel()));
            }
        }
        if (actions.size() > 0 && actions.get(actions.size() - 1) == null) {
            actions.remove(actions.size() - 1);
        }
        if (actions.size() > 0 && actions.get(0) == null) {
            actions.remove(0);
        }
        return actions.toArray(new Action[0]);
    }

    public Icon getDefaultEditActionIcon(BaseCompareDifference difference, ContributorKind contributor, ContributorKind adjacentContributor, boolean isAncestor) {
        if (!this.hasDefaultEditAction((CompareDifference)difference, contributor, adjacentContributor)) {
            return null;
        }
        if (this.canReadElement((CompareDifference)difference, contributor) && this.canWriteElement((CompareDifference)difference, adjacentContributor) && this.isEditable(adjacentContributor) && (difference.isChange(contributor, adjacentContributor) || !difference.hasContribution(adjacentContributor) || this.getCompareModel() != null && this.getCompareModel().getType() == CompareType.TEXT) && difference.hasContribution(contributor)) {
            if (isAncestor) {
                if (this._editLeftIcon == null) {
                    this._editLeftIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editright.gif"));
                }
                return this._editLeftIcon;
            }
            if (this._editRightIcon == null) {
                this._editRightIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editleft.gif"));
            }
            return this._editRightIcon;
        }
        if (this.canWriteElement((CompareDifference)difference, contributor) && this.isEditable(contributor) && difference.hasContribution(contributor)) {
            if (this._editRemoveIcon == null) {
                this._editRemoveIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editremove.gif"));
            }
            return this._editRemoveIcon;
        }
        return null;
    }

    public Component getHorizontalScrollComponent() {
        if (this._horizontalScrollPanel == null) {
            this._horizontalScrollPanel = new JPanel();
        }
        return this._horizontalScrollPanel;
    }

    public void dispose() {
        if (this.getCompareModel() != null) {
            this.detachContributorChangeListeners();
        }
    }

    static JScrollBar ra$_verticalScrollbar(BaseCompareView baseCompareView) {
        return baseCompareView._verticalScrollbar;
    }

    final class 1
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            BaseCompareView.this.verticalScrollTo(ae.getValue());
        }
    }

    final class 2
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            JScrollBar source = (JScrollBar)ae.getSource();
            BaseCompareView.this.horizontalScrollTo(source, source.getValue());
        }
    }

    final class 3
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            if (mwe.getScrollType() == 0) {
                int totalScroll = mwe.getUnitsToScroll() * BaseCompareView.ra$_verticalScrollbar(BaseCompareView.this).getUnitIncrement();
                BaseCompareView.ra$_verticalScrollbar(BaseCompareView.this).setValue(BaseCompareView.ra$_verticalScrollbar(BaseCompareView.this).getValue() + totalScroll);
            }
        }
    }

    public abstract class PositionListener
    implements FocusListener {
        private final Timer _positionTimer;

        private void $init$() {
            this._positionTimer = new Timer(250, new 1());
            this._positionTimer.setRepeats(false);
        }

        public void focusGained(FocusEvent e) {
            this.resetTimer();
        }

        public void focusLost(FocusEvent e) {
            this.resetTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resetTimer() {
            PositionListener positionListener = this;
            synchronized (positionListener) {
                this._positionTimer.restart();
            }
        }

        public PositionListener() {
            this.$init$();
        }

        static Timer ra$_positionTimer(PositionListener positionListener) {
            return positionListener._positionTimer;
        }

        final class 1
        implements ActionListener {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                PositionListener positionListener = PositionListener.this;
                synchronized (positionListener) {
                    BaseCompareView.this.firePositionChanged();
                    PositionListener.ra$_positionTimer(PositionListener.this).stop();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ContributorBias
    extends Enum<ContributorBias> {
        private static final /* synthetic */ ContributorBias[] $v;
        public static final /* enum */ ContributorBias LEFT;
        public static final /* enum */ ContributorBias RIGHT;

        public static ContributorBias valueOf(String string) {
            return Enum.valueOf(ContributorBias.class, string);
        }

        public static final ContributorBias[] values() {
            return (ContributorBias[])$v.clone();
        }

        static {
            ContributorBias[] contributorBiasArray = new ContributorBias[2];
            contributorBiasArray[1] = RIGHT = new ContributorBias("RIGHT", 1);
            contributorBiasArray[0] = LEFT = new ContributorBias("LEFT", 0);
            $v = contributorBiasArray;
        }

        private ContributorBias(String string2, int n2) {
        }
    }

    private class ContributorListener
    implements PropertyChangeListener,
    ChangeListener,
    AncestorListener {
        private Timer _editTimer;

        public void propertyChange(PropertyChangeEvent pce) {
            String propName = pce.getPropertyName();
            if ("modified".equals(propName) || "editable".equals(propName)) {
                BaseCompareView.this.updateTitles();
            }
        }

        public void stateChanged(ChangeEvent ce) {
            this.updateOnEditLater();
        }

        private void updateOnEditLater() {
            if (this._editTimer == null) {
                this._editTimer = new Timer(500, new 1());
                this._editTimer.setRepeats(false);
            }
            if (this._editTimer.isRunning()) {
                this._editTimer.restart();
            } else {
                this._editTimer.start();
            }
        }

        private void updateOnEditImmediately() {
            if (BaseCompareView.this.getGUI().isDisplayable()) {
                BaseCompareView.this.updateOnEdit();
            }
        }

        public void ancestorAdded(AncestorEvent event) {
            this.updateOnEditImmediately();
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }

        private ContributorListener() {
        }

        ContributorListener(1 var2_2) {
            this();
        }

        static Timer ra$_editTimer(ContributorListener contributorListener) {
            return contributorListener._editTimer;
        }

        static void mav$updateOnEditImmediately(ContributorListener contributorListener) {
            contributorListener.updateOnEditImmediately();
        }

        final class oracle.javatools.compare.view.BaseCompareView$ContributorListener$1
        implements ActionListener {
            public void actionPerformed(ActionEvent ae) {
                EventQueue.invokeLater(new 1());
                ContributorListener.ra$_editTimer(ContributorListener.this).stop();
            }

            final class 1
            implements Runnable {
                public void run() {
                    ContributorListener.mav$updateOnEditImmediately(ContributorListener.this);
                }
            }
        }
    }

    private class MarkResolvedAction
    extends AbstractAction {
        private final CompareDifference _difference;

        public MarkResolvedAction(CompareDifference difference) {
            super(BaseCompareView.this.getBundle().getString("RESOLVE_ACTION_NAME"));
            this._difference = difference;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this._difference.isResolved()) {
                return;
            }
            BaseCompareView.this.markResolved(this._difference);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class MarkAllResolvedAction
    extends AbstractAction {
        private final CompareModel _compareModel;

        public MarkAllResolvedAction(CompareModel compareModel) {
            super(BaseCompareView.this.getBundle().getString("RESOLVE_ALL_ACTION_NAME"));
            this._compareModel = compareModel;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this._compareModel.getResolvedCount() >= this._compareModel.getConflictCount()) {
                return;
            }
            BaseCompareView.this.markAllResolved(this._compareModel);
            BaseCompareView.this.updateOnEdit();
        }
    }

    public class CentralGutterMouseHandler
    extends MouseAdapter {
        private JPopupMenu _popupMenu;

        private void $init$() {
            this._popupMenu = null;
        }

        private void performDefaultEditAction(DiffGutter gutter, Point mousePos) {
            ContributorKind adjacentContributor;
            CompareDifference db = gutter.getBlockAtPoint(mousePos);
            if (db == null) {
                return;
            }
            ContributorKind contributor = gutter.getContributorAtPoint(mousePos);
            Action action = BaseCompareView.this.getDefaultEditAction(db, contributor, adjacentContributor = gutter.getOtherContributorKind(contributor));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this, 1001, (String)action.getValue("ActionCommandKey")));
            }
        }

        private void showEditPopup(DiffGutter gutter, Point mousePos) {
            ContributorKind adjacentContributor;
            CompareDifference db = gutter.getBlockAtPoint(mousePos);
            if (db == null) {
                return;
            }
            ContributorKind contributor = gutter.getContributorAtPoint(mousePos);
            Action[] editActions = BaseCompareView.this.getEditActions(db, contributor, adjacentContributor = gutter.getOtherContributorKind(contributor));
            if (editActions == null || editActions.length == 0) {
                return;
            }
            this._popupMenu = new JPopupMenu();
            int i = 0;
            while (i < editActions.length) {
                if (editActions[i] == null) {
                    this._popupMenu.addSeparator();
                } else {
                    this._popupMenu.add(editActions[i]);
                }
                ++i;
            }
            1 pmListener = new 1();
            this._popupMenu.addPopupMenuListener(pmListener);
            MenuUtils.showPopupMenu((JPopupMenu)this._popupMenu, (Component)gutter, (int)mousePos.x, (int)mousePos.y);
        }

        public void mouseReleased(MouseEvent me) {
            DiffGutter gutter = (DiffGutter)me.getSource();
            if (me.getClickCount() == 1) {
                if (me.isPopupTrigger()) {
                    this.showEditPopup(gutter, me.getPoint());
                } else if (me.getButton() == 1) {
                    this.performDefaultEditAction(gutter, me.getPoint());
                }
            }
        }

        public CentralGutterMouseHandler() {
            this.$init$();
        }

        static JPopupMenu ra$_popupMenu(CentralGutterMouseHandler centralGutterMouseHandler) {
            return centralGutterMouseHandler._popupMenu;
        }

        static void wa$_popupMenu(CentralGutterMouseHandler centralGutterMouseHandler, JPopupMenu jPopupMenu) {
            centralGutterMouseHandler._popupMenu = jPopupMenu;
        }

        final class 1
        implements PopupMenuListener {
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                CentralGutterMouseHandler.ra$_popupMenu(CentralGutterMouseHandler.this).removePopupMenuListener(this);
                CentralGutterMouseHandler.ra$_popupMenu(CentralGutterMouseHandler.this).removeAll();
                CentralGutterMouseHandler.wa$_popupMenu(CentralGutterMouseHandler.this, null);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }
    }

    private class ReplaceBlockAction
    extends AbstractAction {
        private final BaseCompareDifference _difference;
        private final ContributorKind _sourceContributor;
        private final ContributorKind _destContributor;

        public ReplaceBlockAction(BaseCompareDifference difference, ContributorKind sourceContributor, ContributorKind destContributor) {
            super(BaseCompareView.this.getBundle().getString("REPLACE_ACTION_NAME"));
            this._difference = difference;
            this._sourceContributor = sourceContributor;
            this._destContributor = destContributor;
        }

        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.replaceBlock(this._difference, this._sourceContributor, this._destContributor);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class InsertBlockAction
    extends AbstractAction {
        private final BaseCompareDifference _difference;
        private final ContributorKind _sourceContributor;
        private final ContributorKind _destContributor;

        public InsertBlockAction(BaseCompareDifference difference, ContributorKind sourceContributor, ContributorKind destContributor) {
            super(BaseCompareView.this.getBundle().getString("INSERT_ACTION_NAME"));
            this._difference = difference;
            this._sourceContributor = sourceContributor;
            this._destContributor = destContributor;
        }

        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.insertBlockCopy(this._difference, this._sourceContributor, this._destContributor);
            BaseCompareView.this.updateOnEdit();
        }
    }

    private class DeleteBlockAction
    extends AbstractAction {
        private final BaseCompareDifference _difference;
        private final ContributorKind _contributor;

        public DeleteBlockAction(ContributorKind contributor, BaseCompareDifference difference) {
            super(BaseCompareView.this.getBundle().getString("REMOVE_ACTION_NAME"));
            this._contributor = contributor;
            this._difference = difference;
        }

        public void actionPerformed(ActionEvent ae) {
            BaseCompareView.this.deleteBlock(this._difference, this._contributor);
            BaseCompareView.this.updateOnEdit();
        }
    }
}

