/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;

public class ObjectArrayFactory
extends ObjectFactory {
    private AssemblyFactory _objectFactory;
    private static final byte OBJECT_ARRAY_CODE = 10;

    public ObjectArrayFactory(AssemblyFactory objectFactory) {
        this._objectFactory = objectFactory;
    }

    public byte getObjectCode() {
        return 10;
    }

    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = input.readInt();
        Object[] array = new Object[len];
        int i = 0;
        while (i < len) {
            array[i] = this._objectFactory.assemble(input);
            ++i;
        }
        return array;
    }

    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        Object[] array = (Object[])object;
        int len = array.length;
        output.writeInt(len);
        int i = 0;
        while (i < len) {
            this._objectFactory.disassemble(array[i], output);
            ++i;
        }
    }
}

