/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class IntArrayFactory
extends ObjectFactory {
    public static final IntArrayFactory INT_ARRAY_FACTORY = new IntArrayFactory();
    private static final byte INT_ARRAY_CODE = 26;

    private IntArrayFactory() {
    }

    public byte getObjectCode() {
        return 26;
    }

    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = input.readInt();
        int[] array = new int[len];
        int i = 0;
        while (i < len) {
            array[i] = input.readInt();
            ++i;
        }
        return array;
    }

    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        int[] array = (int[])object;
        int len = array.length;
        output.writeInt(len);
        int i = 0;
        while (i < len) {
            output.writeInt(array[i]);
            ++i;
        }
    }
}

