/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.odm.binning;

import java.sql.Connection;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dmt.dm4j.DM4JConnectionManager;

public class DropDBObjectThread
extends Thread {
    String m_schemaName;
    String m_tableName;
    String m_objectType;
    boolean m_bPurge;
    boolean m_bDebug;

    DropDBObjectThread(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.m_schemaName = string2;
        this.m_tableName = string;
        this.m_objectType = string3;
        this.m_bPurge = bl;
        this.m_bDebug = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_tableName == null) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        String string = null;
        try {
            boolean bl;
            connection = DM4JConnectionManager.getDbConnection();
            boolean bl2 = 0 == this.m_objectType.compareTo("TABLE");
            boolean bl3 = bl = 0 == this.m_objectType.compareTo("VIEW");
            if (!bl2 && !bl) {
                return;
            }
            if (this.m_tableName == null || this.m_tableName.length() == 0) {
                return;
            }
            if (this.m_schemaName == null || this.m_schemaName.length() == 0) {
                return;
            }
            string = "DROP {2} {0}.{1}";
            Object[] objectArray = new Object[]{this.m_schemaName, this.m_tableName, this.m_objectType};
            string = MessageFormat.format(string, objectArray) + (bl2 && this.m_bPurge ? " PURGE" : "");
            statement = connection.prepareCall(string);
            statement.execute();
            if (this.m_bDebug) {
                System.out.println("SUCCESS: Object " + this.m_schemaName + "." + this.m_tableName + " was removed");
            }
        }
        catch (Exception exception) {
            if (this.m_bDebug) {
                System.out.println("EROR: Object" + this.m_schemaName + "." + this.m_tableName + " wasn't removed. Reason: " + exception);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

