/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.jdmresult;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.StringTokenizer;
import javax.datamining.ExecutionHandle;
import javax.datamining.JDMException;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.jdmresult.OraNamedObject;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraExplainTask;

public class OraMiningExplainResult
implements MiningObject {
    private NamedObject m_objectType = OraNamedObject.explainResults;
    private String m_description = "";
    private String m_name = "";
    private String m_creatorInfo = "";
    private String m_identifier = "";
    private Timestamp m_startingTimestamp;
    private Timestamp m_completionTimestamp;
    private String m_explainAttributeName;
    private String m_inputTableName;
    private String m_inputSchemaNamea;
    private String m_explainOutputTableName;
    private String m_taskName = "";
    private static final String SQL_MINING_EXPLAIN = "SELECT * FROM  DM4J$RESULTS_STATE_V WHERE TYPE='EXPLN' AND RESULT_NAME = {result}";
    private static final String CREATION_DATE = "CREATION_DATE";
    private static final String TASK = "TASK_NAME";

    OraMiningExplainResult() {
    }

    public NamedObject getObjectType() {
        return this.m_objectType;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) throws JDMException {
        this.m_description = string;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String string) throws JDMException {
        this.m_name = string;
        this.m_identifier = this.getObjectType().name() + "_" + string;
    }

    public String getTaskName() {
        return this.m_taskName;
    }

    public void setTaskName(String string) throws JDMException {
        this.m_taskName = string;
    }

    protected void setCreatorInfo(String string) throws JDMException {
        this.m_creatorInfo = string;
    }

    public String getCreatorInfo() {
        return this.m_creatorInfo;
    }

    protected void setCreationDate(Date date) throws JDMException {
        this.m_startingTimestamp = new Timestamp(date.getTime());
    }

    public Date getCreationDate() {
        return new Date(this.m_startingTimestamp.getTime());
    }

    protected void setCompletionTimestamp(Date date) {
        this.m_completionTimestamp = new Timestamp(date.getTime());
    }

    public Timestamp getCompletionTimestamp() {
        return this.m_completionTimestamp;
    }

    public String getObjectIdentifier() {
        return this.m_identifier;
    }

    protected void setObjectIdentifier(String string) throws JDMException {
        this.m_identifier = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MiningObject restore(javax.datamining.resource.Connection connection, String string) {
        OraMiningExplainResult oraMiningExplainResult = new OraMiningExplainResult();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection2 = null;
        try {
            connection2 = ((OraConnection)connection).getDatabaseConnection();
            string = DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string;
            string = "'" + DatabaseMetadata.getReplacedString(string, "'", "''") + "'";
            String string2 = DatabaseMetadata.getReplacedString(SQL_MINING_EXPLAIN, "{result}", string);
            statement = connection2.prepareStatement(string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string3;
                String string4 = resultSet.getString(TASK);
                if (string4 == null) continue;
                oraMiningExplainResult.setTaskName(string4);
                OraExplainTask oraExplainTask = (OraExplainTask)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string4), NamedObject.task);
                if (oraExplainTask == null) continue;
                String string5 = oraExplainTask.getInputData();
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ".", false);
                int n = stringTokenizer.countTokens();
                if (n == 2) {
                    string3 = stringTokenizer.nextToken();
                    oraMiningExplainResult.setInputTableName(stringTokenizer.nextToken());
                } else {
                    string3 = null;
                    oraMiningExplainResult.setInputTableName(string5);
                }
                if (string3 == null) {
                    string3 = connection2.getMetaData().getUserName();
                }
                oraMiningExplainResult.setInputSchemaName(string3);
                oraMiningExplainResult.setExplainAttributeName(oraExplainTask.getExplainAttributeName());
                String string6 = oraExplainTask.getOutputData();
                oraMiningExplainResult.setExplainOutputTableName(string6);
                ExecutionHandle executionHandle = oraExplainTask.getExecutionHandle();
                Date date = executionHandle.getStartTime();
                if (date == null) continue;
                oraMiningExplainResult.setCreationDate(date);
                Integer n2 = executionHandle.getDurationInSeconds();
                if (n2 == null) continue;
                Date date2 = new Date(date.getTime() + (long)(n2 * 1000));
                oraMiningExplainResult.setCompletionTimestamp(date2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return oraMiningExplainResult;
    }

    public Timestamp getStartingTimestamp() {
        return this.m_startingTimestamp;
    }

    public String getExplainAttributeName() {
        return this.m_explainAttributeName;
    }

    protected void setExplainAttributeName(String string) {
        this.m_explainAttributeName = string;
    }

    protected void setInputTableName(String string) {
        this.m_inputTableName = string;
    }

    public String getInputTableName() {
        return this.m_inputTableName;
    }

    protected void setInputSchemaName(String string) {
        this.m_inputSchemaNamea = string;
    }

    public String getSchemaName() {
        return this.m_inputSchemaNamea;
    }

    protected void setExplainOutputTableName(String string) {
        this.m_explainOutputTableName = string;
    }

    public String getExplainOutputTableName() {
        return this.m_explainOutputTableName;
    }
}

